/*
 * Decompiled with CFR 0.152.
 */
package kafka.raft;

import java.io.File;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import kafka.log.LogManager$;
import kafka.log.UnifiedLog$;
import kafka.server.KafkaConfig;
import kafka.utils.FileLock;
import org.apache.kafka.common.KafkaException;
import org.apache.kafka.common.internals.Topic;
import org.apache.kafka.common.utils.Utils;
import scala.Function1;
import scala.None$;
import scala.Some;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.runtime.BoxedUnit;

public final class KafkaRaftManager$ {
    public static KafkaRaftManager$ MODULE$;

    static {
        new KafkaRaftManager$();
    }

    public File kafka$raft$KafkaRaftManager$$createLogDirectory(File logDir, String logDirName) {
        String logDirPath = logDir.getAbsolutePath();
        File dir = new File(logDirPath, logDirName);
        Files.createDirectories(dir.toPath(), new FileAttribute[0]);
        return dir;
    }

    public FileLock kafka$raft$KafkaRaftManager$$lockDataDir(File dataDir) {
        FileLock lock = new FileLock(new File(dataDir, LogManager$.MODULE$.LockFileName()));
        if (!lock.tryLock()) {
            throw new KafkaException(new StringBuilder(112).append("Failed to acquire lock on file .lock in ").append(lock.file().getParent()).append(". A Kafka instance in another process or ").append("thread is using this directory.").toString());
        }
        return lock;
    }

    public boolean kafka$raft$KafkaRaftManager$$hasDifferentLogDir(KafkaConfig config) {
        return !((SeqLike)config.logDirs().map((Function1 & Serializable & scala.Serializable)x$1 -> Paths.get(x$1, new String[0]).toAbsolutePath(), Seq$.MODULE$.canBuildFrom())).contains((Object)Paths.get(config.metadataLogDir(), new String[0]).toAbsolutePath());
    }

    public void maybeDeleteMetadataLogDir(KafkaConfig config) {
        if (config.processRoles().nonEmpty()) {
            throw new RuntimeException("Not deleting metadata log dir since this node is in KRaft mode.");
        }
        if (!config.migrationEnabled()) {
            throw new RuntimeException("Not deleting metadata log dir since migrations are not enabled.");
        }
        File metadataDir = new File(config.metadataLogDir());
        String logDirName = UnifiedLog$.MODULE$.logDirName(Topic.CLUSTER_METADATA_TOPIC_PARTITION);
        File metadataPartitionDir = this.kafka$raft$KafkaRaftManager$$createLogDirectory(metadataDir, logDirName);
        None$ deletionLock = this.kafka$raft$KafkaRaftManager$$hasDifferentLogDir(config) ? new Some((Object)this.kafka$raft$KafkaRaftManager$$lockDataDir(metadataDir)) : None$.MODULE$;
        try {
            try {
                Utils.delete((File)metadataPartitionDir);
            }
            catch (Throwable t) {
                throw new RuntimeException("Failed to delete metadata log", t);
            }
        }
        finally {
            deletionLock.foreach((Function1 & Serializable & scala.Serializable)x$2 -> {
                x$2.destroy();
                return BoxedUnit.UNIT;
            });
        }
    }

    private KafkaRaftManager$() {
        MODULE$ = this;
    }
}

