/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.processor.internals.assignment;

import java.util.Map;
import java.util.Set;
import org.apache.kafka.streams.processor.TaskId;
import org.apache.kafka.streams.processor.internals.TopologyMetadata;
import org.apache.kafka.streams.processor.internals.assignment.AssignorConfiguration;
import org.apache.kafka.streams.processor.internals.assignment.BalanceSubtopologyGraphConstructor;
import org.apache.kafka.streams.processor.internals.assignment.MinTrafficGraphConstructor;
import org.apache.kafka.streams.processor.internals.assignment.RackAwareGraphConstructor;

public class RackAwareGraphConstructorFactory {
    static RackAwareGraphConstructor create(AssignorConfiguration.AssignmentConfigs assignmentConfigs, Map<TopologyMetadata.Subtopology, Set<TaskId>> tasksForTopicGroup) {
        switch (assignmentConfigs.rackAwareAssignmentStrategy) {
            case "min_traffic": {
                return new MinTrafficGraphConstructor();
            }
            case "balance_subtopology": {
                return new BalanceSubtopologyGraphConstructor(tasksForTopicGroup);
            }
        }
        throw new IllegalArgumentException("Rack aware assignment is disabled");
    }
}

