/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.http.entity;

import java.io.IOException;
import java.nio.charset.Charset;
import java.util.function.Supplier;
import org.apache.juneau.http.entity.BasicHttpEntity;
import org.apache.juneau.http.header.ContentEncoding;
import org.apache.juneau.http.header.ContentType;
import org.apache.juneau.internal.FluentSetter;
import org.apache.juneau.internal.FluentSetters;
import org.apache.juneau.internal.ThrowableUtils;

@FluentSetters(returns="HttpEntityBuilder<T>")
public class HttpEntityBuilder<T extends BasicHttpEntity> {
    boolean cached;
    boolean chunked;
    Object content;
    Supplier<?> contentSupplier;
    ContentType contentType;
    ContentEncoding contentEncoding;
    Charset charset;
    long contentLength = -1L;
    protected final Class<? extends BasicHttpEntity> implClass;

    public HttpEntityBuilder(Class<T> implClass) {
        this.implClass = implClass;
    }

    public HttpEntityBuilder(T impl) {
        this.implClass = impl.getClass();
        this.cached = ((BasicHttpEntity)impl).cached;
        this.content = ((BasicHttpEntity)impl).content;
        this.contentSupplier = ((BasicHttpEntity)impl).contentSupplier;
        this.contentType = ((BasicHttpEntity)impl).contentType;
        this.contentEncoding = ((BasicHttpEntity)impl).contentEncoding;
        this.charset = ((BasicHttpEntity)impl).charset;
        this.contentLength = ((BasicHttpEntity)impl).contentLength;
    }

    public T build() {
        try {
            return (T)this.implClass.getConstructor(HttpEntityBuilder.class).newInstance(this);
        }
        catch (Exception e) {
            throw ThrowableUtils.runtimeException(e);
        }
    }

    @FluentSetter
    public HttpEntityBuilder<T> content(Object value) {
        this.content = value;
        return this;
    }

    @FluentSetter
    public HttpEntityBuilder<T> content(Supplier<?> value) {
        this.contentSupplier = value == null ? () -> null : value;
        return this;
    }

    @FluentSetter
    public HttpEntityBuilder<T> contentType(String value) {
        return this.contentType(ContentType.of(value));
    }

    @FluentSetter
    public HttpEntityBuilder<T> contentType(ContentType value) {
        this.contentType = value;
        return this;
    }

    @FluentSetter
    public HttpEntityBuilder<T> contentLength(long value) {
        this.contentLength = value;
        return this;
    }

    @FluentSetter
    public HttpEntityBuilder<T> contentEncoding(String value) {
        return this.contentEncoding(ContentEncoding.of(value));
    }

    @FluentSetter
    public HttpEntityBuilder<T> contentEncoding(ContentEncoding value) {
        this.contentEncoding = value;
        return this;
    }

    @FluentSetter
    public HttpEntityBuilder<T> chunked() {
        return this.chunked(true);
    }

    @FluentSetter
    public HttpEntityBuilder<T> chunked(boolean value) {
        this.chunked = value;
        return this;
    }

    @FluentSetter
    public HttpEntityBuilder<T> cached() throws IOException {
        this.cached = true;
        return this;
    }
}

