/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.reflect;

import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Executable;
import java.lang.reflect.Modifier;
import java.lang.reflect.Parameter;
import java.lang.reflect.Type;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Predicate;
import org.apache.juneau.Visibility;
import org.apache.juneau.internal.CollectionUtils;
import org.apache.juneau.internal.ConsumerUtils;
import org.apache.juneau.internal.FluentSetter;
import org.apache.juneau.internal.FluentSetters;
import org.apache.juneau.internal.StringUtils;
import org.apache.juneau.internal.ThrowableUtils;
import org.apache.juneau.reflect.ClassInfo;
import org.apache.juneau.reflect.ParamInfo;
import org.apache.juneau.reflect.ReflectFlags;

@FluentSetters
public abstract class ExecutableInfo {
    final ClassInfo declaringClass;
    final Executable e;
    final boolean isConstructor;
    private volatile ParamInfo[] params;
    private volatile ClassInfo[] paramTypes;
    private volatile ClassInfo[] exceptionInfos;
    private volatile Class<?>[] rawParamTypes;
    private volatile Type[] rawGenericParamTypes;
    private volatile Parameter[] rawParameters;
    private volatile Annotation[][] parameterAnnotations;
    private volatile Annotation[] declaredAnnotations;

    protected ExecutableInfo(ClassInfo declaringClass, Executable e) {
        this.declaringClass = declaringClass;
        this.e = e;
        this.isConstructor = e instanceof Constructor;
    }

    public final ClassInfo getDeclaringClass() {
        return this.declaringClass;
    }

    public final boolean isConstructor() {
        return this.isConstructor;
    }

    public final int getParamCount() {
        return this.e.getParameterCount();
    }

    public final boolean hasParams() {
        return this.getParamCount() != 0;
    }

    public final boolean hasNoParams() {
        return this.getParamCount() == 0;
    }

    public final boolean hasNumParams(int number) {
        return this.getParamCount() == number;
    }

    public final List<ParamInfo> getParams() {
        return CollectionUtils.ulist(this._getParams());
    }

    public ExecutableInfo forEachParam(Predicate<ParamInfo> filter, Consumer<ParamInfo> action) {
        for (ParamInfo pi : this._getParams()) {
            if (!ConsumerUtils.test(filter, pi)) continue;
            action.accept(pi);
        }
        return this;
    }

    public final ParamInfo getParam(int index) {
        this.checkIndex(index);
        return this._getParams()[index];
    }

    public final List<ClassInfo> getParamTypes() {
        return CollectionUtils.ulist(this._getParameterTypes());
    }

    public final ClassInfo getParamType(int index) {
        this.checkIndex(index);
        return this._getParameterTypes()[index];
    }

    public final List<Class<?>> getRawParamTypes() {
        return CollectionUtils.ulist(this._getRawParamTypes());
    }

    public final Class<?> getRawParamType(int index) {
        this.checkIndex(index);
        return this._getRawParamTypes()[index];
    }

    public final List<Type> getRawGenericParamTypes() {
        return CollectionUtils.ulist(this._getRawGenericParamTypes());
    }

    public final Type getRawGenericParamType(int index) {
        this.checkIndex(index);
        return this._getRawGenericParamTypes()[index];
    }

    public final List<Parameter> getRawParameters() {
        return CollectionUtils.ulist(this._getRawParameters());
    }

    public final Parameter getRawParameter(int index) {
        this.checkIndex(index);
        return this._getRawParameters()[index];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final ParamInfo[] _getParams() {
        if (this.params == null) {
            ExecutableInfo executableInfo = this;
            synchronized (executableInfo) {
                Parameter[] rp = this._getRawParameters();
                ParamInfo[] l = new ParamInfo[rp.length];
                for (int i = 0; i < rp.length; ++i) {
                    l[i] = new ParamInfo(this, rp[i], i);
                }
                this.params = l;
            }
        }
        return this.params;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final ClassInfo[] _getParameterTypes() {
        if (this.paramTypes == null) {
            ExecutableInfo executableInfo = this;
            synchronized (executableInfo) {
                int i;
                Class<?>[] ptc = this._getRawParamTypes();
                Type[] ptt = this._getRawGenericParamTypes();
                if (ptt.length != ptc.length) {
                    if (ptt.length + 1 == ptc.length) {
                        Type[] ptt2 = new Type[ptc.length];
                        ptt2[0] = ptc[0];
                        for (i = 0; i < ptt.length; ++i) {
                            ptt2[i + 1] = ptt[i];
                        }
                        ptt = ptt2;
                    } else {
                        ptt = ptc;
                    }
                }
                ClassInfo[] l = new ClassInfo[ptc.length];
                for (i = 0; i < ptc.length; ++i) {
                    l[i] = ClassInfo.of(ptc[i], ptt[i]);
                }
                this.paramTypes = l;
            }
        }
        return this.paramTypes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Class<?>[] _getRawParamTypes() {
        if (this.rawParamTypes == null) {
            ExecutableInfo executableInfo = this;
            synchronized (executableInfo) {
                this.rawParamTypes = this.e.getParameterTypes();
            }
        }
        return this.rawParamTypes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final Type[] _getRawGenericParamTypes() {
        if (this.rawGenericParamTypes == null) {
            ExecutableInfo executableInfo = this;
            synchronized (executableInfo) {
                this.rawGenericParamTypes = this.e.getGenericParameterTypes();
            }
        }
        return this.rawGenericParamTypes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final Parameter[] _getRawParameters() {
        if (this.rawParameters == null) {
            ExecutableInfo executableInfo = this;
            synchronized (executableInfo) {
                this.rawParameters = this.e.getParameters();
            }
        }
        return this.rawParameters;
    }

    private void checkIndex(int index) {
        int pc = this.getParamCount();
        if (pc == 0) {
            throw new IndexOutOfBoundsException(StringUtils.format("Invalid index ''{0}''.  No parameters.", index));
        }
        if (index < 0 || index >= pc) {
            throw new IndexOutOfBoundsException(StringUtils.format("Invalid index ''{0}''.  Parameter count: {1}", index, pc));
        }
    }

    public final <A extends Annotation> ExecutableInfo forEachParameterAnnotation(int index, Class<A> type, Predicate<A> predicate, Consumer<A> consumer) {
        for (Annotation a : this._getParameterAnnotations(index)) {
            if (!type.isInstance(a)) continue;
            ConsumerUtils.consume(predicate, consumer, type.cast(a));
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final Annotation[][] _getParameterAnnotations() {
        if (this.parameterAnnotations == null) {
            ExecutableInfo executableInfo = this;
            synchronized (executableInfo) {
                this.parameterAnnotations = this.e.getParameterAnnotations();
            }
        }
        return this.parameterAnnotations;
    }

    final Annotation[] _getParameterAnnotations(int index) {
        this.checkIndex(index);
        Annotation[][] x = this._getParameterAnnotations();
        int c = this.e.getParameterCount();
        if (c != x.length) {
            int i;
            Annotation[][] x2 = new Annotation[c][];
            int diff = c - x.length;
            for (i = 0; i < diff; ++i) {
                x2[i] = new Annotation[0];
            }
            for (i = diff; i < c; ++i) {
                x2[i] = x[i - diff];
            }
            x = x2;
        }
        return x[index];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final Annotation[] _getDeclaredAnnotations() {
        if (this.declaredAnnotations == null) {
            ExecutableInfo executableInfo = this;
            synchronized (executableInfo) {
                this.declaredAnnotations = this.e.getDeclaredAnnotations();
            }
        }
        return this.declaredAnnotations;
    }

    public final List<ClassInfo> getExceptionTypes() {
        return CollectionUtils.ulist(this._getExceptionTypes());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final ClassInfo[] _getExceptionTypes() {
        if (this.exceptionInfos == null) {
            ExecutableInfo executableInfo = this;
            synchronized (executableInfo) {
                Class<?>[] exceptionTypes = this.e.getExceptionTypes();
                ClassInfo[] l = new ClassInfo[exceptionTypes.length];
                for (int i = 0; i < exceptionTypes.length; ++i) {
                    l[i] = ClassInfo.of(exceptionTypes[i]);
                }
                this.exceptionInfos = l;
            }
        }
        return this.exceptionInfos;
    }

    public final boolean isAll(ReflectFlags ... flags) {
        block14: for (ReflectFlags f : flags) {
            switch (f) {
                case DEPRECATED: {
                    if (!this.isNotDeprecated()) continue block14;
                    return false;
                }
                case NOT_DEPRECATED: {
                    if (!this.isDeprecated()) continue block14;
                    return false;
                }
                case HAS_PARAMS: {
                    if (!this.hasNoParams()) continue block14;
                    return false;
                }
                case HAS_NO_PARAMS: {
                    if (!this.hasParams()) continue block14;
                    return false;
                }
                case PUBLIC: {
                    if (!this.isNotPublic()) continue block14;
                    return false;
                }
                case NOT_PUBLIC: {
                    if (!this.isPublic()) continue block14;
                    return false;
                }
                case PROTECTED: {
                    if (!this.isNotProtected()) continue block14;
                    return false;
                }
                case NOT_PROTECTED: {
                    if (!this.isProtected()) continue block14;
                    return false;
                }
                case STATIC: {
                    if (!this.isNotStatic()) continue block14;
                    return false;
                }
                case NOT_STATIC: {
                    if (!this.isStatic()) continue block14;
                    return false;
                }
                case ABSTRACT: {
                    if (!this.isNotAbstract()) continue block14;
                    return false;
                }
                case NOT_ABSTRACT: {
                    if (!this.isAbstract()) continue block14;
                    return false;
                }
                default: {
                    throw ThrowableUtils.runtimeException("Invalid flag for executable: {0}", new Object[]{f});
                }
            }
        }
        return true;
    }

    public final boolean is(ReflectFlags ... flags) {
        return this.isAll(flags);
    }

    public final boolean isAny(ReflectFlags ... flags) {
        block14: for (ReflectFlags f : flags) {
            switch (f) {
                case DEPRECATED: {
                    if (!this.isDeprecated()) continue block14;
                    return true;
                }
                case NOT_DEPRECATED: {
                    if (!this.isNotDeprecated()) continue block14;
                    return true;
                }
                case HAS_PARAMS: {
                    if (!this.hasParams()) continue block14;
                    return true;
                }
                case HAS_NO_PARAMS: {
                    if (!this.hasNoParams()) continue block14;
                    return true;
                }
                case PUBLIC: {
                    if (!this.isPublic()) continue block14;
                    return true;
                }
                case NOT_PUBLIC: {
                    if (!this.isNotPublic()) continue block14;
                    return true;
                }
                case PROTECTED: {
                    if (!this.isProtected()) continue block14;
                    return true;
                }
                case NOT_PROTECTED: {
                    if (!this.isNotProtected()) continue block14;
                    return true;
                }
                case STATIC: {
                    if (!this.isStatic()) continue block14;
                    return true;
                }
                case NOT_STATIC: {
                    if (!this.isNotStatic()) continue block14;
                    return true;
                }
                case ABSTRACT: {
                    if (!this.isAbstract()) continue block14;
                    return true;
                }
                case NOT_ABSTRACT: {
                    if (!this.isNotAbstract()) continue block14;
                    return true;
                }
                default: {
                    throw ThrowableUtils.runtimeException("Invalid flag for executable: {0}", new Object[]{f});
                }
            }
        }
        return false;
    }

    public final boolean hasParamTypes(Class<?> ... args) {
        Class<?>[] pt = this._getRawParamTypes();
        if (pt.length == args.length) {
            for (int i = 0; i < pt.length; ++i) {
                if (pt[i].equals(args[i])) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public final boolean hasParamTypes(ClassInfo ... args) {
        Class<?>[] pt = this._getRawParamTypes();
        if (pt.length == args.length) {
            for (int i = 0; i < pt.length; ++i) {
                if (pt[i].equals(args[i].inner())) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public final boolean hasMatchingParamTypes(Class<?> ... args) {
        ClassInfo[] pt = this._getParameterTypes();
        if (pt.length != args.length) {
            return false;
        }
        for (int i = 0; i < pt.length; ++i) {
            boolean matched = false;
            for (int j = 0; j < args.length; ++j) {
                if (!pt[i].isParentOfFuzzyPrimitives(args[j])) continue;
                matched = true;
            }
            if (matched) continue;
            return false;
        }
        return true;
    }

    public final boolean hasMatchingParamTypes(ClassInfo ... args) {
        ClassInfo[] pt = this._getParameterTypes();
        if (pt.length != args.length) {
            return false;
        }
        for (int i = 0; i < pt.length; ++i) {
            boolean matched = false;
            for (int j = 0; j < args.length; ++j) {
                if (!pt[i].isParentOfFuzzyPrimitives(args[j].inner())) continue;
                matched = true;
            }
            if (matched) continue;
            return false;
        }
        return true;
    }

    public final boolean hasFuzzyParamTypes(Class<?> ... args) {
        return this.fuzzyArgsMatch(args) != -1;
    }

    public final int fuzzyArgsMatch(Class<?> ... argTypes) {
        int matches = 0;
        block0: for (ClassInfo pi : this.getParamTypes()) {
            for (Class<?> a : argTypes) {
                if (!pi.isParentOfFuzzyPrimitives(a)) continue;
                ++matches;
                continue block0;
            }
            return -1;
        }
        return matches;
    }

    public final int fuzzyArgsMatch(Object ... argTypes) {
        int matches = 0;
        block0: for (ClassInfo pi : this.getParamTypes()) {
            for (Object a : argTypes) {
                if (!pi.canAcceptArg(a)) continue;
                ++matches;
                continue block0;
            }
            return -1;
        }
        return matches;
    }

    public final boolean hasFuzzyParamTypes(ClassInfo ... args) {
        return this.fuzzyArgsMatch(args) != -1;
    }

    public final int fuzzyArgsMatch(ClassInfo ... argTypes) {
        int matches = 0;
        block0: for (ClassInfo pi : this.getParamTypes()) {
            for (ClassInfo a : argTypes) {
                if (!pi.isParentOfFuzzyPrimitives(a)) continue;
                ++matches;
                continue block0;
            }
            return -1;
        }
        return matches;
    }

    public final boolean isDeprecated() {
        return this.e.isAnnotationPresent(Deprecated.class);
    }

    public final boolean isNotDeprecated() {
        return !this.e.isAnnotationPresent(Deprecated.class);
    }

    public final boolean isAbstract() {
        return Modifier.isAbstract(this.e.getModifiers());
    }

    public final boolean isNotAbstract() {
        return !Modifier.isAbstract(this.e.getModifiers());
    }

    public final boolean isPublic() {
        return Modifier.isPublic(this.e.getModifiers());
    }

    public final boolean isNotPublic() {
        return !Modifier.isPublic(this.e.getModifiers());
    }

    public final boolean isProtected() {
        return Modifier.isProtected(this.e.getModifiers());
    }

    public final boolean isNotProtected() {
        return !Modifier.isProtected(this.e.getModifiers());
    }

    public final boolean isStatic() {
        return Modifier.isStatic(this.e.getModifiers());
    }

    public final boolean isNotStatic() {
        return !Modifier.isStatic(this.e.getModifiers());
    }

    @FluentSetter
    public ExecutableInfo accessible() {
        this.setAccessible();
        return this;
    }

    public final boolean setAccessible() {
        try {
            if (!this.e.isAccessible()) {
                this.e.setAccessible(true);
            }
            return true;
        }
        catch (SecurityException e) {
            return false;
        }
    }

    public final boolean isVisible(Visibility v) {
        return v.isVisible(this.e);
    }

    public final boolean hasName(String name) {
        return this.getSimpleName().equals(name);
    }

    public final boolean hasName(String ... names) {
        for (String n : names) {
            if (!this.getSimpleName().equals(n)) continue;
            return true;
        }
        return false;
    }

    public final boolean hasName(Set<String> names) {
        return names.contains(this.getSimpleName());
    }

    public final String getFullName() {
        StringBuilder sb = new StringBuilder(128);
        ClassInfo dc = this.declaringClass;
        Package p = dc.getPackage();
        if (p != null) {
            sb.append(p.getName()).append('.');
        }
        dc.appendShortName(sb);
        if (!this.isConstructor) {
            sb.append('.').append(this.getSimpleName());
        }
        sb.append('(');
        List<ClassInfo> pt = this.getParamTypes();
        for (int i = 0; i < pt.size(); ++i) {
            if (i > 0) {
                sb.append(',');
            }
            pt.get(i).appendFullName(sb);
        }
        sb.append(')');
        return sb.toString();
    }

    public final String getShortName() {
        StringBuilder sb = new StringBuilder(64);
        sb.append(this.getSimpleName()).append('(');
        Class<?>[] pt = this._getRawParamTypes();
        for (int i = 0; i < pt.length; ++i) {
            if (i > 0) {
                sb.append(',');
            }
            sb.append(pt[i].getSimpleName());
        }
        sb.append(')');
        return sb.toString();
    }

    public final String getSimpleName() {
        return this.isConstructor ? this.e.getDeclaringClass().getSimpleName() : this.e.getName();
    }

    public String toString() {
        return this.getShortName();
    }
}

