/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.http.annotation;

import java.util.function.Predicate;
import org.apache.juneau.annotation.AnnotationBuilder;
import org.apache.juneau.annotation.AnnotationImpl;
import org.apache.juneau.collections.JsonMap;
import org.apache.juneau.http.annotation.ExternalDocs;
import org.apache.juneau.internal.ArrayUtils;
import org.apache.juneau.internal.StringUtils;
import org.apache.juneau.jsonschema.SchemaUtils;
import org.apache.juneau.parser.ParseException;

public class ExternalDocsAnnotation {
    public static final ExternalDocs DEFAULT = ExternalDocsAnnotation.create().build();

    public static Builder create() {
        return new Builder();
    }

    public static boolean empty(ExternalDocs a) {
        return a == null || DEFAULT.equals(a);
    }

    public static JsonMap merge(JsonMap m, ExternalDocs a) throws ParseException {
        if (ExternalDocsAnnotation.empty(a)) {
            return m;
        }
        Predicate<String> ne = StringUtils::isNotEmpty;
        return m.appendIf(ne, "description", SchemaUtils.joinnl(new String[][]{a.description()})).appendIf(ne, "url", a.url());
    }

    private static class Impl
    extends AnnotationImpl
    implements ExternalDocs {
        private final String url;
        private final String[] description;

        Impl(Builder b) {
            super(b);
            this.description = ArrayUtils.copyOf(b.description);
            this.url = b.url;
            this.postConstruct();
        }

        @Override
        public String[] description() {
            return this.description;
        }

        @Override
        public String url() {
            return this.url;
        }
    }

    public static class Builder
    extends AnnotationBuilder {
        String url = "";
        String[] description = new String[0];

        protected Builder() {
            super(ExternalDocs.class);
        }

        public ExternalDocs build() {
            return new Impl(this);
        }

        public Builder description(String ... value) {
            this.description = value;
            return this;
        }

        public Builder url(String value) {
            this.url = value;
            return this;
        }
    }
}

