/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.rest.mock;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import javax.servlet.AsyncContext;
import javax.servlet.DispatcherType;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletInputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpUpgradeHandler;
import javax.servlet.http.Part;
import org.apache.juneau.collections.AList;
import org.apache.juneau.http.header.Date;
import org.apache.juneau.internal.IOUtils;
import org.apache.juneau.internal.StringUtils;
import org.apache.juneau.rest.RestContext;
import org.apache.juneau.rest.mock.MockHttpSession;
import org.apache.juneau.rest.mock.MockServletResponse;
import org.apache.juneau.rest.util.BoundedServletInputStream;
import org.apache.juneau.rest.util.RestUtils;
import org.apache.juneau.urlencoding.UrlEncodingSerializer;
import org.apache.juneau.utils.MockHttpRequest;

@Deprecated
public class MockServletRequest
implements HttpServletRequest,
MockHttpRequest {
    private String method = "GET";
    private Map<String, String[]> queryData;
    private Map<String, String[]> formDataMap;
    private Map<String, String[]> headerMap = new LinkedHashMap<String, String[]>();
    private Map<String, Object> attributeMap = new LinkedHashMap<String, Object>();
    private String characterEncoding = "UTF-8";
    private byte[] body = new byte[0];
    private String protocol = "HTTP/1.1";
    private String scheme = "http";
    private String serverName = "localhost";
    private int serverPort = 8080;
    private String remoteAddr = "";
    private String remoteHost = "";
    private Locale locale = Locale.ENGLISH;
    private String realPath;
    private int remotePort;
    private String localName;
    private String localAddr;
    private int localPort;
    private RequestDispatcher requestDispatcher;
    private ServletContext servletContext;
    private DispatcherType dispatcherType;
    private String authType;
    private Cookie[] cookies;
    private String pathInfo;
    private String pathTranslated;
    private String contextPath = "";
    private String queryString;
    private String remoteUser;
    private Principal userPrincipal;
    private String requestedSessionId;
    private String requestURI;
    private String servletPath = "";
    private HttpSession httpSession = MockHttpSession.create();
    private RestContext restContext;
    private String uri = "";
    private boolean debug = false;

    public static MockServletRequest create() {
        MockServletRequest r = new MockServletRequest();
        return r;
    }

    public static MockServletRequest create(String method, String path, Object ... pathArgs) {
        return MockServletRequest.create().method(method).uri(StringUtils.format(path, pathArgs));
    }

    public MockServletRequest json() {
        return this.header("Accept", "application/json").header("Content-Type", "application/json");
    }

    public MockServletRequest xml() {
        return this.header("Accept", "text/xml").header("Content-Type", "text/xml");
    }

    public MockServletRequest html() {
        return this.header("Accept", "text/html").header("Content-Type", "text/html");
    }

    public MockServletRequest plainText() {
        return this.header("Accept", "text/plain").header("Content-Type", "text/plain");
    }

    public MockServletRequest msgpack() {
        return this.header("Accept", "octal/msgpack").header("Content-Type", "octal/msgpack");
    }

    public MockServletRequest uon() {
        return this.header("Accept", "text/uon").header("Content-Type", "text/uon");
    }

    public MockServletRequest urlEnc() {
        return this.header("Accept", "application/x-www-form-urlencoded").header("Content-Type", "application/x-www-form-urlencoded");
    }

    public MockServletRequest yaml() {
        return this.header("Accept", "text/yaml").header("Content-Type", "text/yaml");
    }

    @Override
    public MockServletRequest uri(String uri) {
        this.uri = StringUtils.emptyIfNull(uri);
        return this;
    }

    public MockServletRequest restContext(RestContext restContext) {
        this.restContext = restContext;
        return this;
    }

    @Override
    public MockServletResponse execute() throws Exception {
        MockServletResponse res = MockServletResponse.create();
        this.restContext.execute(this, res);
        if (res.getStatus() == 0) {
            throw new RuntimeException("Response status was 0.");
        }
        if (this.debug) {
            this.log(this, res);
        }
        return res;
    }

    private void log(MockServletRequest req, MockServletResponse res) {
        StringBuilder sb = new StringBuilder();
        sb.append("\n=== HTTP Call =================================================================");
        sb.append("\n=== REQUEST ===");
        sb.append("\nTODO");
        sb.append("\n=== RESPONSE ===");
        sb.append("\nStatus: ").append(res.getStatus());
        sb.append("\n---response headers---");
        for (Map.Entry<String, String[]> h : res.getHeaders().entrySet()) {
            for (String h2 : h.getValue()) {
                sb.append("\n").append(h.getKey()).append(": ").append(h2);
            }
        }
        sb.append("\n---response content---\n");
        sb.append(res.getBodyAsString());
        sb.append("\n=== END ========================================================================");
        System.err.println(sb);
    }

    @Override
    public MockServletRequest method(String value) {
        this.method = value;
        return this;
    }

    public MockServletRequest characterEncoding(String value) {
        this.characterEncoding = value;
        return this;
    }

    public MockServletRequest protocol(String value) {
        this.protocol = value;
        return this;
    }

    public MockServletRequest scheme(String value) {
        this.scheme = value;
        return this;
    }

    public MockServletRequest serverName(String value) {
        this.serverName = value;
        return this;
    }

    public MockServletRequest serverPort(int value) {
        this.serverPort = value;
        return this;
    }

    public MockServletRequest remoteAddr(String value) {
        this.remoteAddr = value;
        return this;
    }

    public MockServletRequest remoteHost(String value) {
        this.remoteHost = value;
        return this;
    }

    public MockServletRequest locale(Locale value) {
        this.locale = value;
        return this;
    }

    public MockServletRequest realPath(String value) {
        this.realPath = value;
        return this;
    }

    public MockServletRequest remotePort(int value) {
        this.remotePort = value;
        return this;
    }

    public MockServletRequest localName(String value) {
        this.localName = value;
        return this;
    }

    public MockServletRequest localAddr(String value) {
        this.localAddr = value;
        return this;
    }

    public MockServletRequest localPort(int value) {
        this.localPort = value;
        return this;
    }

    public MockServletRequest requestDispatcher(RequestDispatcher value) {
        this.requestDispatcher = value;
        return this;
    }

    public MockServletRequest servletContext(ServletContext value) {
        this.servletContext = value;
        return this;
    }

    public MockServletRequest dispatcherType(DispatcherType value) {
        this.dispatcherType = value;
        return this;
    }

    public MockServletRequest authType(String value) {
        this.authType = value;
        return this;
    }

    public MockServletRequest cookies(Cookie[] value) {
        this.cookies = value;
        return this;
    }

    public MockServletRequest pathInfo(String value) {
        this.pathInfo = value;
        return this;
    }

    public MockServletRequest pathTranslated(String value) {
        this.pathTranslated = value;
        return this;
    }

    public MockServletRequest contextPath(String value) {
        this.contextPath = value;
        return this;
    }

    public MockServletRequest queryString(String value) {
        this.queryString = value;
        return this;
    }

    public MockServletRequest remoteUser(String value) {
        this.remoteUser = value;
        return this;
    }

    public MockServletRequest userPrincipal(Principal value) {
        this.userPrincipal = value;
        return this;
    }

    public MockServletRequest requestedSessionId(String value) {
        this.requestedSessionId = value;
        return this;
    }

    public MockServletRequest requestURI(String value) {
        this.requestURI = value;
        return this;
    }

    public MockServletRequest servletPath(String value) {
        this.servletPath = value;
        return this;
    }

    public MockServletRequest httpSession(HttpSession value) {
        this.httpSession = value;
        return this;
    }

    public Object getAttribute(String name) {
        return this.attributeMap.get(name);
    }

    public Enumeration<String> getAttributeNames() {
        return Collections.enumeration(this.attributeMap.keySet());
    }

    public String getCharacterEncoding() {
        return this.characterEncoding;
    }

    public void setCharacterEncoding(String characterEncoding) throws UnsupportedEncodingException {
        this.characterEncoding = characterEncoding;
    }

    public int getContentLength() {
        return this.body == null ? 0 : this.body.length;
    }

    public long getContentLengthLong() {
        return this.body == null ? 0L : (long)this.body.length;
    }

    public String getContentType() {
        return this.getHeader("Content-Type");
    }

    public ServletInputStream getInputStream() throws IOException {
        if (this.formDataMap != null) {
            this.body = UrlEncodingSerializer.DEFAULT.toString(this.formDataMap).getBytes();
        }
        return new BoundedServletInputStream(new ByteArrayInputStream(this.body), Integer.MAX_VALUE);
    }

    public String getParameter(String name) {
        String[] s = this.getParameterMap().get(name);
        return s == null || s.length == 0 ? null : s[0];
    }

    public Enumeration<String> getParameterNames() {
        return Collections.enumeration(new ArrayList<String>(this.getParameterMap().keySet()));
    }

    public String[] getParameterValues(String name) {
        return this.getParameterMap().get(name);
    }

    public Map<String, String[]> getParameterMap() {
        if (this.queryData == null) {
            try {
                this.queryData = "POST".equalsIgnoreCase(this.method) ? (this.formDataMap != null ? this.formDataMap : RestUtils.parseQuery(IOUtils.read(this.body))) : RestUtils.parseQuery(this.getQueryString());
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return this.queryData;
    }

    public String getProtocol() {
        return this.protocol;
    }

    public String getScheme() {
        return this.scheme;
    }

    public String getServerName() {
        return this.serverName;
    }

    public int getServerPort() {
        return this.serverPort;
    }

    public BufferedReader getReader() throws IOException {
        return new BufferedReader(new InputStreamReader((InputStream)this.getInputStream(), this.characterEncoding));
    }

    public String getRemoteAddr() {
        return this.remoteAddr;
    }

    public String getRemoteHost() {
        return this.remoteHost;
    }

    public void setAttribute(String name, Object o) {
        this.attributeMap.put(name, o);
    }

    public void removeAttribute(String name) {
        this.attributeMap.remove(name);
    }

    public Locale getLocale() {
        return this.locale;
    }

    public Enumeration<Locale> getLocales() {
        return Collections.enumeration(Arrays.asList(this.locale));
    }

    public boolean isSecure() {
        return false;
    }

    public RequestDispatcher getRequestDispatcher(String path) {
        return this.requestDispatcher;
    }

    public String getRealPath(String path) {
        return this.realPath;
    }

    public int getRemotePort() {
        return this.remotePort;
    }

    public String getLocalName() {
        return this.localName;
    }

    public String getLocalAddr() {
        return this.localAddr;
    }

    public int getLocalPort() {
        return this.localPort;
    }

    public ServletContext getServletContext() {
        return this.servletContext;
    }

    public AsyncContext startAsync() throws IllegalStateException {
        return null;
    }

    public AsyncContext startAsync(ServletRequest servletRequest, ServletResponse servletResponse) throws IllegalStateException {
        return null;
    }

    public boolean isAsyncStarted() {
        return false;
    }

    public boolean isAsyncSupported() {
        return false;
    }

    public AsyncContext getAsyncContext() {
        return null;
    }

    public DispatcherType getDispatcherType() {
        return this.dispatcherType;
    }

    public String getAuthType() {
        return this.authType;
    }

    public Cookie[] getCookies() {
        return this.cookies;
    }

    public long getDateHeader(String name) {
        String s = this.getHeader(name);
        return s == null ? 0L : Date.of(s).asZonedDateTime().toInstant().toEpochMilli();
    }

    public String getHeader(String name) {
        String[] s = this.headerMap.get(name);
        return s == null || s.length == 0 ? null : s[0];
    }

    public Enumeration<String> getHeaders(String name) {
        String[] s = this.headerMap.get(name);
        return Collections.enumeration(Arrays.asList(s == null ? new String[]{} : s));
    }

    public Enumeration<String> getHeaderNames() {
        return Collections.enumeration(this.headerMap.keySet());
    }

    public int getIntHeader(String name) {
        String s = this.getHeader(name);
        return s == null || s.isEmpty() ? 0 : Integer.parseInt(s);
    }

    public String getMethod() {
        return this.method;
    }

    public String getPathInfo() {
        if (this.pathInfo == null) {
            this.pathInfo = this.getRequestURI();
            if (StringUtils.isNotEmpty(this.contextPath)) {
                this.pathInfo = this.pathInfo.substring(this.contextPath.length());
            }
            if (StringUtils.isNotEmpty(this.servletPath)) {
                this.pathInfo = this.pathInfo.substring(this.servletPath.length());
            }
        }
        return StringUtils.nullIfEmpty(StringUtils.urlDecode(this.pathInfo));
    }

    public String getPathTranslated() {
        if (this.pathTranslated == null) {
            this.pathTranslated = "/mock-path" + this.getPathInfo();
        }
        return this.pathTranslated;
    }

    public String getContextPath() {
        return this.contextPath;
    }

    public String getQueryString() {
        if (this.queryString == null) {
            this.queryString = "";
            if (this.uri.indexOf(63) != -1) {
                this.queryString = this.uri.substring(this.uri.indexOf(63) + 1);
                if (this.queryString.indexOf(35) != -1) {
                    this.queryString = this.queryString.substring(0, this.queryString.indexOf(35));
                }
            }
        }
        return StringUtils.isEmpty(this.queryString) ? null : this.queryString;
    }

    public String getRemoteUser() {
        return this.remoteUser;
    }

    public boolean isUserInRole(String role) {
        return false;
    }

    public Principal getUserPrincipal() {
        return this.userPrincipal;
    }

    public String getRequestedSessionId() {
        return this.requestedSessionId;
    }

    public String getRequestURI() {
        if (this.requestURI == null) {
            this.requestURI = this.uri;
            this.requestURI = this.requestURI.replaceAll("^\\w+\\:\\/\\/[^\\/]+", "").replaceAll("\\?.*$", "");
        }
        return this.requestURI;
    }

    public StringBuffer getRequestURL() {
        return new StringBuffer(this.uri.replaceAll("\\?.*$", ""));
    }

    public String getServletPath() {
        return this.servletPath;
    }

    public HttpSession getSession(boolean create) {
        return this.httpSession;
    }

    public HttpSession getSession() {
        return this.httpSession;
    }

    public String changeSessionId() {
        return null;
    }

    public boolean isRequestedSessionIdValid() {
        return false;
    }

    public boolean isRequestedSessionIdFromCookie() {
        return false;
    }

    public boolean isRequestedSessionIdFromURL() {
        return false;
    }

    public boolean isRequestedSessionIdFromUrl() {
        return false;
    }

    public boolean authenticate(HttpServletResponse response) throws IOException, ServletException {
        return false;
    }

    public void login(String username, String password) throws ServletException {
    }

    public void logout() throws ServletException {
    }

    public Collection<Part> getParts() throws IOException, ServletException {
        return null;
    }

    public Part getPart(String name) throws IOException, ServletException {
        return null;
    }

    public <T extends HttpUpgradeHandler> T upgrade(Class<T> handlerClass) throws IOException, ServletException {
        return null;
    }

    @Override
    public MockServletRequest header(String name, Object value) {
        this.headerMap.put(name, new String[]{StringUtils.stringify(value)});
        return this;
    }

    public MockServletRequest attribute(String name, Object value) {
        this.attributeMap.put(name, value);
        return this;
    }

    @Override
    public MockServletRequest body(Object value) {
        try {
            if (value instanceof byte[]) {
                this.body = (byte[])value;
            }
            if (value instanceof Reader) {
                this.body = IOUtils.read((Reader)value).getBytes();
            }
            if (value instanceof InputStream) {
                this.body = IOUtils.readBytes((InputStream)value, 1024);
            }
            if (value instanceof CharSequence) {
                this.body = ((CharSequence)value).toString().getBytes();
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return this;
    }

    public MockServletRequest formData(String key, Object value) {
        if (this.formDataMap == null) {
            this.formDataMap = new LinkedHashMap<String, String[]>();
        }
        String s = StringUtils.stringify(value);
        String[] existing = this.formDataMap.get(key);
        existing = existing == null ? new String[]{s} : AList.of(existing).a(s).asArrayOf(String.class);
        this.formDataMap.put(key, existing);
        return this;
    }

    public MockServletRequest query(String key, Object value) {
        if (this.queryData == null) {
            this.queryData = new LinkedHashMap<String, String[]>();
        }
        String s = StringUtils.stringify(value);
        String[] existing = this.queryData.get(key);
        existing = existing == null ? new String[]{s} : AList.of(existing).a(s).asArrayOf(String.class);
        this.queryData.put(key, existing);
        return this;
    }

    public MockServletRequest accept(Object value) {
        return this.header("Accept", value);
    }

    public MockServletRequest acceptCharset(Object value) {
        return this.header("Accept-Charset", value);
    }

    public MockServletRequest acceptEncoding(Object value) {
        return this.header("Accept-Encoding", value);
    }

    public MockServletRequest acceptLanguage(Object value) {
        return this.header("Accept-Language", value);
    }

    public MockServletRequest authorization(Object value) {
        return this.header("Authorization", value);
    }

    public MockServletRequest cacheControl(Object value) {
        return this.header("Cache-Control", value);
    }

    public MockServletRequest clientVersion(Object value) {
        return this.header("X-Client-Version", value);
    }

    public MockServletRequest connection(Object value) {
        return this.header("Connection", value);
    }

    public MockServletRequest contentEncoding(Object value) {
        return this.header("Content-Encoding", value);
    }

    public MockServletRequest contentLength(Object value) {
        return this.header("Content-Length", value);
    }

    public MockServletRequest contentType(Object value) {
        return this.header("Content-Type", value);
    }

    public MockServletRequest date(Object value) {
        return this.header("Date", value);
    }

    public MockServletRequest expect(Object value) {
        return this.header("Expect", value);
    }

    public MockServletRequest from(Object value) {
        return this.header("From", value);
    }

    public MockServletRequest host(Object value) {
        return this.header("Host", value);
    }

    public MockServletRequest ifMatch(Object value) {
        return this.header("If-Match", value);
    }

    public MockServletRequest ifModifiedSince(Object value) {
        return this.header("If-Modified-Since", value);
    }

    public MockServletRequest ifNoneMatch(Object value) {
        return this.header("If-None-Match", value);
    }

    public MockServletRequest ifRange(Object value) {
        return this.header("If-Range", value);
    }

    public MockServletRequest ifUnmodifiedSince(Object value) {
        return this.header("If-Unmodified-Since", value);
    }

    public MockServletRequest maxForwards(Object value) {
        return this.header("Max-Forwards", value);
    }

    public MockServletRequest pragma(Object value) {
        return this.header("Pragma", value);
    }

    public MockServletRequest proxyAuthorization(Object value) {
        return this.header("Proxy-Authorization", value);
    }

    public MockServletRequest range(Object value) {
        return this.header("Range", value);
    }

    public MockServletRequest referer(Object value) {
        return this.header("Referer", value);
    }

    public MockServletRequest te(Object value) {
        return this.header("TE", value);
    }

    public MockServletRequest upgrade(Object value) {
        return this.header("Upgrade", value);
    }

    public MockServletRequest userAgent(Object value) {
        return this.header("User-Agent", value);
    }

    public MockServletRequest warning(Object value) {
        return this.header("Warning", value);
    }

    public MockServletRequest debug() {
        this.debug = true;
        return this;
    }
}

