/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.pojotools;

import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.juneau.internal.StringUtils;
import org.apache.juneau.pojotools.PatternException;

public class SearchArgs {
    private final Map<String, String> search = new LinkedHashMap<String, String>();

    public SearchArgs(String searchArgs) {
        this(Arrays.asList(StringUtils.split(searchArgs, ',')));
    }

    public SearchArgs(List<String> searchArgs) {
        for (String s : searchArgs) {
            int i = StringUtils.indexOf(s, '=', '>', '<');
            if (i == -1) {
                throw new PatternException("Invalid search terms: ''{0}''", searchArgs);
            }
            char c = s.charAt(i);
            this.append(s.substring(0, i).trim(), s.substring(c == '=' ? i + 1 : i).trim());
        }
    }

    public SearchArgs append(String column, String searchTerm) {
        this.search.put(column, searchTerm);
        return this;
    }

    public Map<String, String> getSearch() {
        return this.search;
    }
}

