/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.serializer;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import org.apache.juneau.BeanTraverseBuilder;
import org.apache.juneau.BinaryFormat;
import org.apache.juneau.ContextCache;
import org.apache.juneau.PropertyNamer;
import org.apache.juneau.PropertyStore;
import org.apache.juneau.UriContext;
import org.apache.juneau.UriRelativity;
import org.apache.juneau.UriResolution;
import org.apache.juneau.Visibility;
import org.apache.juneau.collections.AList;
import org.apache.juneau.http.MediaType;
import org.apache.juneau.internal.ArrayUtils;
import org.apache.juneau.internal.FluentSetter;
import org.apache.juneau.reflect.AnnotationList;
import org.apache.juneau.serializer.Serializer;
import org.apache.juneau.serializer.SerializerGroup;
import org.apache.juneau.serializer.SerializerListener;
import org.apache.juneau.svl.VarResolverSession;
import org.apache.juneau.transform.BeanInterceptor;

public class SerializerGroupBuilder
extends BeanTraverseBuilder {
    private final AList<Object> serializers;

    public SerializerGroupBuilder() {
        this.serializers = AList.of();
    }

    public SerializerGroupBuilder(SerializerGroup copyFrom) {
        super(copyFrom.getPropertyStore());
        this.serializers = AList.of().arev(copyFrom.getSerializers());
    }

    public SerializerGroupBuilder append(Class<?> ... s) {
        this.serializers.arev(s);
        return this;
    }

    public SerializerGroupBuilder append(Serializer ... s) {
        this.serializers.arev((Object[])s);
        return this;
    }

    public SerializerGroupBuilder append(List<Object> s) {
        this.serializers.arev(s);
        return this;
    }

    public SerializerGroupBuilder append(Object ... s) {
        this.serializers.arev((Object[])s);
        return this;
    }

    @Override
    public SerializerGroup build() {
        ArrayList<Object> l = new ArrayList<Object>();
        for (Object e : this.serializers) {
            Class c = null;
            PropertyStore ps = this.getPropertyStore();
            if (e instanceof Class) {
                c = (Class)e;
                l.add(ContextCache.INSTANCE.create(c, ps));
                continue;
            }
            l.add((Serializer)e);
        }
        return new SerializerGroup(this.getPropertyStore(), ArrayUtils.toReverseArray(Serializer.class, l));
    }

    @FluentSetter
    @Deprecated
    public SerializerGroupBuilder addBeanTypes(boolean value) {
        return this.set("Serializer.addBeanTypes.b", value);
    }

    @FluentSetter
    public SerializerGroupBuilder addBeanTypes() {
        return this.set("Serializer.addBeanTypes.b", true);
    }

    @FluentSetter
    @Deprecated
    public SerializerGroupBuilder addRootType(boolean value) {
        return this.set("Serializer.addRootType.b", value);
    }

    @FluentSetter
    public SerializerGroupBuilder addRootType() {
        return this.set("Serializer.addRootType.b", true);
    }

    @FluentSetter
    @Deprecated
    public SerializerGroupBuilder keepNullProperties(boolean value) {
        return this.set("Serializer.keepNullProperties.b", value);
    }

    @FluentSetter
    public SerializerGroupBuilder keepNullProperties() {
        return this.set("Serializer.keepNullProperties.b", true);
    }

    @FluentSetter
    public SerializerGroupBuilder listener(Class<? extends SerializerListener> value) {
        return this.set("Serializer.listener.c", value);
    }

    @FluentSetter
    @Deprecated
    public SerializerGroupBuilder sortCollections(boolean value) {
        return this.set("Serializer.sortCollections.b", value);
    }

    @FluentSetter
    public SerializerGroupBuilder sortCollections() {
        return this.set("Serializer.sortCollections.b", true);
    }

    @FluentSetter
    @Deprecated
    public SerializerGroupBuilder sortMaps(boolean value) {
        return this.set("Serializer.sortMaps.b", value);
    }

    @FluentSetter
    public SerializerGroupBuilder sortMaps() {
        return this.set("Serializer.sortMaps.b", true);
    }

    @FluentSetter
    @Deprecated
    public SerializerGroupBuilder trimEmptyCollections(boolean value) {
        return this.set("Serializer.trimEmptyCollections.b", value);
    }

    @FluentSetter
    public SerializerGroupBuilder trimEmptyCollections() {
        return this.set("Serializer.trimEmptyCollections.b", true);
    }

    @FluentSetter
    @Deprecated
    public SerializerGroupBuilder trimEmptyMaps(boolean value) {
        return this.set("Serializer.trimEmptyMaps.b", value);
    }

    @FluentSetter
    public SerializerGroupBuilder trimEmptyMaps() {
        return this.set("Serializer.trimEmptyMaps.b", true);
    }

    @FluentSetter
    @Deprecated
    public SerializerGroupBuilder trimNullProperties(boolean value) {
        return this.set("Serializer.trimNullProperties.b", value);
    }

    @FluentSetter
    @Deprecated
    public SerializerGroupBuilder trimStrings(boolean value) {
        return this.set("Serializer.trimStrings.b", value);
    }

    @FluentSetter
    public SerializerGroupBuilder trimStrings() {
        return this.set("Serializer.trimStrings.b", true);
    }

    @FluentSetter
    public SerializerGroupBuilder uriContext(UriContext value) {
        return this.set("Serializer.uriContext.s", value);
    }

    @FluentSetter
    public SerializerGroupBuilder uriRelativity(UriRelativity value) {
        return this.set("Serializer.uriRelativity.s", (Object)value);
    }

    @FluentSetter
    public SerializerGroupBuilder uriResolution(UriResolution value) {
        return this.set("Serializer.uriResolution.s", (Object)value);
    }

    @FluentSetter
    public SerializerGroupBuilder binaryOutputFormat(BinaryFormat value) {
        return this.set("OutputStreamSerializer.binaryFormat.s", (Object)value);
    }

    @FluentSetter
    public SerializerGroupBuilder fileCharset(Charset value) {
        return this.set("WriterSerializer.fileCharset.s", value);
    }

    @FluentSetter
    public SerializerGroupBuilder maxIndent(int value) {
        return this.set("WriterSerializer.maxIndent.i", value);
    }

    @FluentSetter
    public SerializerGroupBuilder quoteChar(char value) {
        return this.set("WriterSerializer.quoteChar.s", Character.valueOf(value));
    }

    @FluentSetter
    public SerializerGroupBuilder sq() {
        return this.quoteChar('\'');
    }

    @FluentSetter
    public SerializerGroupBuilder streamCharset(Charset value) {
        return this.set("WriterSerializer.streamCharset.s", value);
    }

    @FluentSetter
    @Deprecated
    public SerializerGroupBuilder useWhitespace(boolean value) {
        return this.set("WriterSerializer.useWhitespace.b", value);
    }

    @FluentSetter
    public SerializerGroupBuilder useWhitespace() {
        return this.set("WriterSerializer.useWhitespace.b", true);
    }

    @FluentSetter
    public SerializerGroupBuilder ws() {
        return this.useWhitespace();
    }

    @Override
    public SerializerGroupBuilder add(Map<String, Object> properties) {
        super.add((Map)properties);
        return this;
    }

    @Override
    public SerializerGroupBuilder addTo(String name, Object value) {
        super.addTo(name, value);
        return this;
    }

    @Override
    public SerializerGroupBuilder appendTo(String name, Object value) {
        super.appendTo(name, value);
        return this;
    }

    @Override
    public SerializerGroupBuilder apply(PropertyStore copyFrom) {
        super.apply(copyFrom);
        return this;
    }

    @Override
    public SerializerGroupBuilder applyAnnotations(Class<?> ... fromClasses) {
        super.applyAnnotations((Class[])fromClasses);
        return this;
    }

    @Override
    public SerializerGroupBuilder applyAnnotations(Method ... fromMethods) {
        super.applyAnnotations(fromMethods);
        return this;
    }

    @Override
    public SerializerGroupBuilder applyAnnotations(AnnotationList al, VarResolverSession r) {
        super.applyAnnotations(al, r);
        return this;
    }

    @Override
    public SerializerGroupBuilder debug() {
        super.debug();
        return this;
    }

    @Override
    public SerializerGroupBuilder locale(Locale value) {
        super.locale(value);
        return this;
    }

    @Override
    public SerializerGroupBuilder mediaType(MediaType value) {
        super.mediaType(value);
        return this;
    }

    @Override
    public SerializerGroupBuilder prependTo(String name, Object value) {
        super.prependTo(name, value);
        return this;
    }

    @Override
    public SerializerGroupBuilder putAllTo(String name, Object value) {
        super.putAllTo(name, value);
        return this;
    }

    @Override
    public SerializerGroupBuilder putTo(String name, String key, Object value) {
        super.putTo(name, key, value);
        return this;
    }

    @Override
    public SerializerGroupBuilder removeFrom(String name, Object value) {
        super.removeFrom(name, value);
        return this;
    }

    @Override
    public SerializerGroupBuilder set(Map<String, Object> properties) {
        super.set((Map)properties);
        return this;
    }

    @Override
    public SerializerGroupBuilder set(String name, Object value) {
        super.set(name, value);
        return this;
    }

    @Override
    public SerializerGroupBuilder timeZone(TimeZone value) {
        super.timeZone(value);
        return this;
    }

    @Override
    public SerializerGroupBuilder annotations(Annotation ... values) {
        super.annotations(values);
        return this;
    }

    @Override
    public SerializerGroupBuilder beanClassVisibility(Visibility value) {
        super.beanClassVisibility(value);
        return this;
    }

    @Override
    public SerializerGroupBuilder beanConstructorVisibility(Visibility value) {
        super.beanConstructorVisibility(value);
        return this;
    }

    @Override
    public SerializerGroupBuilder beanFieldVisibility(Visibility value) {
        super.beanFieldVisibility(value);
        return this;
    }

    @Override
    public SerializerGroupBuilder beanInterceptor(Class<?> on, Class<? extends BeanInterceptor<?>> value) {
        super.beanInterceptor((Class)on, (Class)value);
        return this;
    }

    @Override
    public SerializerGroupBuilder beanMapPutReturnsOldValue() {
        super.beanMapPutReturnsOldValue();
        return this;
    }

    @Override
    public SerializerGroupBuilder beanMethodVisibility(Visibility value) {
        super.beanMethodVisibility(value);
        return this;
    }

    @Override
    public SerializerGroupBuilder beansDontRequireSomeProperties() {
        super.beansDontRequireSomeProperties();
        return this;
    }

    @Override
    public SerializerGroupBuilder beansRequireDefaultConstructor() {
        super.beansRequireDefaultConstructor();
        return this;
    }

    @Override
    public SerializerGroupBuilder beansRequireSerializable() {
        super.beansRequireSerializable();
        return this;
    }

    @Override
    public SerializerGroupBuilder beansRequireSettersForGetters() {
        super.beansRequireSettersForGetters();
        return this;
    }

    @Override
    public SerializerGroupBuilder bpi(Map<String, Object> values) {
        super.bpi((Map)values);
        return this;
    }

    @Override
    public SerializerGroupBuilder bpi(Class<?> beanClass, String properties) {
        super.bpi((Class)beanClass, properties);
        return this;
    }

    @Override
    public SerializerGroupBuilder bpi(String beanClassName, String properties) {
        super.bpi(beanClassName, properties);
        return this;
    }

    @Override
    public SerializerGroupBuilder bpro(Map<String, Object> values) {
        super.bpro((Map)values);
        return this;
    }

    @Override
    public SerializerGroupBuilder bpro(Class<?> beanClass, String properties) {
        super.bpro((Class)beanClass, properties);
        return this;
    }

    @Override
    public SerializerGroupBuilder bpro(String beanClassName, String properties) {
        super.bpro(beanClassName, properties);
        return this;
    }

    @Override
    public SerializerGroupBuilder bpwo(Map<String, Object> values) {
        super.bpwo((Map)values);
        return this;
    }

    @Override
    public SerializerGroupBuilder bpwo(Class<?> beanClass, String properties) {
        super.bpwo((Class)beanClass, properties);
        return this;
    }

    @Override
    public SerializerGroupBuilder bpwo(String beanClassName, String properties) {
        super.bpwo(beanClassName, properties);
        return this;
    }

    @Override
    public SerializerGroupBuilder bpx(Map<String, Object> values) {
        super.bpx((Map)values);
        return this;
    }

    @Override
    public SerializerGroupBuilder bpx(Class<?> beanClass, String properties) {
        super.bpx((Class)beanClass, properties);
        return this;
    }

    @Override
    public SerializerGroupBuilder bpx(String beanClassName, String properties) {
        super.bpx(beanClassName, properties);
        return this;
    }

    @Override
    public SerializerGroupBuilder dictionary(Object ... values) {
        super.dictionary(values);
        return this;
    }

    @Override
    public SerializerGroupBuilder dictionaryOn(Class<?> on, Class<?> ... values) {
        super.dictionaryOn((Class)on, (Class[])values);
        return this;
    }

    @Override
    public SerializerGroupBuilder dontIgnorePropertiesWithoutSetters() {
        super.dontIgnorePropertiesWithoutSetters();
        return this;
    }

    @Override
    public SerializerGroupBuilder dontIgnoreTransientFields() {
        super.dontIgnoreTransientFields();
        return this;
    }

    @Override
    public SerializerGroupBuilder dontIgnoreUnknownNullBeanProperties() {
        super.dontIgnoreUnknownNullBeanProperties();
        return this;
    }

    @Override
    public SerializerGroupBuilder dontUseInterfaceProxies() {
        super.dontUseInterfaceProxies();
        return this;
    }

    @Override
    public <T> SerializerGroupBuilder example(Class<T> pojoClass, T o) {
        super.example((Class)pojoClass, (Object)o);
        return this;
    }

    @Override
    public <T> SerializerGroupBuilder exampleJson(Class<T> pojoClass, String json) {
        super.exampleJson((Class)pojoClass, json);
        return this;
    }

    @Override
    public SerializerGroupBuilder fluentSetters() {
        super.fluentSetters();
        return this;
    }

    @Override
    public SerializerGroupBuilder fluentSetters(Class<?> on) {
        super.fluentSetters((Class)on);
        return this;
    }

    @Override
    public SerializerGroupBuilder ignoreInvocationExceptionsOnGetters() {
        super.ignoreInvocationExceptionsOnGetters();
        return this;
    }

    @Override
    public SerializerGroupBuilder ignoreInvocationExceptionsOnSetters() {
        super.ignoreInvocationExceptionsOnSetters();
        return this;
    }

    @Override
    public SerializerGroupBuilder ignoreUnknownBeanProperties() {
        super.ignoreUnknownBeanProperties();
        return this;
    }

    @Override
    public SerializerGroupBuilder implClass(Class<?> interfaceClass, Class<?> implClass) {
        super.implClass((Class)interfaceClass, (Class)implClass);
        return this;
    }

    @Override
    public SerializerGroupBuilder implClasses(Map<Class<?>, Class<?>> values) {
        super.implClasses((Map)values);
        return this;
    }

    @Override
    public SerializerGroupBuilder interfaceClass(Class<?> on, Class<?> value) {
        super.interfaceClass((Class)on, (Class)value);
        return this;
    }

    @Override
    public SerializerGroupBuilder interfaces(Class<?> ... value) {
        super.interfaces((Class[])value);
        return this;
    }

    @Override
    public SerializerGroupBuilder notBeanClasses(Object ... values) {
        super.notBeanClasses(values);
        return this;
    }

    @Override
    public SerializerGroupBuilder notBeanPackages(Object ... values) {
        super.notBeanPackages(values);
        return this;
    }

    @Override
    public SerializerGroupBuilder propertyNamer(Class<? extends PropertyNamer> value) {
        super.propertyNamer((Class)value);
        return this;
    }

    @Override
    public SerializerGroupBuilder propertyNamer(Class<?> on, Class<? extends PropertyNamer> value) {
        super.propertyNamer((Class)on, (Class)value);
        return this;
    }

    @Override
    public SerializerGroupBuilder sortProperties() {
        super.sortProperties();
        return this;
    }

    @Override
    public SerializerGroupBuilder sortProperties(Class<?> ... on) {
        super.sortProperties((Class[])on);
        return this;
    }

    @Override
    public SerializerGroupBuilder stopClass(Class<?> on, Class<?> value) {
        super.stopClass((Class)on, (Class)value);
        return this;
    }

    @Override
    public SerializerGroupBuilder swaps(Object ... values) {
        super.swaps(values);
        return this;
    }

    @Override
    public SerializerGroupBuilder typeName(Class<?> on, String value) {
        super.typeName((Class)on, value);
        return this;
    }

    @Override
    public SerializerGroupBuilder typePropertyName(String value) {
        super.typePropertyName(value);
        return this;
    }

    @Override
    public SerializerGroupBuilder typePropertyName(Class<?> on, String value) {
        super.typePropertyName((Class)on, value);
        return this;
    }

    @Override
    public SerializerGroupBuilder useEnumNames() {
        super.useEnumNames();
        return this;
    }

    @Override
    public SerializerGroupBuilder useJavaBeanIntrospector() {
        super.useJavaBeanIntrospector();
        return this;
    }

    @Override
    public SerializerGroupBuilder detectRecursions() {
        super.detectRecursions();
        return this;
    }

    @Override
    public SerializerGroupBuilder ignoreRecursions() {
        super.ignoreRecursions();
        return this;
    }

    @Override
    public SerializerGroupBuilder initialDepth(int value) {
        super.initialDepth(value);
        return this;
    }

    @Override
    public SerializerGroupBuilder maxDepth(int value) {
        super.maxDepth(value);
        return this;
    }
}

