/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau;

import java.lang.reflect.Array;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import org.apache.juneau.BeanSession;
import org.apache.juneau.ConfigException;
import org.apache.juneau.PropertyStoreBuilder;
import org.apache.juneau.PropertyType;
import org.apache.juneau.ResourceResolver;
import org.apache.juneau.collections.AList;
import org.apache.juneau.collections.AMap;
import org.apache.juneau.internal.ClassUtils;
import org.apache.juneau.internal.HashCode;
import org.apache.juneau.internal.ObjectUtils;
import org.apache.juneau.json.SimpleJsonSerializer;
import org.apache.juneau.marshall.SimpleJson;
import org.apache.juneau.reflect.ClassInfo;

public final class PropertyStore {
    public static PropertyStore DEFAULT = PropertyStore.create().build();
    final SortedMap<String, PropertyGroup> groups;
    private final int hashCode;

    PropertyStore(Map<String, PropertyStoreBuilder.PropertyGroupBuilder> propertyMaps) {
        TreeMap<String, PropertyGroup> m = new TreeMap<String, PropertyGroup>();
        for (Map.Entry<String, PropertyStoreBuilder.PropertyGroupBuilder> p : propertyMaps.entrySet()) {
            m.put(p.getKey(), p.getValue().build());
        }
        this.groups = Collections.unmodifiableSortedMap(m);
        this.hashCode = this.groups.hashCode();
    }

    public static PropertyStoreBuilder create() {
        return new PropertyStoreBuilder();
    }

    public PropertyStoreBuilder builder() {
        return new PropertyStoreBuilder(this);
    }

    private Property findProperty(String key) {
        Property p;
        String g = PropertyStore.group(key);
        String k = key.substring(g.length() + 1);
        PropertyGroup pm = (PropertyGroup)this.groups.get(g);
        if (pm != null && (p = pm.get(k)) != null) {
            return p;
        }
        String s = null;
        String k1 = key;
        String k2 = key.indexOf(46) == -1 ? key : key.substring(0, key.lastIndexOf(46));
        s = System.getProperty(k1);
        if (s == null) {
            s = System.getProperty(k2);
        }
        try {
            if (s == null) {
                s = System.getenv(k1.replace('.', '_').replace('-', '_').toUpperCase());
            }
            if (s == null) {
                s = System.getenv(k2.replace('.', '_').replace('-', '_').toUpperCase());
            }
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        return s == null ? null : PropertyStoreBuilder.MutableProperty.create(k, s).build();
    }

    public Object getProperty(String key) {
        Property p = this.findProperty(key);
        return p == null ? null : p.value;
    }

    public <T> T getProperty(String key, Class<T> c, T def) {
        Property p = this.findProperty(key);
        return p == null ? def : p.as(c);
    }

    public <T> Class<? extends T> getClassProperty(String key, Class<T> type, Class<? extends T> def) {
        Property p = this.findProperty(key);
        return p == null ? def : p.as(Class.class);
    }

    public <T> T[] getArrayProperty(String key, Class<T> eType) {
        Property p = this.findProperty(key);
        return p == null ? Array.newInstance(eType, 0) : p.asArray(eType);
    }

    public <T> T[] getArrayProperty(String key, Class<T> eType, T[] def) {
        Property p = this.findProperty(key);
        return p == null ? def : p.asArray(eType);
    }

    public Class<?>[] getClassArrayProperty(String key) {
        Property p = this.findProperty(key);
        return p == null ? new Class[]{} : p.as(Class[].class);
    }

    public Class<?>[] getClassArrayProperty(String key, Class<?>[] def) {
        Property p = this.findProperty(key);
        return p == null ? def : p.as(Class[].class);
    }

    public <T> Class<T>[] getClassArrayProperty(String key, Class<T> eType) {
        Property p = this.findProperty(key);
        return p == null ? new Class[]{} : p.as(Class[].class);
    }

    public <T> Set<T> getSetProperty(String key, Class<T> eType) {
        Property p = this.findProperty(key);
        return p == null ? Collections.EMPTY_SET : p.asSet(eType);
    }

    public <T> Set<T> getSetProperty(String key, Class<T> eType, Set<T> def) {
        Set<T> l = this.getSetProperty(key, eType);
        return l.isEmpty() ? def : l;
    }

    public Set<Class<?>> getClassSetProperty(String key) {
        Property p = this.findProperty(key);
        return p == null ? Collections.EMPTY_SET : p.asSet(Class.class);
    }

    public <T> Set<Class<T>> getClassSetProperty(String key, Class<T> eType) {
        Property p = this.findProperty(key);
        return p == null ? Collections.EMPTY_SET : p.asSet(Class.class);
    }

    public <T> List<T> getListProperty(String key, Class<T> eType) {
        Property p = this.findProperty(key);
        return p == null ? Collections.EMPTY_LIST : p.asList(eType);
    }

    public <T> List<T> getListProperty(String key, Class<T> eType, List<T> def) {
        List<T> l = this.getListProperty(key, eType);
        return l.isEmpty() ? def : l;
    }

    public List<Class<?>> getClassListProperty(String key) {
        Property p = this.findProperty(key);
        return p == null ? Collections.EMPTY_LIST : p.asList(Class.class);
    }

    public <T> List<Class<T>> getClassListProperty(String key, Class<T> eType) {
        Property p = this.findProperty(key);
        return p == null ? Collections.EMPTY_LIST : p.asList(Class.class);
    }

    public <T> Map<String, T> getMapProperty(String key, Class<T> eType) {
        Property p = this.findProperty(key);
        return p == null ? Collections.EMPTY_MAP : p.asMap(eType);
    }

    public Map<String, Class<?>> getClassMapProperty(String key) {
        Property p = this.findProperty(key);
        return p == null ? Collections.EMPTY_MAP : p.asMap(Class.class);
    }

    public <T> Map<String, Class<T>> getClassMapProperty(String key, Class<T> eType) {
        Property p = this.findProperty(key);
        return p == null ? Collections.EMPTY_MAP : p.asMap(Class.class);
    }

    public <T> T getInstanceProperty(String key, Class<T> type, Object def) {
        return this.getInstanceProperty(key, type, def, ResourceResolver.BASIC, new Object[0]);
    }

    public <T> T getInstanceProperty(String key, Class<T> type, Object def, ResourceResolver resolver, Object ... args) {
        return this.getInstanceProperty(key, null, type, def, resolver, args);
    }

    public <T> T getInstanceProperty(String key, Object outer, Class<T> type, Object def, ResourceResolver resolver, Object ... args) {
        Property p = this.findProperty(key);
        if (p != null) {
            return p.asInstance(outer, type, resolver, args);
        }
        if (def == null) {
            return null;
        }
        if (def instanceof Class) {
            return resolver.resolve(outer, (Class)def, args);
        }
        if (type.isInstance(def)) {
            return (T)def;
        }
        throw new ConfigException("Could not instantiate property ''{0}'' as type ''{1}'' with default value ''{2}''", key, type, def);
    }

    public <T> T[] getInstanceArrayProperty(String key, Class<T> type, T[] def) {
        return this.getInstanceArrayProperty(key, type, def, ResourceResolver.BASIC, new Object[0]);
    }

    public <T> T[] getInstanceArrayProperty(String key, Class<T> type, T[] def, ResourceResolver resolver, Object ... args) {
        return this.getInstanceArrayProperty(key, null, type, def, resolver, args);
    }

    public <T> T[] getInstanceArrayProperty(String key, Object outer, Class<T> type, T[] def, ResourceResolver resolver, Object ... args) {
        Property p = this.findProperty(key);
        return p == null ? def : p.asInstanceArray(outer, type, resolver, args);
    }

    public Set<String> getPropertyKeys(String group) {
        if (group == null) {
            return Collections.EMPTY_SET;
        }
        PropertyGroup g = (PropertyGroup)this.groups.get(group);
        return g == null ? Collections.EMPTY_SET : g.keySet();
    }

    public int hashCode() {
        return this.hashCode;
    }

    public Integer hashCode(String ... groups) {
        HashCode c = new HashCode();
        for (String p : groups) {
            if (p == null) continue;
            c.add(p).add(this.groups.get(p));
        }
        return c.get();
    }

    public boolean equals(Object o) {
        return o instanceof PropertyStore && ObjectUtils.eq(this, (PropertyStore)o, (x, y) -> ObjectUtils.eq(x.groups, y.groups));
    }

    public boolean equals(PropertyStore ps, String ... groups) {
        if (this == ps) {
            return true;
        }
        for (String p : groups) {
            if (p == null) continue;
            PropertyGroup pg1 = (PropertyGroup)this.groups.get(p);
            PropertyGroup pg2 = (PropertyGroup)ps.groups.get(p);
            if (pg1 == null && pg2 == null) continue;
            if (pg1 == null || pg2 == null) {
                return false;
            }
            if (pg1.equals(pg2)) continue;
            return false;
        }
        return true;
    }

    public Map<String, PropertyGroup> swap(BeanSession beanSession) {
        return this.groups;
    }

    static <T> T instantiate(ResourceResolver resolver, Object outer, Class<T> c, Object value, Object ... args) {
        if (ClassInfo.of(c).isParentOf(value.getClass())) {
            return (T)value;
        }
        if (ClassInfo.of(value.getClass()).isChildOf(Class.class)) {
            return resolver.resolve(outer, (Class)value, args);
        }
        return null;
    }

    private static String group(String key) {
        if (key == null || key.indexOf(46) == -1 || key.charAt(key.length() - 1) == '.') {
            throw new ConfigException("Invalid property name specified: ''{0}''", key);
        }
        String g = key.substring(0, key.indexOf(46));
        if (g.isEmpty()) {
            throw new ConfigException("Invalid property name specified: ''{0}''", key);
        }
        return g;
    }

    public String toString() {
        return SimpleJsonSerializer.DEFAULT.toString(this);
    }

    String hashCodes() {
        StringBuilder sb = new StringBuilder();
        sb.append("\n[" + Integer.toHexString(this.hashCode) + "]");
        for (Map.Entry<String, PropertyGroup> e : this.groups.entrySet()) {
            sb.append("\n\t[" + Integer.toHexString(e.hashCode()) + "] - " + e.getKey());
            e.getValue().hashCodes(sb);
        }
        return sb.toString();
    }

    public static class Property {
        private final String name;
        final Object value;
        private final int hashCode;
        private final PropertyType type;

        Property(String name, Object value, PropertyType type) {
            this.name = name;
            this.value = value;
            this.type = type;
            this.hashCode = value.hashCode();
        }

        PropertyStoreBuilder.MutableProperty mutable() {
            switch (this.type) {
                case STRING: 
                case BOOLEAN: 
                case INTEGER: 
                case CLASS: 
                case OBJECT: {
                    return new PropertyStoreBuilder.MutableSimpleProperty(this.name, this.type, this.value);
                }
                case SET_STRING: 
                case SET_INTEGER: 
                case SET_CLASS: {
                    return new PropertyStoreBuilder.MutableSetProperty(this.name, this.type, this.value);
                }
                case LIST_STRING: 
                case LIST_INTEGER: 
                case LIST_CLASS: 
                case LIST_OBJECT: {
                    return new PropertyStoreBuilder.MutableListProperty(this.name, this.type, this.value);
                }
                case SORTED_MAP_STRING: 
                case SORTED_MAP_INTEGER: 
                case SORTED_MAP_CLASS: 
                case SORTED_MAP_OBJECT: {
                    return new PropertyStoreBuilder.MutableMapProperty(this.name, this.type, this.value);
                }
                case ORDERED_MAP_STRING: 
                case ORDERED_MAP_INTEGER: 
                case ORDERED_MAP_CLASS: 
                case ORDERED_MAP_OBJECT: {
                    return new PropertyStoreBuilder.MutableLinkedMapProperty(this.name, this.type, this.value);
                }
            }
            throw new ConfigException("Invalid type specified: ''{0}''", new Object[]{this.type});
        }

        public <T> T as(Class<T> c) {
            Object t;
            Class<?> c2 = ClassInfo.of(c).getPrimitiveWrapper();
            if (c2 != null) {
                c = c2;
            }
            if (c.isInstance(this.value)) {
                return (T)this.value;
            }
            if (c.isArray() && this.value instanceof Collection) {
                return (T)this.asArray(c.getComponentType());
            }
            if (this.type == PropertyType.STRING && (t = ClassUtils.fromString(c, this.value.toString())) != null) {
                return (T)t;
            }
            throw new ConfigException("Invalid property conversion ''{0}'' to ''{1}'' on property ''{2}''", new Object[]{this.type, c, this.name});
        }

        public <T> T[] asArray(Class<T> eType) {
            if (this.value instanceof Collection) {
                Collection l = (Collection)this.value;
                Object t = Array.newInstance(eType, l.size());
                int i = 0;
                for (Object o : l) {
                    Object o2 = null;
                    if (eType.isInstance(o)) {
                        o2 = o;
                    } else if (this.type == PropertyType.SET_STRING || this.type == PropertyType.LIST_STRING) {
                        o2 = ClassUtils.fromString(eType, o.toString());
                        if (o2 == null) {
                            throw new ConfigException("Invalid property conversion ''{0}'' to ''{1}[]'' on property ''{2}''", new Object[]{this.type, eType, this.name});
                        }
                    } else {
                        throw new ConfigException("Invalid property conversion ''{0}'' to ''{1}[]'' on property ''{2}''", new Object[]{this.type, eType, this.name});
                    }
                    Array.set(t, i++, o2);
                }
                return (Object[])t;
            }
            throw new ConfigException("Invalid property conversion ''{0}'' to ''{1}[]'' on property ''{2}''", new Object[]{this.type, eType, this.name});
        }

        public <T> Set<T> asSet(Class<T> eType) {
            if (this.type == PropertyType.SET_STRING && eType == String.class || this.type == PropertyType.SET_INTEGER && eType == Integer.class || this.type == PropertyType.SET_CLASS && eType == Class.class) {
                return (Set)this.value;
            }
            if (this.type == PropertyType.SET_STRING) {
                LinkedHashSet<T> s = new LinkedHashSet<T>();
                for (Object o : (Set)this.value) {
                    T t = ClassUtils.fromString(eType, o.toString());
                    if (t == null) {
                        throw new ConfigException("Invalid property conversion ''{0}'' to ''Set<{1}>'' on property ''{2}''", new Object[]{this.type, eType, this.name});
                    }
                    s.add(t);
                }
                return Collections.unmodifiableSet(s);
            }
            throw new ConfigException("Invalid property conversion ''{0}'' to ''Set<{1}>'' on property ''{2}''", new Object[]{this.type, eType, this.name});
        }

        public <T> List<T> asList(Class<T> eType) {
            if (this.type == PropertyType.LIST_STRING && eType == String.class || this.type == PropertyType.LIST_INTEGER && eType == Integer.class || this.type == PropertyType.LIST_CLASS && eType == Class.class || this.type == PropertyType.LIST_OBJECT) {
                return (List)this.value;
            }
            if (this.type == PropertyType.LIST_STRING) {
                AList l = AList.of();
                for (Object o : (List)this.value) {
                    T t = ClassUtils.fromString(eType, o.toString());
                    if (t == null) {
                        throw new ConfigException("Invalid property conversion ''{0}'' to ''List<{1}>'' on property ''{2}''", new Object[]{this.type, eType, this.name});
                    }
                    l.add(t);
                }
                return l.unmodifiable();
            }
            throw new ConfigException("Invalid property conversion ''{0}'' to ''List<{1}>'' on property ''{2}''", new Object[]{this.type, eType, this.name});
        }

        public <T> Map<String, T> asMap(Class<T> eType) {
            if (eType == String.class && (this.type == PropertyType.SORTED_MAP_STRING || this.type == PropertyType.ORDERED_MAP_STRING) || eType == Integer.class && (this.type == PropertyType.SORTED_MAP_INTEGER || this.type == PropertyType.ORDERED_MAP_INTEGER) || eType == Class.class && (this.type == PropertyType.SORTED_MAP_CLASS || this.type == PropertyType.ORDERED_MAP_CLASS) || this.type == PropertyType.SORTED_MAP_OBJECT || this.type == PropertyType.ORDERED_MAP_OBJECT) {
                return (Map)this.value;
            }
            if (this.type == PropertyType.SORTED_MAP_STRING || this.type == PropertyType.ORDERED_MAP_STRING) {
                AMap m = AMap.of();
                for (Map.Entry e : ((Map)this.value).entrySet()) {
                    T t = ClassUtils.fromString(eType, (String)e.getValue());
                    if (t == null) {
                        throw new ConfigException("Invalid property conversion ''{0}'' to ''Map<String,{1}>'' on property ''{2}''", new Object[]{this.type, eType, this.name});
                    }
                    m.put(e.getKey(), t);
                }
                return m.unmodifiable();
            }
            throw new ConfigException("Invalid property conversion ''{0}'' to ''Map<String,{1}>'' on property ''{2}''", new Object[]{this.type, eType, this.name});
        }

        public <T> T asInstance(Object outer, Class<T> iType, ResourceResolver resolver, Object ... args) {
            T t;
            if (this.value == null) {
                return null;
            }
            if (this.type == PropertyType.STRING) {
                return ClassUtils.fromString(iType, this.value.toString());
            }
            if ((this.type == PropertyType.OBJECT || this.type == PropertyType.CLASS) && (t = PropertyStore.instantiate(resolver, outer, iType, this.value, args)) != null) {
                return t;
            }
            throw new ConfigException("Invalid property instantiation ''{0}'' to ''{1}'' on property ''{2}''", new Object[]{this.type, iType, this.name});
        }

        public <T> T[] asInstanceArray(Object outer, Class<T> eType, ResourceResolver resolver, Object ... args) {
            if (this.value instanceof Collection) {
                Collection l = (Collection)this.value;
                Object t = Array.newInstance(eType, l.size());
                int i = 0;
                for (Object o : l) {
                    Object o2 = null;
                    if (eType.isInstance(o)) {
                        o2 = o;
                    } else if (this.type == PropertyType.SET_STRING || this.type == PropertyType.LIST_STRING) {
                        o2 = ClassUtils.fromString(eType, o.toString());
                    } else if (this.type == PropertyType.SET_CLASS || this.type == PropertyType.LIST_CLASS || this.type == PropertyType.LIST_OBJECT) {
                        o2 = PropertyStore.instantiate(resolver, outer, eType, o, args);
                    }
                    if (o2 == null) {
                        throw new ConfigException("Invalid property conversion ''{0}'' to ''{1}[]'' on property ''{2}''", new Object[]{this.type, eType, this.name});
                    }
                    Array.set(t, i++, o2);
                }
                return (Object[])t;
            }
            throw new ConfigException("Invalid property conversion ''{0}'' to ''{1}[]'' on property ''{2}''", new Object[]{this.type, eType, this.name});
        }

        public int hashCode() {
            return this.hashCode;
        }

        public boolean equals(Object o) {
            return o instanceof Property && ObjectUtils.eq(this, (Property)o, (x, y) -> ObjectUtils.eq(x.value, y.value));
        }

        public Object swap() {
            return this.value;
        }
    }

    public static class PropertyGroup {
        final SortedMap<String, Property> properties;
        private final int hashCode;

        PropertyGroup(Map<String, PropertyStoreBuilder.MutableProperty> properties) {
            TreeMap<String, Property> m = new TreeMap<String, Property>();
            for (Map.Entry<String, PropertyStoreBuilder.MutableProperty> p : properties.entrySet()) {
                m.put(p.getKey(), p.getValue().build());
            }
            this.properties = Collections.unmodifiableSortedMap(m);
            this.hashCode = this.properties.hashCode();
        }

        PropertyStoreBuilder.PropertyGroupBuilder builder() {
            return new PropertyStoreBuilder.PropertyGroupBuilder(this.properties);
        }

        Property get(String key) {
            return (Property)this.properties.get(key);
        }

        public int hashCode() {
            return this.hashCode;
        }

        public boolean equals(Object o) {
            return o instanceof PropertyGroup && ObjectUtils.eq(this, (PropertyGroup)o, (x, y) -> ObjectUtils.eq(x.properties, y.properties));
        }

        Set<String> keySet() {
            return this.properties.keySet();
        }

        public Map<String, Property> swap() {
            return this.properties;
        }

        public String toString() {
            return "[hash=" + this.hashCode() + "]" + (SimpleJson.DEFAULT == null ? "" : SimpleJson.DEFAULT.toString(this.properties));
        }

        void hashCodes(StringBuilder sb) {
            for (Map.Entry<String, Property> e : this.properties.entrySet()) {
                sb.append("\n\t\t[" + Integer.toHexString(e.hashCode()) + "] - " + e.getKey());
            }
        }
    }
}

