/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.internal;

import java.lang.reflect.Array;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import org.apache.juneau.FormattedRuntimeException;
import org.apache.juneau.ObjectList;
import org.apache.juneau.ObjectMap;
import org.apache.juneau.internal.ObjectUtils;
import org.apache.juneau.internal.ReverseIterable;
import org.apache.juneau.internal.StringUtils;
import org.apache.juneau.parser.ParseException;

public final class CollectionUtils {
    public static <T> List<T> addIfNotNull(List<T> l, T o) {
        if (o != null) {
            l.add(o);
        }
        return l;
    }

    public static List<?> addReverse(List list, List append) {
        ListIterator i = append.listIterator(append.size());
        while (i.hasPrevious()) {
            list.add(i.previous());
        }
        return list;
    }

    public static List<?> addReverse(List list, Object[] append) {
        for (int i = append.length - 1; i >= 0; --i) {
            list.add(append[i]);
        }
        return list;
    }

    public static <T> Iterable<T> iterable(Collection<T> c, boolean reverse) {
        if (reverse) {
            return new ReverseIterable(c instanceof List ? (List<Object>)c : new ArrayList<T>(c));
        }
        return c;
    }

    public static <T> Iterable<T> iterable(List<T> c, boolean reverse) {
        if (reverse) {
            return new ReverseIterable<T>(c);
        }
        return c;
    }

    public static <T> Iterable<T> reverseIterable(List<T> c) {
        return CollectionUtils.iterable(c, true);
    }

    public static <T> Iterable<T> iterable(T[] c, boolean reverse) {
        if (reverse) {
            return new ReverseIterable<T>(Arrays.asList(c));
        }
        return Arrays.asList(c);
    }

    public static <T> Iterable<T> reverseIterable(T[] c) {
        return CollectionUtils.iterable(c, true);
    }

    public static <E> Iterable<E> iterable(final Enumeration<E> e) {
        if (e == null) {
            return null;
        }
        return new Iterable<E>(){

            @Override
            public Iterator<E> iterator() {
                return new Iterator<E>(){

                    @Override
                    public boolean hasNext() {
                        return e.hasMoreElements();
                    }

                    @Override
                    public E next() {
                        return e.nextElement();
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }
        };
    }

    public static <T> List<T> unmodifiableList(List<T> l) {
        if (l == null || l.isEmpty()) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(l);
    }

    public static <T> List<T> unmodifiableList(T[] l) {
        if (l == null || l.length == 0) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(Arrays.asList(l));
    }

    public static <T> List<T> immutableList(Collection<T> l) {
        if (l == null || l.isEmpty()) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(new ArrayList<T>(l));
    }

    public static <T> List<T> immutableList(T[] l) {
        if (l == null || l.length == 0) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(new ArrayList<T>(Arrays.asList(l)));
    }

    public static <K, V> Map<K, V> immutableMap(Map<K, V> m) {
        if (m == null || m.isEmpty()) {
            return Collections.emptyMap();
        }
        return Collections.unmodifiableMap(new LinkedHashMap<K, V>(m));
    }

    public static <K, V> Map<K, V> unmodifiableMap(Map<K, V> m) {
        if (m == null || m.isEmpty()) {
            return Collections.emptyMap();
        }
        return Collections.unmodifiableMap(m);
    }

    public static <T> List<T> addToList(List<T> appendTo, Object[] values, Class<T> type, Type ... args) {
        if (values == null) {
            return appendTo;
        }
        try {
            List<T> l = appendTo;
            if (appendTo == null) {
                l = new ArrayList<T>();
            }
            for (Object o : values) {
                if (o == null) continue;
                if (StringUtils.isObjectList(o, false)) {
                    for (Object o2 : new ObjectList(o.toString())) {
                        l.add(ObjectUtils.toType(o2, type, args));
                    }
                    continue;
                }
                if (o instanceof Collection) {
                    for (Object o2 : (Collection)o) {
                        l.add(ObjectUtils.toType(o2, type, args));
                    }
                    continue;
                }
                if (o.getClass().isArray()) {
                    for (int i = 0; i < Array.getLength(o); ++i) {
                        l.add(ObjectUtils.toType(Array.get(o, i), type, args));
                    }
                    continue;
                }
                l.add(ObjectUtils.toType(o, type, args));
            }
            return l.isEmpty() ? null : l;
        }
        catch (ParseException e) {
            throw new RuntimeException(e);
        }
    }

    public static <K, V> Map<K, V> addToMap(Map<K, V> appendTo, Object[] values, Class<K> keyType, Class<V> valueType, Type ... valueTypeArgs) {
        if (values == null) {
            return appendTo;
        }
        try {
            Map<K, V> m = appendTo;
            if (m == null) {
                m = new LinkedHashMap();
            }
            for (Object o : values) {
                if (o == null) continue;
                if (StringUtils.isObjectMap(o, false)) {
                    for (Map.Entry<String, Object> entry : new ObjectMap(o.toString()).entrySet()) {
                        m.put(ObjectUtils.toType(entry.getKey(), keyType), ObjectUtils.toType(entry.getValue(), valueType, valueTypeArgs));
                    }
                    continue;
                }
                if (o instanceof Map) {
                    for (Map.Entry<String, Object> entry : ((Map)o).entrySet()) {
                        m.put(ObjectUtils.toType(entry.getKey(), keyType), ObjectUtils.toType(entry.getValue(), valueType, valueTypeArgs));
                    }
                    continue;
                }
                throw new FormattedRuntimeException("Invalid object type {0} passed to addToMap()", o.getClass().getName());
            }
            return m.isEmpty() ? null : m;
        }
        catch (ParseException e) {
            throw new RuntimeException(e);
        }
    }

    public static <T> List<T> newList(Collection<T> val) {
        if (val == null) {
            return null;
        }
        return new ArrayList<T>(val);
    }

    public static <T> List<T> addToList(List<T> l, Collection<T> val) {
        if (val != null) {
            if (l == null) {
                l = new ArrayList<T>(val);
            } else {
                l.addAll(val);
            }
        }
        return l;
    }

    public static <K, V> Map<K, V> newMap(Map<K, V> val) {
        if (val == null) {
            return null;
        }
        return new LinkedHashMap<K, V>(val);
    }

    public static <K, V> Map<K, V> addToMap(Map<K, V> m, Map<K, V> val) {
        if (val != null) {
            if (m == null) {
                m = new LinkedHashMap<K, V>(val);
            } else {
                m.putAll(val);
            }
        }
        return m;
    }

    public static <K, V> Map<K, V> addToMap(Map<K, V> m, K key, V value) {
        if (m == null) {
            m = new LinkedHashMap();
        }
        m.put(key, value);
        return m;
    }

    public static <K, V> Map<K, V> newSortedMap(Map<K, V> val, Comparator<K> comparator) {
        if (val == null) {
            return null;
        }
        TreeMap<K, V> m = new TreeMap<K, V>(comparator);
        m.putAll(val);
        return m;
    }

    public static Set<String> newSortedCaseInsensitiveSet(String ... values) {
        TreeSet<String> s = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER){
            private static final long serialVersionUID = 1L;

            @Override
            public boolean contains(Object v) {
                return v == null ? false : super.contains(v);
            }
        };
        for (String v : values) {
            if (v == null) continue;
            s.add(v);
        }
        return s;
    }

    public static Set<String> newSortedCaseInsensitiveSet(String values) {
        return CollectionUtils.newSortedCaseInsensitiveSet(StringUtils.split(StringUtils.emptyIfNull(values)));
    }

    public static Set<String> newUnmodifiableSortedCaseInsensitiveSet(String values) {
        return Collections.unmodifiableSet(CollectionUtils.newSortedCaseInsensitiveSet(StringUtils.split(StringUtils.emptyIfNull(values))));
    }

    public static <K, V> Map<K, V> addToSortedMap(Map<K, V> m, Map<K, V> val, Comparator<K> comparator) {
        if (val != null) {
            if (m == null) {
                m = new TreeMap(comparator);
                m.putAll(val);
            } else {
                m.putAll(val);
            }
        }
        return m;
    }

    public static <K, V> Map<K, V> addToSortedMap(Map<K, V> m, K key, V value, Comparator<K> comparator) {
        if (m == null) {
            m = new TreeMap(comparator);
        }
        m.put(key, value);
        return m;
    }

    @SafeVarargs
    public static <T> Set<T> newUnmodifiableHashSet(T ... values) {
        return Collections.unmodifiableSet(CollectionUtils.newHashSet(values));
    }

    @SafeVarargs
    public static <T> Set<T> newHashSet(T ... values) {
        return new HashSet<T>(Arrays.asList(values));
    }

    @SafeVarargs
    public static <T> Set<T> newUnmodifiableLinkedHashSet(T ... values) {
        return Collections.unmodifiableSet(CollectionUtils.newLinkedHashSet(values));
    }

    @SafeVarargs
    public static <T> Set<T> newLinkedHashSet(T ... values) {
        return new LinkedHashSet<T>(Arrays.asList(values));
    }

    public static <T> Set<T> emptySet() {
        return Collections.emptySet();
    }

    public static <T> List<T> emptyList() {
        return Collections.emptyList();
    }

    public static <K, V> Map<K, V> emptyMap() {
        return Collections.emptyMap();
    }
}

