/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.http;

import java.util.Map;
import java.util.TreeMap;

public enum HttpMethod {
    OPTIONS,
    GET,
    HEAD,
    POST,
    PUT,
    DELETE,
    TRACE,
    CONNECT,
    OTHER;

    private static final Map<String, HttpMethod> cache;

    public static HttpMethod forString(String key) {
        HttpMethod m = cache.get(key);
        return m == null ? OTHER : m;
    }

    static {
        cache = new TreeMap<String, HttpMethod>(String.CASE_INSENSITIVE_ORDER);
        cache.put("OPTIONS", OPTIONS);
        cache.put("GET", GET);
        cache.put("HEAD", HEAD);
        cache.put("POST", POST);
        cache.put("PUT", PUT);
        cache.put("DELETE", DELETE);
        cache.put("TRACE", TRACE);
        cache.put("CONNECT", CONNECT);
    }
}

