/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.control.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.JTextField;
import net.miginfocom.swing.MigLayout;
import org.apache.jmeter.control.ThroughputController;
import org.apache.jmeter.control.gui.AbstractControllerGui;
import org.apache.jmeter.gui.GUIMenuSortOrder;
import org.apache.jmeter.gui.TestElementMetadata;
import org.apache.jmeter.testelement.TestElement;
import org.apache.jmeter.util.JMeterUtils;

@GUIMenuSortOrder(value=101)
@TestElementMetadata(labelResource="throughput_control_title")
public class ThroughputControllerGui
extends AbstractControllerGui {
    private static final long serialVersionUID = 240L;
    private JComboBox<String> styleBox;
    private int style;
    private JTextField throughput;
    private JCheckBox perthread;
    private boolean isPerThread = true;
    private final String BYNUMBER_LABEL = JMeterUtils.getResString((String)"throughput_control_bynumber_label");
    private final String BYPERCENT_LABEL = JMeterUtils.getResString((String)"throughput_control_bypercent_label");
    private final String PERTHREAD_LABEL = JMeterUtils.getResString((String)"throughput_control_perthread_label");

    public ThroughputControllerGui() {
        this.init();
    }

    public TestElement createTestElement() {
        ThroughputController tc = new ThroughputController();
        this.modifyTestElement((TestElement)tc);
        return tc;
    }

    public void modifyTestElement(TestElement tc) {
        this.configureTestElement(tc);
        ((ThroughputController)tc).setStyle(this.style);
        ((ThroughputController)tc).setPerThread(this.isPerThread);
        if (this.style == 0) {
            try {
                ((ThroughputController)tc).setMaxThroughput(Integer.parseInt(this.throughput.getText().trim()));
            }
            catch (NumberFormatException e) {
                ((ThroughputController)tc).setMaxThroughput(this.throughput.getText().trim().split("\\.")[0]);
            }
        } else {
            try {
                ((ThroughputController)tc).setPercentThroughput(Float.parseFloat(this.throughput.getText().trim()));
            }
            catch (NumberFormatException e) {
                ((ThroughputController)tc).setPercentThroughput(this.throughput.getText());
            }
        }
    }

    public void clearGui() {
        super.clearGui();
        this.styleBox.setSelectedIndex(1);
        this.throughput.setText("1");
        this.perthread.setSelected(false);
    }

    public void configure(TestElement el) {
        super.configure(el);
        if (((ThroughputController)el).getStyle() == 0) {
            this.styleBox.getModel().setSelectedItem(this.BYNUMBER_LABEL);
            this.throughput.setText(((ThroughputController)el).getMaxThroughput());
        } else {
            this.styleBox.setSelectedItem(this.BYPERCENT_LABEL);
            this.throughput.setText(((ThroughputController)el).getPercentThroughput());
        }
        this.perthread.setSelected(((ThroughputController)el).isPerThread());
    }

    public String getLabelResource() {
        return "throughput_control_title";
    }

    private void init() {
        this.setLayout(new BorderLayout());
        this.setBorder(this.makeBorder());
        JPanel panel = new JPanel((LayoutManager)new MigLayout("fillx, wrap 2", "[][fill,grow]"));
        DefaultComboBoxModel<String> styleModel = new DefaultComboBoxModel<String>();
        styleModel.addElement(this.BYNUMBER_LABEL);
        styleModel.addElement(this.BYPERCENT_LABEL);
        this.styleBox = new JComboBox(styleModel);
        this.styleBox.addActionListener(evt -> {
            this.style = ((String)this.styleBox.getSelectedItem()).equals(this.BYNUMBER_LABEL) ? 0 : 1;
        });
        panel.add(JMeterUtils.labelFor(this.styleBox, (String)"throughput_control_mode"));
        panel.add(this.styleBox);
        this.throughput = new JTextField(15);
        panel.add(JMeterUtils.labelFor((Component)this.throughput, (String)"throughput_control_tplabel"));
        panel.add(this.throughput);
        this.throughput.setText("1");
        this.perthread = new JCheckBox(this.PERTHREAD_LABEL, this.isPerThread);
        this.perthread.addItemListener(evt -> {
            this.isPerThread = evt.getStateChange() == 1;
        });
        panel.add((Component)this.perthread, "span 2");
        this.add(this.makeTitlePanel(), "North");
        this.add(panel, "Center");
    }
}

