/*
 * Decompiled with CFR 0.152.
 */
package org.jCharts.test;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.Stroke;
import org.jCharts.axisChart.AxisChart;
import org.jCharts.chartData.AxisChartDataSet;
import org.jCharts.chartData.ChartDataException;
import org.jCharts.chartData.DataSeries;
import org.jCharts.properties.AxisProperties;
import org.jCharts.properties.ChartProperties;
import org.jCharts.properties.ChartTypeProperties;
import org.jCharts.properties.DataAxisProperties;
import org.jCharts.properties.LegendProperties;
import org.jCharts.properties.LineChartProperties;
import org.jCharts.properties.PointChartProperties;
import org.jCharts.properties.PropertyException;
import org.jCharts.test.AxisChartTestBase;
import org.jCharts.test.ChartTestDriver;
import org.jCharts.test.TestDataGenerator;
import org.jCharts.types.ChartType;

class LineTestDriver
extends AxisChartTestBase {
    LineTestDriver() {
    }

    boolean supportsImageMap() {
        return true;
    }

    static ChartTypeProperties getChartTypeProperties(int n) {
        Stroke[] strokeArray = new Stroke[n];
        int n2 = 0;
        while (n2 < n) {
            strokeArray[n2] = LineChartProperties.DEFAULT_LINE_STROKE;
            ++n2;
        }
        strokeArray[0] = new BasicStroke(3.0f);
        Shape[] shapeArray = new Shape[n];
        int n3 = 0;
        while (n3 < n) {
            shapeArray[n3] = PointChartProperties.SHAPE_DIAMOND;
            ++n3;
        }
        shapeArray[0] = PointChartProperties.SHAPE_CIRCLE;
        return new LineChartProperties(strokeArray, shapeArray);
    }

    DataSeries getDataSeries() throws ChartDataException {
        int n = (int)TestDataGenerator.getRandomNumber(3.0, 3.0);
        int n2 = (int)TestDataGenerator.getRandomNumber(1.0, 1.0);
        DataSeries dataSeries = super.createDataSeries(n);
        AxisChartDataSet axisChartDataSet = super.createAxisChartDataSet(ChartType.LINE, LineTestDriver.getChartTypeProperties(n2), n2, n, 10, 5000);
        dataSeries.addIAxisPlotDataSet(axisChartDataSet);
        return dataSeries;
    }

    public static void main(String[] stringArray) throws ChartDataException, PropertyException {
        LineChartProperties lineChartProperties = (LineChartProperties)LineTestDriver.getChartTypeProperties(1);
        double[][] dArrayArray = new double[][]{{280.0, 16.0, 150.0, 90.0}};
        Paint[] paintArray = new Paint[]{Color.blue};
        String[] stringArray2 = new String[]{"Test Legend Label"};
        AxisChartDataSet axisChartDataSet = new AxisChartDataSet(dArrayArray, stringArray2, paintArray, ChartType.LINE, lineChartProperties);
        String[] stringArray3 = null;
        DataSeries dataSeries = new DataSeries(stringArray3, "X-Axis Title", "Y-Axis Title", "Chart Title");
        dataSeries.addIAxisPlotDataSet(axisChartDataSet);
        ChartProperties chartProperties = new ChartProperties();
        AxisProperties axisProperties = new AxisProperties(false);
        axisProperties.getYAxisProperties().setShowAxisLabels(false);
        axisProperties.getXAxisProperties().setShowAxisLabels(false);
        DataAxisProperties dataAxisProperties = (DataAxisProperties)axisProperties.getYAxisProperties();
        dataAxisProperties.setUserDefinedScale(-10.0, 50.0);
        dataAxisProperties.setNumItems(4);
        dataAxisProperties.setRoundToNearest(1);
        LegendProperties legendProperties = new LegendProperties();
        AxisChart axisChart = new AxisChart(dataSeries, chartProperties, axisProperties, legendProperties, 500, 400);
        ChartTestDriver.exportImage(axisChart, "LineChartTest.png");
    }
}

