/*
 * Decompiled with CFR 0.152.
 */
package org.jCharts.test;

import java.awt.Color;
import java.awt.Paint;
import org.jCharts.axisChart.AxisChart;
import org.jCharts.chartData.AxisChartDataSet;
import org.jCharts.chartData.ChartDataException;
import org.jCharts.chartData.DataSeries;
import org.jCharts.properties.AreaChartProperties;
import org.jCharts.properties.AxisProperties;
import org.jCharts.properties.ChartProperties;
import org.jCharts.properties.ChartTypeProperties;
import org.jCharts.properties.DataAxisProperties;
import org.jCharts.properties.LegendProperties;
import org.jCharts.properties.PropertyException;
import org.jCharts.properties.StackedAreaChartProperties;
import org.jCharts.test.AxisChartTestBase;
import org.jCharts.test.ChartTestDriver;
import org.jCharts.test.TestDataGenerator;
import org.jCharts.types.ChartType;

class AreaTestDriver
extends AxisChartTestBase {
    AreaTestDriver() {
    }

    boolean supportsImageMap() {
        return false;
    }

    static ChartTypeProperties getChartTypeProperties(int n) {
        return new AreaChartProperties();
    }

    DataSeries getDataSeries() throws ChartDataException {
        int n = (int)TestDataGenerator.getRandomNumber(10.0, 50.0);
        int n2 = (int)TestDataGenerator.getRandomNumber(1.0, 3.0);
        DataSeries dataSeries = super.createDataSeries(n);
        ChartType chartType = null;
        chartType = TestDataGenerator.getRandomNumber(1.0) > 0.5 ? ChartType.AREA : ChartType.AREA_STACKED;
        AxisChartDataSet axisChartDataSet = super.createAxisChartDataSet(chartType, AreaTestDriver.getChartTypeProperties(n2), n2, n, 0, 5000);
        dataSeries.addIAxisPlotDataSet(axisChartDataSet);
        return dataSeries;
    }

    public static void main(String[] stringArray) throws ChartDataException, PropertyException {
        StackedAreaChartProperties stackedAreaChartProperties = new StackedAreaChartProperties();
        AreaChartProperties areaChartProperties = new AreaChartProperties();
        double[][] dArrayArray = new double[][]{{10.0, 15.0, 30.0}, {30.0, 30.0, 10.0}, {20.0, 25.0, 20.0}};
        Paint[] paintArray = new Paint[]{new Color(0, 255, 0, 100), new Color(255, 0, 0, 100), new Color(0, 0, 255, 100)};
        String[] stringArray2 = new String[]{"Legend Label", "Legend Label", "Legend Label"};
        AxisChartDataSet axisChartDataSet = new AxisChartDataSet(dArrayArray, stringArray2, paintArray, ChartType.AREA, areaChartProperties);
        String[] stringArray3 = new String[]{"1", "2", "3"};
        DataSeries dataSeries = new DataSeries(stringArray3, "X-Axis Title", "Y-Axis Title", "Chart Title");
        dataSeries.addIAxisPlotDataSet(axisChartDataSet);
        ChartProperties chartProperties = new ChartProperties();
        AxisProperties axisProperties = new AxisProperties(false);
        DataAxisProperties dataAxisProperties = (DataAxisProperties)axisProperties.getYAxisProperties();
        dataAxisProperties.setNumItems(4);
        dataAxisProperties.setRoundToNearest(1);
        LegendProperties legendProperties = new LegendProperties();
        AxisChart axisChart = new AxisChart(dataSeries, chartProperties, axisProperties, legendProperties, 500, 400);
        ChartTestDriver.exportImage(axisChart, "AreaChartTest.png");
    }
}

