/*
 * Decompiled with CFR 0.152.
 */
package com.helger.commons.io.file;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.equals.EqualsHelper;
import com.helger.commons.hashcode.HashCodeGenerator;
import com.helger.commons.io.file.EFileIOErrorCode;
import com.helger.commons.io.file.EFileIOOperation;
import com.helger.commons.state.ISuccessIndicator;
import com.helger.commons.string.ToStringGenerator;
import java.io.File;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;

@Immutable
public class FileIOError
implements ISuccessIndicator {
    private final EFileIOOperation m_eOperation;
    private final EFileIOErrorCode m_eCode;
    private final File m_aFile1;
    private final File m_aFile2;
    private final Exception m_aException;

    public FileIOError(@Nonnull EFileIOOperation eFileIOOperation, @Nonnull EFileIOErrorCode eFileIOErrorCode) {
        this(eFileIOOperation, eFileIOErrorCode, null, null, null);
    }

    public FileIOError(@Nonnull EFileIOOperation eFileIOOperation, @Nonnull EFileIOErrorCode eFileIOErrorCode, @Nonnull File file) {
        this(eFileIOOperation, eFileIOErrorCode, ValueEnforcer.notNull(file, "File1"), null, null);
    }

    public FileIOError(@Nonnull EFileIOOperation eFileIOOperation, @Nonnull EFileIOErrorCode eFileIOErrorCode, @Nonnull File file, @Nonnull File file2) {
        this(eFileIOOperation, eFileIOErrorCode, ValueEnforcer.notNull(file, "File1"), ValueEnforcer.notNull(file2, "File2"), null);
    }

    public FileIOError(@Nonnull EFileIOOperation eFileIOOperation, @Nonnull EFileIOErrorCode eFileIOErrorCode, @Nonnull Exception exception) {
        this(eFileIOOperation, eFileIOErrorCode, null, null, ValueEnforcer.notNull(exception, "Exception"));
    }

    public FileIOError(@Nonnull EFileIOOperation eFileIOOperation, @Nonnull EFileIOErrorCode eFileIOErrorCode, @Nullable File file, @Nullable File file2, @Nullable Exception exception) {
        this.m_eOperation = ValueEnforcer.notNull(eFileIOOperation, "Operation");
        this.m_eCode = ValueEnforcer.notNull(eFileIOErrorCode, "ErrorCode");
        this.m_aFile1 = file;
        this.m_aFile2 = file2;
        this.m_aException = exception;
    }

    @Nonnull
    public EFileIOOperation getOperation() {
        return this.m_eOperation;
    }

    @Nonnull
    public EFileIOErrorCode getErrorCode() {
        return this.m_eCode;
    }

    @Override
    public boolean isSuccess() {
        return this.m_eCode.isSuccess();
    }

    @Nullable
    public File getFile1() {
        return this.m_aFile1;
    }

    public boolean hasFile1() {
        return this.m_aFile1 != null;
    }

    @Nullable
    public File getFile2() {
        return this.m_aFile2;
    }

    public boolean hasFile2() {
        return this.m_aFile2 != null;
    }

    @Nullable
    public Exception getException() {
        return this.m_aException;
    }

    public boolean hasException() {
        return this.m_aException != null;
    }

    @Nonnull
    public FileIOError withoutErrorCode() {
        if (this.m_eCode.isSuccess()) {
            return this;
        }
        return new FileIOError(this.m_eOperation, EFileIOErrorCode.NO_ERROR, this.m_aFile1, this.m_aFile2, this.m_aException);
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        FileIOError fileIOError = (FileIOError)object;
        return this.m_eOperation == fileIOError.m_eOperation && this.m_eCode == fileIOError.m_eCode && EqualsHelper.equals(this.m_aFile1, fileIOError.m_aFile1) && EqualsHelper.equals(this.m_aFile2, fileIOError.m_aFile2) && EqualsHelper.equals(this.m_aException, fileIOError.m_aException);
    }

    public int hashCode() {
        return ((HashCodeGenerator)((HashCodeGenerator)new HashCodeGenerator(this).append((Enum)this.m_eOperation)).append((Enum)this.m_eCode)).append(this.m_aFile1).append(this.m_aFile2).append(this.m_aException).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator(this).append("operation", this.m_eOperation).append("ecode", this.m_eCode).appendIfNotNull("file1", this.m_aFile1).appendIfNotNull("file2", this.m_aFile2).appendIfNotNull("exception", this.m_aException).getToString();
    }
}

