/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.report.processor;

import org.apache.jmeter.report.core.Sample;
import org.apache.jmeter.report.processor.AbstractSummaryConsumer;
import org.apache.jmeter.report.processor.ErrorsSummaryConsumer;
import org.apache.jmeter.report.processor.ListResultData;
import org.apache.jmeter.report.processor.Top5ErrorsSummaryData;
import org.apache.jmeter.report.processor.ValueResultData;
import org.apache.jmeter.util.JMeterUtils;

public class Top5ErrorsBySamplerConsumer
extends AbstractSummaryConsumer<Top5ErrorsSummaryData> {
    static final int MAX_NUMBER_OF_ERRORS_IN_TOP = 5;
    private boolean ignoreTCFromTop5ErrorsBySampler;

    public Top5ErrorsBySamplerConsumer() {
        super(false);
    }

    private void aggregateSample(Sample sample, Top5ErrorsSummaryData data, boolean isOverall) {
        if (sample.isController() && (isOverall || this.ignoreTCFromTop5ErrorsBySampler)) {
            return;
        }
        if (!sample.getSuccess()) {
            data.registerError(ErrorsSummaryConsumer.getErrorKey(sample));
            data.incErrors();
        }
        data.incTotal();
    }

    @Override
    protected void updateData(AbstractSummaryConsumer.SummaryInfo info, Sample sample) {
        AbstractSummaryConsumer.SummaryInfo overallInfo = this.getOverallInfo();
        if (overallInfo.getData() == null) {
            overallInfo.setData(new Top5ErrorsSummaryData());
        }
        if (info.getData() == null) {
            info.setData(new Top5ErrorsSummaryData());
        }
        if (!sample.isEmptyController()) {
            this.aggregateSample(sample, (Top5ErrorsSummaryData)info.getData(), false);
            this.aggregateSample(sample, (Top5ErrorsSummaryData)overallInfo.getData(), true);
        }
    }

    @Override
    protected ListResultData createDataResult(String key, Top5ErrorsSummaryData data) {
        ListResultData result = new ListResultData();
        long errors = data.getErrors();
        if (errors > 0L || key == null) {
            int i;
            result.addResult(new ValueResultData(key != null ? key : JMeterUtils.getResString("reportgenerator_top5_total")));
            long total = data.getTotal();
            result.addResult(new ValueResultData(total));
            result.addResult(new ValueResultData(errors));
            Object[][] top5 = data.getTop5ErrorsMetrics();
            int numberOfValues = 0;
            for (i = 0; i < top5.length; ++i) {
                result.addResult(new ValueResultData(top5[i][0]));
                result.addResult(new ValueResultData(top5[i][1]));
                ++numberOfValues;
            }
            for (i = numberOfValues; i < 5; ++i) {
                result.addResult(new ValueResultData(""));
                result.addResult(new ValueResultData(""));
            }
        }
        return result;
    }

    @Override
    protected String getKeyFromSample(Sample sample) {
        return sample.getName();
    }

    @Override
    protected ListResultData createResultTitles() {
        ListResultData titles = new ListResultData();
        titles.addResult(new ValueResultData(JMeterUtils.getResString("reportgenerator_top5_label")));
        titles.addResult(new ValueResultData(JMeterUtils.getResString("reportgenerator_top5_sample_count")));
        titles.addResult(new ValueResultData(JMeterUtils.getResString("reportgenerator_top5_error_count")));
        for (int i = 0; i < 5; ++i) {
            titles.addResult(new ValueResultData(JMeterUtils.getResString("reportgenerator_top5_error_label")));
            titles.addResult(new ValueResultData(JMeterUtils.getResString("reportgenerator_top5_error_count")));
        }
        return titles;
    }

    public void setIgnoreTransactionController(boolean ignoreTCFromTop5ErrorsBySampler) {
        this.ignoreTCFromTop5ErrorsBySampler = ignoreTCFromTop5ErrorsBySampler;
    }
}

