/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.gui.action;

import com.google.auto.service.AutoService;
import java.awt.event.ActionEvent;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.swing.JOptionPane;
import org.apache.jmeter.exceptions.IllegalUserActionException;
import org.apache.jmeter.gui.GuiPackage;
import org.apache.jmeter.gui.action.AbstractAction;
import org.apache.jmeter.gui.action.Command;
import org.apache.jmeter.gui.tree.JMeterTreeNode;
import org.apache.jmeter.testelement.TestElement;
import org.apache.jorphan.util.HeapDumper;
import org.apache.jorphan.util.ThreadDumper;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.core.config.Configurator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@AutoService(value={Command.class})
public class What
extends AbstractAction {
    private static final Logger log = LoggerFactory.getLogger(What.class);
    private static final Set<String> commandSet;

    @Override
    public void doAction(ActionEvent e) throws IllegalUserActionException {
        JMeterTreeNode node = GuiPackage.getInstance().getTreeListener().getCurrentNode();
        TestElement te = (TestElement)node.getUserObject();
        if ("what_class".equals(e.getActionCommand())) {
            String guiClassName = te.getPropertyAsString("TestElement.gui_class");
            System.out.println(te.getClass().getName());
            System.out.println(guiClassName);
            if (log.isInfoEnabled()) {
                log.info("TestElement: {}, guiClassName: {}", te.getClass(), (Object)guiClassName);
            }
        } else if ("debug_on".equals(e.getActionCommand())) {
            String loggerName = te.getClass().getName();
            Configurator.setAllLevels((String)loggerName, (Level)Level.DEBUG);
            log.info("Log level set to DEBUG for {}", (Object)loggerName);
        } else if ("debug_off".equals(e.getActionCommand())) {
            String loggerName = te.getClass().getName();
            Configurator.setAllLevels((String)loggerName, (Level)Level.INFO);
            log.info("Log level set to INFO for {}", (Object)loggerName);
        } else if ("heap_dump".equals(e.getActionCommand())) {
            try {
                String s = HeapDumper.dumpHeap();
                JOptionPane.showMessageDialog(null, "Created " + s, "HeapDump", 1);
            }
            catch (Exception ex) {
                JOptionPane.showMessageDialog(null, ex.toString(), "HeapDump", 0);
            }
        } else if ("thread_dump".equals(e.getActionCommand())) {
            try {
                String s = ThreadDumper.threadDump();
                JOptionPane.showMessageDialog(null, "Created " + s, "ThreadDump", 1);
            }
            catch (Exception ex) {
                JOptionPane.showMessageDialog(null, ex.toString(), "ThreadDump", 0);
            }
        }
    }

    @Override
    public Set<String> getActionNames() {
        return commandSet;
    }

    static {
        HashSet<String> commands = new HashSet<String>();
        commands.add("what_class");
        commands.add("debug_on");
        commands.add("debug_off");
        commands.add("heap_dump");
        commands.add("thread_dump");
        commandSet = Collections.unmodifiableSet(commands);
    }
}

