/*
 * Decompiled with CFR 0.152.
 */
package com.github.weisj.darklaf.ui.taskpane;

import com.github.weisj.darklaf.graphics.PaintUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.UIResource;
import org.jdesktop.swingx.JXHyperlink;
import org.jdesktop.swingx.JXTaskPane;
import org.jdesktop.swingx.plaf.basic.BasicTaskPaneUI;
import org.jdesktop.swingx.plaf.metal.MetalTaskPaneUI;

public class DarkTaskPaneUI
extends MetalTaskPaneUI {
    public static final String KEY_COLLAPSED = "collapsed";
    protected boolean isCollapsed;
    protected Color borderColor;
    protected Icon collapsedIcon;
    protected Icon openIcon;
    protected int arc;

    public static ComponentUI createUI(JComponent c) {
        return new DarkTaskPaneUI();
    }

    protected void installDefaults() {
        this.borderColor = UIManager.getColor("TaskPane.borderColor");
        this.arc = UIManager.getInt("TaskPane.arc");
        this.collapsedIcon = UIManager.getIcon("TaskPane.collapsed.icon");
        this.openIcon = UIManager.getIcon("TaskPane.open.icon");
        super.installDefaults();
    }

    protected Border createPaneBorder() {
        return new DarkPaneBorder();
    }

    protected void installListeners() {
        super.installListeners();
        this.group.addPropertyChangeListener("animationState", e -> {
            this.isCollapsed = KEY_COLLAPSED.equals(e.getNewValue());
        });
    }

    protected Border createContentPaneBorder() {
        return new CompoundBorder(new DarkContentPaneBorder(this.borderColor, this.arc), BorderFactory.createEmptyBorder(10, 10, 10, 10));
    }

    protected void configure(JXHyperlink link) {
        super.configure(link);
        link.setFocusPainted(false);
    }

    protected int getRoundHeight() {
        return this.arc;
    }

    protected boolean isCollapsed() {
        if (!this.group.isAnimated()) {
            return this.group.isCollapsed();
        }
        return this.isCollapsed;
    }

    protected class DarkPaneBorder
    extends BasicTaskPaneUI.PaneBorder {
        protected DarkPaneBorder() {
            super((BasicTaskPaneUI)DarkTaskPaneUI.this);
        }

        protected void paintTitleBackground(JXTaskPane group, Graphics g2) {
            Graphics2D g = (Graphics2D)g2;
            int w = group.getWidth();
            int h = group.getHeight();
            if (group.isSpecial()) {
                g.setColor(this.specialTitleBackground);
            } else {
                g.setColor(this.titleBackgroundGradientStart);
            }
            if (DarkTaskPaneUI.this.isCollapsed()) {
                PaintUtil.fillRoundRect(g, 0.0f, 0.0f, w, h, DarkTaskPaneUI.this.getRoundHeight());
                g.setColor(this.borderColor);
                PaintUtil.paintLineBorder(g, 0.0f, 0.0f, w, h, DarkTaskPaneUI.this.getRoundHeight());
            } else {
                Rectangle clip = g.getClip().getBounds();
                g.setClip(0, 0, w, h / 2 + 1);
                PaintUtil.fillRoundRect(g, 0.0f, 0.0f, w, h, DarkTaskPaneUI.this.getRoundHeight());
                g.setClip(0, h / 2, w, h / 2);
                g.fillRect(0, 0, w, h);
                g.setColor(this.borderColor);
                g.setClip(0, 0, w, h / 2);
                PaintUtil.paintLineBorder(g, 0.0f, 0.0f, w, h, DarkTaskPaneUI.this.getRoundHeight());
                g.setClip(0, h / 2, w, h / 2);
                PaintUtil.drawRect((Graphics)g, 0, 0, w, h, 1);
                g.setClip(clip);
            }
        }

        protected void configureLabel(JXTaskPane group) {
            super.configureLabel(group);
            this.label.setFont(this.label.getFont().deriveFont(0));
        }

        protected void paintExpandedControls(JXTaskPane group, Graphics g, int x, int y, int width, int height) {
            ((Graphics2D)g).setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            g.setColor(this.getPaintColor(group));
            if (group.isCollapsed()) {
                DarkTaskPaneUI.this.collapsedIcon.paintIcon((Component)group, g, x, y);
            } else {
                DarkTaskPaneUI.this.openIcon.paintIcon((Component)group, g, x, y);
            }
            ((Graphics2D)g).setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
        }

        protected boolean isMouseOverBorder() {
            return true;
        }
    }

    protected static class DarkContentPaneBorder
    implements Border,
    UIResource {
        protected final Color color;
        protected final int arc;

        public DarkContentPaneBorder(Color color, int arc) {
            this.arc = arc;
            this.color = color;
        }

        @Override
        public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
            Rectangle clip = g.getClip().getBounds();
            int h = height + this.arc;
            g.setClip(clip.x, clip.y, width, h / 2 + 1);
            g.setColor(this.color);
            PaintUtil.drawRect(g, x, y, width, h, 1);
            if (c.isOpaque()) {
                g.setColor(c.getBackground());
                g.setClip(clip.x, clip.x + h - this.arc, width, this.arc);
                PaintUtil.fillRoundRect((Graphics2D)g, x, y, width, h, this.arc);
            }
            g.setClip(clip.x, clip.y + h / 2, width, h / 2);
            g.setColor(this.color);
            PaintUtil.paintLineBorder((Graphics2D)g, x, y, width, h, this.arc);
            g.setClip(clip);
        }

        @Override
        public Insets getBorderInsets(Component c) {
            return new Insets(0, 1, 1, 1);
        }

        @Override
        public boolean isBorderOpaque() {
            return true;
        }
    }
}

