/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.letsPlot.core.plot.builder.tooltip.spec;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.letsPlot.commons.geometry.DoubleVector;
import org.jetbrains.letsPlot.commons.values.Color;
import org.jetbrains.letsPlot.core.plot.base.Aes;
import org.jetbrains.letsPlot.core.plot.base.PlotContext;
import org.jetbrains.letsPlot.core.plot.base.theme.AxisTheme;
import org.jetbrains.letsPlot.core.plot.base.tooltip.ContextualMapping;
import org.jetbrains.letsPlot.core.plot.base.tooltip.GeomTarget;
import org.jetbrains.letsPlot.core.plot.base.tooltip.LineSpec;
import org.jetbrains.letsPlot.core.plot.base.tooltip.TipLayoutHint;
import org.jetbrains.letsPlot.core.plot.base.tooltip.TooltipAnchor;
import org.jetbrains.letsPlot.core.plot.builder.tooltip.spec.TooltipSpec;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\u0013B-\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\t\u00a2\u0006\u0002\u0010\u000bJ\u001c\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/letsPlot/core/plot/builder/tooltip/spec/TooltipSpecFactory;", "", "contextualMapping", "Lorg/jetbrains/letsPlot/core/plot/base/tooltip/ContextualMapping;", "axisOrigin", "Lorg/jetbrains/letsPlot/commons/geometry/DoubleVector;", "flippedAxis", "", "xAxisTheme", "Lorg/jetbrains/letsPlot/core/plot/base/theme/AxisTheme;", "yAxisTheme", "(Lorg/jetbrains/letsPlot/core/plot/base/tooltip/ContextualMapping;Lorg/jetbrains/letsPlot/commons/geometry/DoubleVector;ZLorg/jetbrains/letsPlot/core/plot/base/theme/AxisTheme;Lorg/jetbrains/letsPlot/core/plot/base/theme/AxisTheme;)V", "create", "", "Lorg/jetbrains/letsPlot/core/plot/builder/tooltip/spec/TooltipSpec;", "geomTarget", "Lorg/jetbrains/letsPlot/core/plot/base/tooltip/GeomTarget;", "ctx", "Lorg/jetbrains/letsPlot/core/plot/base/PlotContext;", "Helper", "plot-builder"})
public final class TooltipSpecFactory {
    @NotNull
    private final ContextualMapping contextualMapping;
    @NotNull
    private final DoubleVector axisOrigin;
    private final boolean flippedAxis;
    @NotNull
    private final AxisTheme xAxisTheme;
    @NotNull
    private final AxisTheme yAxisTheme;

    public TooltipSpecFactory(@NotNull ContextualMapping contextualMapping, @NotNull DoubleVector axisOrigin, boolean flippedAxis, @NotNull AxisTheme xAxisTheme, @NotNull AxisTheme yAxisTheme) {
        Intrinsics.checkNotNullParameter((Object)contextualMapping, (String)"contextualMapping");
        Intrinsics.checkNotNullParameter((Object)axisOrigin, (String)"axisOrigin");
        Intrinsics.checkNotNullParameter((Object)xAxisTheme, (String)"xAxisTheme");
        Intrinsics.checkNotNullParameter((Object)yAxisTheme, (String)"yAxisTheme");
        this.contextualMapping = contextualMapping;
        this.axisOrigin = axisOrigin;
        this.flippedAxis = flippedAxis;
        this.xAxisTheme = xAxisTheme;
        this.yAxisTheme = yAxisTheme;
    }

    @NotNull
    public final List<TooltipSpec> create(@NotNull GeomTarget geomTarget, @NotNull PlotContext ctx) {
        Intrinsics.checkNotNullParameter((Object)geomTarget, (String)"geomTarget");
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        return new ArrayList(new Helper(geomTarget, this.flippedAxis, ctx).createTooltipSpecs$plot_builder());
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\b\u0003\b\u0082\u0004\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u000e\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u000b0\nH\u0002J\u000e\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00160\nH\u0002J\u001c\u0010\u0017\u001a\u00020\u00182\n\u0010\u0019\u001a\u0006\u0012\u0002\b\u00030\u001a2\u0006\u0010\u0004\u001a\u00020\u0005H\u0002J\u0013\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00160\nH\u0000\u00a2\u0006\u0002\b\u001cJ\u000e\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u000b0\nH\u0002J\u000e\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00160\nH\u0002J\b\u0010\u001f\u001a\u00020 H\u0002J\u000e\u0010!\u001a\b\u0012\u0004\u0012\u00020\u000b0\nH\u0002J\u0018\u0010\"\u001a\u0012\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u001a\u0012\u0004\u0012\u00020\u00180#H\u0002J\u000e\u0010$\u001a\b\u0012\u0004\u0012\u00020\u00160\nH\u0002J\b\u0010%\u001a\u00020\u0018H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\r\u001a\u0004\u0018\u00010\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u000f\u001a\u0004\u0018\u00010\u0010X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0011R\u0010\u0010\u0012\u001a\u0004\u0018\u00010\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006&"}, d2={"Lorg/jetbrains/letsPlot/core/plot/builder/tooltip/spec/TooltipSpecFactory$Helper;", "", "myGeomTarget", "Lorg/jetbrains/letsPlot/core/plot/base/tooltip/GeomTarget;", "flippedAxis", "", "ctx", "Lorg/jetbrains/letsPlot/core/plot/base/PlotContext;", "(Lorg/jetbrains/letsPlot/core/plot/builder/tooltip/spec/TooltipSpecFactory;Lorg/jetbrains/letsPlot/core/plot/base/tooltip/GeomTarget;ZLorg/jetbrains/letsPlot/core/plot/base/PlotContext;)V", "myDataPoints", "", "Lorg/jetbrains/letsPlot/core/plot/base/tooltip/LineSpec$DataPoint;", "myIsCrosshairEnabled", "myTooltipAnchor", "Lorg/jetbrains/letsPlot/core/plot/base/tooltip/TooltipAnchor;", "myTooltipMinWidth", "", "Ljava/lang/Double;", "myTooltipTitle", "", "axisDataPoints", "axisTooltipSpec", "Lorg/jetbrains/letsPlot/core/plot/builder/tooltip/spec/TooltipSpec;", "createHintForAxis", "Lorg/jetbrains/letsPlot/core/plot/base/tooltip/TipLayoutHint;", "aes", "Lorg/jetbrains/letsPlot/core/plot/base/Aes;", "createTooltipSpecs", "createTooltipSpecs$plot_builder", "generalDataPoints", "generalTooltipSpec", "hitIndex", "", "sideDataPoints", "sideHints", "", "sideTooltipSpec", "tipLayoutHint", "plot-builder"})
    @SourceDebugExtension(value={"SMAP\nTooltipSpecFactory.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TooltipSpecFactory.kt\norg/jetbrains/letsPlot/core/plot/builder/tooltip/spec/TooltipSpecFactory$Helper\n+ 2 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,178:1\n215#2:179\n216#2:191\n215#2,2:214\n766#3:180\n857#3,2:181\n1549#3:183\n1620#3,3:184\n1549#3:187\n1620#3,3:188\n766#3:192\n857#3,2:193\n1549#3:195\n1620#3,3:196\n1549#3:199\n1620#3,3:200\n766#3:203\n857#3,2:204\n1549#3:206\n1620#3,3:207\n1549#3:210\n1620#3,3:211\n1549#3:216\n1620#3,3:217\n766#3:220\n857#3,2:221\n766#3:223\n857#3,2:224\n819#3:226\n847#3,2:227\n1603#3,9:229\n1855#3:238\n1856#3:240\n1612#3:241\n1603#3,9:242\n1855#3:251\n1856#3:253\n1612#3:254\n766#3:255\n857#3,2:256\n1#4:239\n1#4:252\n*S KotlinDebug\n*F\n+ 1 TooltipSpecFactory.kt\norg/jetbrains/letsPlot/core/plot/builder/tooltip/spec/TooltipSpecFactory$Helper\n*L\n55#1:179\n55#1:191\n88#1:214,2\n57#1:180\n57#1:181,2\n58#1:183\n58#1:184,3\n59#1:187\n59#1:188,3\n81#1:192\n81#1:193,2\n82#1:195\n82#1:196,3\n83#1:199\n83#1:200,3\n84#1:203\n84#1:204,2\n85#1:206\n85#1:207,3\n86#1:210\n86#1:211,3\n108#1:216\n108#1:217,3\n129#1:220\n129#1:221,2\n130#1:223\n130#1:224,2\n133#1:226\n133#1:227,2\n134#1:229,9\n134#1:238\n134#1:240\n134#1:241\n135#1:242,9\n135#1:251\n135#1:253\n135#1:254\n136#1:255\n136#1:256,2\n134#1:239\n135#1:252\n*E\n"})
    private final class Helper {
        @NotNull
        private final GeomTarget myGeomTarget;
        private final boolean flippedAxis;
        @NotNull
        private final List<LineSpec.DataPoint> myDataPoints;
        @Nullable
        private final TooltipAnchor myTooltipAnchor;
        @Nullable
        private final Double myTooltipMinWidth;
        private final boolean myIsCrosshairEnabled;
        @Nullable
        private final String myTooltipTitle;

        public Helper(GeomTarget myGeomTarget, @NotNull boolean flippedAxis, PlotContext ctx) {
            Intrinsics.checkNotNullParameter((Object)myGeomTarget, (String)"myGeomTarget");
            Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
            this.myGeomTarget = myGeomTarget;
            this.flippedAxis = flippedAxis;
            this.myDataPoints = TooltipSpecFactory.this.contextualMapping.getDataPoints(this.hitIndex(), ctx);
            this.myTooltipAnchor = TooltipSpecFactory.this.contextualMapping.getTooltipAnchor();
            this.myTooltipMinWidth = TooltipSpecFactory.this.contextualMapping.getTooltipMinWidth();
            this.myIsCrosshairEnabled = TooltipSpecFactory.this.contextualMapping.isCrosshairEnabled();
            this.myTooltipTitle = TooltipSpecFactory.this.contextualMapping.getTitle(this.hitIndex(), ctx);
        }

        @NotNull
        public final List<TooltipSpec> createTooltipSpecs$plot_builder() {
            ArrayList tooltipSpecs = new ArrayList();
            CollectionsKt.addAll((Collection)tooltipSpecs, (Iterable)this.axisTooltipSpec());
            CollectionsKt.addAll((Collection)tooltipSpecs, (Iterable)this.sideTooltipSpec());
            CollectionsKt.addAll((Collection)tooltipSpecs, (Iterable)this.generalTooltipSpec());
            return tooltipSpecs;
        }

        private final int hitIndex() {
            return this.myGeomTarget.getHitIndex();
        }

        private final TipLayoutHint tipLayoutHint() {
            return this.myGeomTarget.getTipLayoutHint();
        }

        private final Map<Aes<?>, TipLayoutHint> sideHints() {
            return this.myGeomTarget.getAesTipLayoutHints();
        }

        /*
         * WARNING - void declaration
         */
        private final List<TooltipSpec> sideTooltipSpec() {
            ArrayList<TooltipSpec> tooltipSpecs = new ArrayList<TooltipSpec>();
            List<LineSpec.DataPoint> sideDataPoints = this.sideDataPoints();
            Map<Aes<?>, TipLayoutHint> $this$forEach$iv = this.sideHints();
            boolean $i$f$forEach = false;
            Iterator<Map.Entry<Aes<?>, TipLayoutHint>> iterator = $this$forEach$iv.entrySet().iterator();
            while (iterator.hasNext()) {
                void $this$mapTo$iv$iv;
                Collection collection;
                void $this$mapTo$iv$iv2;
                Iterable $this$map$iv;
                LineSpec.DataPoint it;
                void $this$filterTo$iv$iv;
                Iterable $this$filter$iv;
                Map.Entry<Aes<?>, TipLayoutHint> element$iv;
                Map.Entry<Aes<?>, TipLayoutHint> entry = element$iv = iterator.next();
                boolean bl = false;
                Aes<?> aes = entry.getKey();
                TipLayoutHint hint = entry.getValue();
                Iterable iterable = sideDataPoints;
                boolean $i$f$filter = false;
                void var13_15 = $this$filter$iv;
                Iterable destination$iv$iv = new ArrayList();
                boolean $i$f$filterTo = false;
                for (Object element$iv$iv : $this$filterTo$iv$iv) {
                    it = (LineSpec.DataPoint)element$iv$iv;
                    boolean bl2 = false;
                    if (!Intrinsics.areEqual(aes, (Object)it.getAes())) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                $this$filter$iv = (List)destination$iv$iv;
                boolean $i$f$map = false;
                $this$filterTo$iv$iv = $this$map$iv;
                destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv2) {
                    void p0;
                    it = (LineSpec.DataPoint)item$iv$iv;
                    collection = destination$iv$iv;
                    boolean bl3 = false;
                    collection.add(p0.getValue());
                }
                $this$map$iv = (List)destination$iv$iv;
                TooltipSpec.Line.Companion companion = TooltipSpec.Line.Companion;
                boolean $i$f$map2 = false;
                destination$iv$iv = $this$map$iv;
                Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo2 = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void p0;
                    String bl3 = (String)item$iv$iv;
                    collection = destination$iv$iv2;
                    boolean bl4 = false;
                    collection.add(companion.withValue((String)p0));
                }
                List linesForAes = (List)destination$iv$iv2;
                if (!(!((Collection)linesForAes).isEmpty())) continue;
                Color color = hint.getFillColor();
                if (color == null && (color = this.tipLayoutHint().getFillColor()) == null && (color = (Color)CollectionsKt.firstOrNull((List)this.tipLayoutHint().getMarkerColors())) == null) {
                    color = Color.Companion.getWHITE();
                }
                tooltipSpecs.add(new TooltipSpec(hint, null, linesForAes, color, CollectionsKt.emptyList(), true, null, null, false, 448, null));
            }
            return tooltipSpecs;
        }

        /*
         * WARNING - void declaration
         */
        private final List<TooltipSpec> axisTooltipSpec() {
            Map axis;
            void $this$mapTo$iv$iv;
            void $this$mapTo$iv$iv2;
            void p0;
            void $this$mapTo$iv$iv3;
            Iterable $this$map$iv;
            LineSpec.DataPoint it;
            void $this$filterTo$iv$iv;
            Iterable $this$filter$iv;
            ArrayList<TooltipSpec> tooltipSpecs = new ArrayList<TooltipSpec>();
            Pair[] pairArray = new Pair[2];
            Iterable iterable = this.axisDataPoints();
            Aes aes = Aes.Companion.getX();
            int n = 0;
            Pair[] pairArray2 = pairArray;
            boolean $i$f$filter = false;
            void var6_12 = $this$filter$iv;
            Iterable destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                it = (LineSpec.DataPoint)element$iv$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)Aes.Companion.getX(), (Object)it.getAes())) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            Iterable<TooltipSpec.Line> iterable2 = (List)destination$iv$iv;
            $this$filter$iv = iterable2;
            boolean $i$f$map22 = false;
            $this$filterTo$iv$iv = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv3) {
                it = (LineSpec.DataPoint)item$iv$iv;
                iterable2 = destination$iv$iv;
                boolean bl = false;
                iterable2.add(p0.getValue());
            }
            iterable2 = (List)destination$iv$iv;
            $this$map$iv = iterable2;
            TooltipSpec.Line.Companion $i$f$map22 = TooltipSpec.Line.Companion;
            boolean $i$f$map32 = false;
            destination$iv$iv = $this$map$iv;
            Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo2 = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv2) {
                void p02;
                String bl = (String)item$iv$iv;
                iterable2 = destination$iv$iv2;
                boolean bl2 = false;
                iterable2.add($i$f$map22.withValue((String)p02));
            }
            iterable2 = (List)destination$iv$iv2;
            pairArray2[n] = TuplesKt.to((Object)aes, iterable2);
            $this$map$iv = this.axisDataPoints();
            aes = Aes.Companion.getY();
            n = 1;
            pairArray2 = pairArray;
            $i$f$filter = false;
            Iterable $i$f$map32 = $this$filter$iv;
            destination$iv$iv = new ArrayList();
            $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv2) {
                it = (LineSpec.DataPoint)element$iv$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)Aes.Companion.getY(), (Object)it.getAes())) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            iterable2 = (List)destination$iv$iv;
            $this$filter$iv = iterable2;
            boolean $i$f$map = false;
            Iterable $this$filterTo$iv$iv2 = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                it = (LineSpec.DataPoint)item$iv$iv;
                iterable2 = destination$iv$iv;
                boolean bl = false;
                iterable2.add(p0.getValue());
            }
            iterable2 = (List)destination$iv$iv;
            $this$map$iv = iterable2;
            Object object = TooltipSpec.Line.Companion;
            boolean $i$f$map4 = false;
            destination$iv$iv = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv2) {
                void p03;
                String bl = (String)item$iv$iv;
                iterable2 = destination$iv$iv;
                boolean bl3 = false;
                iterable2.add((TooltipSpec.Line)((TooltipSpec.Line.Companion)object).withValue((String)p03));
            }
            iterable2 = (List)destination$iv$iv;
            pairArray2[n] = TuplesKt.to((Object)aes, iterable2);
            Map $this$forEach$iv = axis = MapsKt.mapOf((Pair[])pairArray);
            boolean $i$f$forEach = false;
            object = $this$forEach$iv.entrySet().iterator();
            while (object.hasNext()) {
                Map.Entry element$iv;
                Map.Entry entry = element$iv = (Map.Entry)object.next();
                boolean bl = false;
                Aes aes2 = (Aes)entry.getKey();
                List lines = (List)entry.getValue();
                if (!(!((Collection)lines).isEmpty())) continue;
                TipLayoutHint layoutHint = this.createHintForAxis(aes2, this.flippedAxis);
                Color color = layoutHint.getFillColor();
                Intrinsics.checkNotNull((Object)color);
                tooltipSpecs.add(new TooltipSpec(layoutHint, null, lines, color, CollectionsKt.emptyList(), true, null, null, false, 448, null));
            }
            return tooltipSpecs;
        }

        /*
         * WARNING - void declaration
         */
        private final List<TooltipSpec> generalTooltipSpec() {
            void $this$mapTo$iv$iv;
            List<LineSpec.DataPoint> generalDataPoints = this.generalDataPoints();
            Iterable $this$map$iv = generalDataPoints;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                LineSpec.DataPoint dataPoint = (LineSpec.DataPoint)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(TooltipSpec.Line.Companion.withLabelAndValue(it.getLabel(), it.getValue()));
            }
            List generalLines = (List)destination$iv$iv;
            return !((Collection)generalLines).isEmpty() ? CollectionsKt.listOf((Object)new TooltipSpec(this.tipLayoutHint(), this.myTooltipTitle, generalLines, null, this.tipLayoutHint().getMarkerColors(), false, this.myTooltipAnchor, this.myTooltipMinWidth, this.myIsCrosshairEnabled)) : CollectionsKt.emptyList();
        }

        /*
         * WARNING - void declaration
         */
        private final List<LineSpec.DataPoint> sideDataPoints() {
            void $this$filterTo$iv$iv;
            Iterable $this$filter$iv = this.myDataPoints;
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                LineSpec.DataPoint it = (LineSpec.DataPoint)element$iv$iv;
                boolean bl = false;
                if (!(it.isSide() && !it.isAxis())) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            return (List)destination$iv$iv;
        }

        /*
         * WARNING - void declaration
         */
        private final List<LineSpec.DataPoint> axisDataPoints() {
            void $this$filterTo$iv$iv;
            Iterable $this$filter$iv = this.myDataPoints;
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                LineSpec.DataPoint p0 = (LineSpec.DataPoint)element$iv$iv;
                boolean bl = false;
                if (!p0.isAxis()) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            return (List)destination$iv$iv;
        }

        /*
         * WARNING - void declaration
         */
        private final List<LineSpec.DataPoint> generalDataPoints() {
            void $this$filterTo$iv$iv;
            Iterable $this$mapNotNullTo$iv$iv;
            Object element$iv$iv$iv2;
            void $this$mapNotNullTo$iv$iv2;
            void $this$filterNotTo$iv$iv;
            Iterable $this$filterNot$iv = this.myDataPoints;
            boolean $i$f$filterNot = false;
            Iterable iterable = $this$filterNot$iv;
            Iterable destination$iv$iv = new ArrayList();
            boolean $i$f$filterNotTo = false;
            for (Object element$iv$iv : $this$filterNotTo$iv$iv) {
                LineSpec.DataPoint p0 = (LineSpec.DataPoint)element$iv$iv;
                boolean bl = false;
                if (p0.isSide()) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List nonSideDataPoints = (List)destination$iv$iv;
            Iterable $this$mapNotNull$iv = this.sideDataPoints();
            boolean $i$f$mapNotNull = false;
            destination$iv$iv = $this$mapNotNull$iv;
            Iterable<Aes> destination$iv$iv2 = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv2;
            boolean $i$f$forEach = false;
            for (Object element$iv$iv$iv2 : $this$forEach$iv$iv$iv) {
                Aes it$iv$iv;
                Object element$iv$iv = element$iv$iv$iv2;
                boolean bl = false;
                LineSpec.DataPoint p0 = (LineSpec.DataPoint)element$iv$iv;
                boolean bl2 = false;
                if (p0.getAes() == null) continue;
                boolean bl3 = false;
                destination$iv$iv2.add(it$iv$iv);
            }
            List sideDataPoints = (List)destination$iv$iv2;
            Iterable $this$mapNotNull$iv2 = nonSideDataPoints;
            boolean $i$f$mapNotNull2 = false;
            destination$iv$iv2 = $this$mapNotNull$iv2;
            Collection destination$iv$iv3 = new ArrayList();
            boolean $i$f$mapNotNullTo2 = false;
            void $this$forEach$iv$iv$iv2 = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach2 = false;
            element$iv$iv$iv2 = $this$forEach$iv$iv$iv2.iterator();
            while (element$iv$iv$iv2.hasNext()) {
                Aes it$iv$iv;
                Object element$iv$iv$iv3;
                Object element$iv$iv = element$iv$iv$iv3 = element$iv$iv$iv2.next();
                boolean bl = false;
                LineSpec.DataPoint p0 = (LineSpec.DataPoint)element$iv$iv;
                boolean bl4 = false;
                if (p0.getAes() == null) continue;
                boolean bl5 = false;
                destination$iv$iv3.add(it$iv$iv);
            }
            List generalAesList = CollectionsKt.minus((Iterable)((List)destination$iv$iv3), (Iterable)sideDataPoints);
            Iterable $this$filter$iv = nonSideDataPoints;
            boolean $i$f$filter = false;
            $this$mapNotNullTo$iv$iv = $this$filter$iv;
            destination$iv$iv3 = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                LineSpec.DataPoint dataPoint = (LineSpec.DataPoint)element$iv$iv;
                boolean bl = false;
                Aes aes = dataPoint.getAes();
                boolean bl6 = aes == null ? true : CollectionsKt.contains((Iterable)generalAesList, (Object)aes);
                if (!bl6) continue;
                destination$iv$iv3.add(element$iv$iv);
            }
            return (List)destination$iv$iv3;
        }

        private final TipLayoutHint createHintForAxis(Aes<?> aes, boolean flippedAxis) {
            TipLayoutHint tipLayoutHint;
            Aes it = aes;
            boolean bl = false;
            Aes aes2 = flippedAxis && Intrinsics.areEqual(it, (Object)Aes.Companion.getX()) ? Aes.Companion.getY() : (flippedAxis && Intrinsics.areEqual(it, (Object)Aes.Companion.getY()) ? Aes.Companion.getX() : it);
            Aes axis = aes2;
            Aes aes3 = axis;
            if (Intrinsics.areEqual((Object)aes3, (Object)Aes.Companion.getX())) {
                DoubleVector doubleVector = this.tipLayoutHint().getCoord();
                Intrinsics.checkNotNull((Object)doubleVector);
                tipLayoutHint = TipLayoutHint.Companion.xAxisTooltip$default((TipLayoutHint.Companion)TipLayoutHint.Companion, (DoubleVector)new DoubleVector(doubleVector.getX(), TooltipSpecFactory.this.axisOrigin.getY()), (double)1.5, null, (Color)TooltipSpecFactory.this.xAxisTheme.tooltipFill(), (int)4, null);
            } else if (Intrinsics.areEqual((Object)aes3, (Object)Aes.Companion.getY())) {
                double d = TooltipSpecFactory.this.axisOrigin.getX();
                DoubleVector doubleVector = this.tipLayoutHint().getCoord();
                Intrinsics.checkNotNull((Object)doubleVector);
                tipLayoutHint = TipLayoutHint.Companion.yAxisTooltip$default((TipLayoutHint.Companion)TipLayoutHint.Companion, (DoubleVector)new DoubleVector(d, doubleVector.getY()), (double)1.5, null, (Color)TooltipSpecFactory.this.yAxisTheme.tooltipFill(), (int)4, null);
            } else {
                throw new IllegalStateException(("Not an axis aes: " + axis).toString());
            }
            return tipLayoutHint;
        }
    }
}

