/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.measure;

import java.lang.reflect.Proxy;
import javax.measure.Quantity;
import javax.measure.UnconvertibleException;
import javax.measure.Unit;
import javax.measure.UnitConverter;
import org.apache.sis.measure.AbstractUnit;
import org.apache.sis.measure.DerivedScalar;
import org.apache.sis.measure.Quantities;
import org.apache.sis.measure.ScalarFactory;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.StringBuilders;
import org.apache.sis.util.internal.Numerics;
import org.apache.sis.util.logging.Logging;

class Scalar<Q extends Quantity<Q>>
extends Number
implements Quantity<Q>,
Comparable<Q> {
    private static final long serialVersionUID = -381805117700594712L;
    static final Quantity.Scale SCALE = Quantity.Scale.ABSOLUTE;
    private final double value;
    private final Unit<Q> unit;

    Scalar(double value, Unit<Q> unit) {
        this.value = value;
        this.unit = unit;
    }

    Quantity<Q> create(double newValue, Unit<Q> newUnit) {
        return new Scalar<Q>(newValue, newUnit);
    }

    private Quantity<?> of(double newValue, Unit<?> newUnit) {
        if (this.unit != newUnit || Double.doubleToRawLongBits(this.value) != Double.doubleToRawLongBits(newValue)) {
            return Quantities.create(newValue, newUnit);
        }
        return this;
    }

    private Quantity<Q> of(double newValue) {
        if (Double.doubleToRawLongBits(this.value) != Double.doubleToRawLongBits(newValue)) {
            return this.create(newValue, this.unit);
        }
        return this;
    }

    @Override
    public final Quantity.Scale getScale() {
        return SCALE;
    }

    @Override
    public Unit<Q> getUnit() {
        return this.unit;
    }

    @Override
    public final Number getValue() {
        return this;
    }

    @Override
    public double doubleValue() {
        return this.value;
    }

    @Override
    public float floatValue() {
        return (float)this.value;
    }

    @Override
    public long longValue() {
        return Math.round(this.value);
    }

    @Override
    public final int intValue() {
        return Numerics.clamp(this.longValue());
    }

    @Override
    public final short shortValue() {
        return (short)Math.max(-32768L, Math.min(32767L, this.longValue()));
    }

    @Override
    public final byte byteValue() {
        return (byte)Math.max(-128L, Math.min(127L, this.longValue()));
    }

    private double doubleValue(Quantity<Q> other) {
        double otherValue = other.getValue().doubleValue();
        Unit<Q> otherUnit = other.getUnit();
        if (otherUnit != this.unit) {
            otherValue = otherUnit.getConverterTo(this.unit).convert(otherValue);
        }
        return otherValue;
    }

    @Override
    public final int compareTo(Q other) {
        return Double.compare(this.value, this.doubleValue((Quantity<Q>)other));
    }

    @Override
    public Quantity<Q> to(Unit<Q> newUnit) {
        if (newUnit == this.unit) {
            return this;
        }
        ArgumentChecks.ensureNonNull("unit", newUnit);
        assert (this.unit.getConverterTo(this.unit.getSystemUnit()).isLinear()) : this.unit;
        UnitConverter c = this.unit.getConverterTo(newUnit);
        double newValue = c.convert(this.value);
        if (c.isLinear()) {
            return this.create(newValue, newUnit);
        }
        return Quantities.create(newValue, newUnit);
    }

    @Override
    public final Quantity<Q> add(Quantity<Q> other) {
        return this.of(this.value + this.doubleValue(other));
    }

    @Override
    public final Quantity<Q> subtract(Quantity<Q> other) {
        return this.of(this.value - this.doubleValue(other));
    }

    @Override
    public final Quantity<Q> multiply(Number scale) {
        return this.of(this.value * scale.doubleValue());
    }

    @Override
    public final Quantity<Q> divide(Number divisor) {
        return this.of(this.value / divisor.doubleValue());
    }

    @Override
    public final Quantity<?> multiply(Quantity<?> other) {
        return this.of(this.value * other.getValue().doubleValue(), this.unit.multiply(other.getUnit()));
    }

    @Override
    public final Quantity<?> divide(Quantity<?> other) {
        return this.of(this.value / other.getValue().doubleValue(), this.unit.divide(other.getUnit()));
    }

    @Override
    public final Quantity<?> inverse() {
        return this.of(1.0 / this.value, this.unit.inverse());
    }

    @Override
    public final Quantity<Q> negate() {
        return this.of(-this.value);
    }

    @Override
    public final <T extends Quantity<T>> Quantity<T> asType(Class<T> type) throws ClassCastException {
        return (Quantity)type.cast(this);
    }

    @Override
    public final boolean isEquivalentTo(Quantity<Q> that) {
        Unit<Q> otherUnit = that.getUnit();
        try {
            Number r = otherUnit.getConverterTo(this.unit).convert(that.getValue());
            if (r instanceof Float) {
                return Math.abs(this.value - r.doubleValue()) < (double)Math.ulp(r.floatValue());
            }
            return this.value == r.doubleValue();
        }
        catch (UnconvertibleException e2) {
            Logging.ignorableException(AbstractUnit.LOGGER, Scalar.class, "isEquivalentTo", e2);
            return false;
        }
    }

    public final boolean equals(Object other) {
        if (!(other instanceof Scalar)) {
            if (!(other instanceof Proxy)) {
                return false;
            }
            try {
                other = Proxy.getInvocationHandler(other);
            }
            catch (IllegalArgumentException | SecurityException e2) {
                return false;
            }
            if (!(other instanceof Scalar)) {
                return false;
            }
        }
        Scalar that = (Scalar)other;
        return Double.doubleToLongBits(this.doubleValue()) == Double.doubleToLongBits(that.doubleValue()) && this.getUnit().equals(that.getUnit());
    }

    public final int hashCode() {
        return Double.hashCode(this.doubleValue()) ^ this.getUnit().hashCode();
    }

    public final String toString() {
        StringBuilder buffer = new StringBuilder().append(this.doubleValue());
        StringBuilders.trimFractionalPart(buffer);
        String symbol = this.getUnit().toString();
        if (symbol != null && !symbol.isEmpty()) {
            buffer.append('\u202f').append(symbol);
        }
        return buffer.toString();
    }

    static final class Temperature
    extends Scalar<javax.measure.quantity.Temperature>
    implements javax.measure.quantity.Temperature {
        static final ScalarFactory<javax.measure.quantity.Temperature> FACTORY = new ScalarFactory<javax.measure.quantity.Temperature>(){

            @Override
            public javax.measure.quantity.Temperature create(double value, Unit<javax.measure.quantity.Temperature> unit) {
                return new Temperature(value, unit);
            }

            @Override
            public javax.measure.quantity.Temperature createDerived(double value, Unit<javax.measure.quantity.Temperature> unit, Unit<javax.measure.quantity.Temperature> systemUnit, UnitConverter toSystem) {
                return new DerivedScalar.TemperatureMeasurement(value, unit, systemUnit, toSystem);
            }
        };
        private static final long serialVersionUID = -6391507887931973739L;

        Temperature(double value, Unit<javax.measure.quantity.Temperature> unit) {
            super(value, unit);
        }

        @Override
        Quantity<javax.measure.quantity.Temperature> create(double value, Unit<javax.measure.quantity.Temperature> unit) {
            return new Temperature(value, unit);
        }
    }

    static final class Pressure
    extends Scalar<javax.measure.quantity.Pressure>
    implements javax.measure.quantity.Pressure {
        private static final long serialVersionUID = -8647834252032382587L;

        Pressure(double value, Unit<javax.measure.quantity.Pressure> unit) {
            super(value, unit);
        }

        @Override
        Quantity<javax.measure.quantity.Pressure> create(double value, Unit<javax.measure.quantity.Pressure> unit) {
            return new Pressure(value, unit);
        }
    }

    static final class Power
    extends Scalar<javax.measure.quantity.Power>
    implements javax.measure.quantity.Power {
        private static final long serialVersionUID = -5751533351918725110L;

        Power(double value, Unit<javax.measure.quantity.Power> unit) {
            super(value, unit);
        }

        @Override
        Quantity<javax.measure.quantity.Power> create(double value, Unit<javax.measure.quantity.Power> unit) {
            return new Power(value, unit);
        }
    }

    static final class Energy
    extends Scalar<javax.measure.quantity.Energy>
    implements javax.measure.quantity.Energy {
        private static final long serialVersionUID = 857370990868536857L;

        Energy(double value, Unit<javax.measure.quantity.Energy> unit) {
            super(value, unit);
        }

        @Override
        Quantity<javax.measure.quantity.Energy> create(double value, Unit<javax.measure.quantity.Energy> unit) {
            return new Energy(value, unit);
        }
    }

    static final class Force
    extends Scalar<javax.measure.quantity.Force>
    implements javax.measure.quantity.Force {
        private static final long serialVersionUID = -4988289861436247522L;

        Force(double value, Unit<javax.measure.quantity.Force> unit) {
            super(value, unit);
        }

        @Override
        Quantity<javax.measure.quantity.Force> create(double value, Unit<javax.measure.quantity.Force> unit) {
            return new Force(value, unit);
        }
    }

    static final class Mass
    extends Scalar<javax.measure.quantity.Mass>
    implements javax.measure.quantity.Mass {
        private static final long serialVersionUID = -3348515590324141647L;

        Mass(double value, Unit<javax.measure.quantity.Mass> unit) {
            super(value, unit);
        }

        @Override
        Quantity<javax.measure.quantity.Mass> create(double value, Unit<javax.measure.quantity.Mass> unit) {
            return new Mass(value, unit);
        }
    }

    static final class Acceleration
    extends Scalar<javax.measure.quantity.Acceleration>
    implements javax.measure.quantity.Acceleration {
        private static final long serialVersionUID = 8041442665100572880L;

        Acceleration(double value, Unit<javax.measure.quantity.Acceleration> unit) {
            super(value, unit);
        }

        @Override
        Quantity<javax.measure.quantity.Acceleration> create(double value, Unit<javax.measure.quantity.Acceleration> unit) {
            return new Acceleration(value, unit);
        }
    }

    static final class Speed
    extends Scalar<javax.measure.quantity.Speed>
    implements javax.measure.quantity.Speed {
        private static final long serialVersionUID = 4086187563299428546L;

        Speed(double value, Unit<javax.measure.quantity.Speed> unit) {
            super(value, unit);
        }

        @Override
        Quantity<javax.measure.quantity.Speed> create(double value, Unit<javax.measure.quantity.Speed> unit) {
            return new Speed(value, unit);
        }
    }

    static final class Frequency
    extends Scalar<javax.measure.quantity.Frequency>
    implements javax.measure.quantity.Frequency {
        private static final long serialVersionUID = -2038564695278895642L;

        Frequency(double value, Unit<javax.measure.quantity.Frequency> unit) {
            super(value, unit);
        }

        @Override
        Quantity<javax.measure.quantity.Frequency> create(double value, Unit<javax.measure.quantity.Frequency> unit) {
            return new Frequency(value, unit);
        }
    }

    static final class Time
    extends Scalar<javax.measure.quantity.Time>
    implements javax.measure.quantity.Time {
        private static final long serialVersionUID = 3992130757485565027L;

        Time(double value, Unit<javax.measure.quantity.Time> unit) {
            super(value, unit);
        }

        @Override
        Quantity<javax.measure.quantity.Time> create(double value, Unit<javax.measure.quantity.Time> unit) {
            return new Time(value, unit);
        }
    }

    static final class Volume
    extends Scalar<javax.measure.quantity.Volume>
    implements javax.measure.quantity.Volume {
        private static final long serialVersionUID = -1505528008598251420L;

        Volume(double value, Unit<javax.measure.quantity.Volume> unit) {
            super(value, unit);
        }

        @Override
        Quantity<javax.measure.quantity.Volume> create(double value, Unit<javax.measure.quantity.Volume> unit) {
            return new Volume(value, unit);
        }
    }

    static final class Area
    extends Scalar<javax.measure.quantity.Area>
    implements javax.measure.quantity.Area {
        private static final long serialVersionUID = -9127932093170175175L;

        Area(double value, Unit<javax.measure.quantity.Area> unit) {
            super(value, unit);
        }

        @Override
        Quantity<javax.measure.quantity.Area> create(double value, Unit<javax.measure.quantity.Area> unit) {
            return new Area(value, unit);
        }
    }

    static final class Length
    extends Scalar<javax.measure.quantity.Length>
    implements javax.measure.quantity.Length {
        private static final long serialVersionUID = 6664029554501181657L;

        Length(double value, Unit<javax.measure.quantity.Length> unit) {
            super(value, unit);
        }

        @Override
        Quantity<javax.measure.quantity.Length> create(double value, Unit<javax.measure.quantity.Length> unit) {
            return new Length(value, unit);
        }
    }

    static final class Angle
    extends Scalar<javax.measure.quantity.Angle>
    implements javax.measure.quantity.Angle {
        private static final long serialVersionUID = -1706116845342397826L;

        Angle(double value, Unit<javax.measure.quantity.Angle> unit) {
            super(value, unit);
        }

        @Override
        Quantity<javax.measure.quantity.Angle> create(double value, Unit<javax.measure.quantity.Angle> unit) {
            return new Angle(value, unit);
        }
    }

    static final class Dimensionless
    extends Scalar<javax.measure.quantity.Dimensionless>
    implements javax.measure.quantity.Dimensionless {
        private static final long serialVersionUID = -7783945219314403648L;

        Dimensionless(double value, Unit<javax.measure.quantity.Dimensionless> unit) {
            super(value, unit);
        }

        @Override
        Quantity<javax.measure.quantity.Dimensionless> create(double value, Unit<javax.measure.quantity.Dimensionless> unit) {
            return new Dimensionless(value, unit);
        }
    }
}

