/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.queries.intervals;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.lucene.queries.intervals.ConjunctionIntervalIterator;
import org.apache.lucene.queries.intervals.Disjunctions;
import org.apache.lucene.queries.intervals.IntervalIterator;
import org.apache.lucene.queries.intervals.IntervalsSource;
import org.apache.lucene.queries.intervals.MinimizingConjunctionIntervalsSource;
import org.apache.lucene.queries.intervals.RepeatingIntervalsSource;

class OrderedIntervalsSource
extends MinimizingConjunctionIntervalsSource {
    static IntervalsSource build(List<IntervalsSource> sources) {
        if (sources.size() == 1) {
            return sources.get(0);
        }
        List<IntervalsSource> rewritten = OrderedIntervalsSource.deduplicate(OrderedIntervalsSource.flatten(sources));
        if (rewritten.size() == 1) {
            return rewritten.get(0);
        }
        return new OrderedIntervalsSource(rewritten);
    }

    private static List<IntervalsSource> flatten(List<IntervalsSource> sources) {
        ArrayList<IntervalsSource> flattened = new ArrayList<IntervalsSource>();
        for (IntervalsSource s : sources) {
            if (s instanceof OrderedIntervalsSource) {
                flattened.addAll(((OrderedIntervalsSource)s).subSources);
                continue;
            }
            flattened.add(s);
        }
        return flattened;
    }

    private static List<IntervalsSource> deduplicate(List<IntervalsSource> sources) {
        ArrayList<IntervalsSource> deduplicated = new ArrayList<IntervalsSource>();
        ArrayList<IntervalsSource> current = new ArrayList<IntervalsSource>();
        for (IntervalsSource source : sources) {
            if (current.size() == 0 || ((IntervalsSource)current.get(0)).equals(source)) {
                current.add(source);
                continue;
            }
            deduplicated.add(RepeatingIntervalsSource.build((IntervalsSource)current.get(0), current.size()));
            current.clear();
            current.add(source);
        }
        deduplicated.add(RepeatingIntervalsSource.build((IntervalsSource)current.get(0), current.size()));
        if (deduplicated.size() == 1 && deduplicated.get(0) instanceof RepeatingIntervalsSource) {
            ((RepeatingIntervalsSource)deduplicated.get(0)).setName("ORDERED");
        }
        return deduplicated;
    }

    private OrderedIntervalsSource(List<IntervalsSource> sources) {
        super(sources);
    }

    @Override
    protected IntervalIterator combine(List<IntervalIterator> iterators, MinimizingConjunctionIntervalsSource.MatchCallback onMatch) {
        return new OrderedIntervalIterator(iterators, onMatch);
    }

    @Override
    public int minExtent() {
        int minExtent = 0;
        for (IntervalsSource subSource : this.subSources) {
            minExtent += subSource.minExtent();
        }
        return minExtent;
    }

    @Override
    public Collection<IntervalsSource> pullUpDisjunctions() {
        return Disjunctions.pullUp(this.subSources, OrderedIntervalsSource::new);
    }

    @Override
    public int hashCode() {
        return Objects.hashCode(this.subSources);
    }

    @Override
    public boolean equals(Object other) {
        if (!(other instanceof OrderedIntervalsSource)) {
            return false;
        }
        OrderedIntervalsSource s = (OrderedIntervalsSource)other;
        return Objects.equals(this.subSources, s.subSources);
    }

    @Override
    public String toString() {
        return "ORDERED(" + this.subSources.stream().map(IntervalsSource::toString).collect(Collectors.joining(",")) + ")";
    }

    private static class OrderedIntervalIterator
    extends ConjunctionIntervalIterator {
        int start = -1;
        int end = -1;
        int i = 1;
        int slop;
        final MinimizingConjunctionIntervalsSource.MatchCallback onMatch;

        private OrderedIntervalIterator(List<IntervalIterator> subIntervals, MinimizingConjunctionIntervalsSource.MatchCallback onMatch) {
            super(subIntervals);
            this.onMatch = onMatch;
        }

        @Override
        public int start() {
            return this.start;
        }

        @Override
        public int end() {
            return this.end;
        }

        @Override
        public int nextInterval() throws IOException {
            this.slop = Integer.MAX_VALUE;
            this.end = Integer.MAX_VALUE;
            this.start = Integer.MAX_VALUE;
            int lastStart = Integer.MAX_VALUE;
            boolean minimizing = false;
            while (((IntervalIterator)this.subIterators.get(this.i - 1)).end() < lastStart) {
                if (!(this.i == this.subIterators.size() || minimizing && ((IntervalIterator)this.subIterators.get(this.i)).start() > ((IntervalIterator)this.subIterators.get(this.i - 1)).end())) {
                    do {
                        if (((IntervalIterator)this.subIterators.get(this.i)).end() < lastStart && ((IntervalIterator)this.subIterators.get(this.i)).nextInterval() != Integer.MAX_VALUE) continue;
                        return this.start;
                    } while (((IntervalIterator)this.subIterators.get(this.i)).start() <= ((IntervalIterator)this.subIterators.get(this.i - 1)).end());
                    ++this.i;
                    continue;
                }
                this.start = ((IntervalIterator)this.subIterators.get(0)).start();
                if (this.start == Integer.MAX_VALUE) {
                    this.end = Integer.MAX_VALUE;
                    return Integer.MAX_VALUE;
                }
                this.end = ((IntervalIterator)this.subIterators.get(this.subIterators.size() - 1)).end();
                this.slop = this.end - this.start + 1;
                for (IntervalIterator subIterator : this.subIterators) {
                    this.slop -= subIterator.width();
                }
                this.onMatch.onMatch();
                lastStart = ((IntervalIterator)this.subIterators.get(this.subIterators.size() - 1)).start();
                this.i = 1;
                if (((IntervalIterator)this.subIterators.get(0)).nextInterval() == Integer.MAX_VALUE) {
                    return this.start;
                }
                minimizing = true;
            }
            return this.start;
        }

        @Override
        public int gaps() {
            return this.slop;
        }

        @Override
        protected void reset() throws IOException {
            ((IntervalIterator)this.subIterators.get(0)).nextInterval();
            this.i = 1;
            this.slop = -1;
            this.end = -1;
            this.start = -1;
        }
    }
}

