/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.shacl.parser;

import java.io.BufferedOutputStream;
import java.io.OutputStream;
import java.util.Collection;
import org.apache.jena.atlas.io.AWriter;
import org.apache.jena.atlas.io.IndentedWriter;
import org.apache.jena.graph.Graph;
import org.apache.jena.graph.Node;
import org.apache.jena.riot.out.NodeFormatter;
import org.apache.jena.shacl.engine.Target;
import org.apache.jena.shacl.engine.TargetOps;
import org.apache.jena.shacl.parser.Constraint;
import org.apache.jena.shacl.parser.PropertyShape;
import org.apache.jena.shacl.parser.ShapeVisitor;
import org.apache.jena.shacl.validation.Severity;
import org.apache.jena.system.G;

public abstract class Shape {
    protected final Graph shapeGraph;
    protected final Node shapeNode;
    protected final boolean deactivated;
    protected final Severity severity;
    protected final Collection<Node> messages;
    protected final Collection<Target> targets;
    protected final Collection<Constraint> constraints;
    protected final Collection<PropertyShape> propertyShapes;

    protected Shape(Graph shapeGraph, Node shapeNode, boolean deactivated, Severity severity, Collection<Node> messages, Collection<Target> targets, Collection<Constraint> constraints, Collection<PropertyShape> propertyShapes) {
        this.shapeGraph = shapeGraph;
        this.shapeNode = shapeNode;
        this.deactivated = deactivated;
        this.severity = severity;
        this.messages = messages;
        this.targets = targets;
        this.constraints = constraints;
        this.propertyShapes = propertyShapes;
    }

    public abstract void visit(ShapeVisitor var1);

    public Graph getShapeGraph() {
        return this.shapeGraph;
    }

    public Node getShapeNode() {
        return this.shapeNode;
    }

    public Severity getSeverity() {
        return this.severity;
    }

    public Collection<Node> getMessages() {
        return this.messages;
    }

    public Collection<Target> getTargets() {
        return this.targets;
    }

    public boolean hasTarget() {
        return !this.targets.isEmpty();
    }

    public Collection<Constraint> getConstraints() {
        return this.constraints;
    }

    public Collection<PropertyShape> getPropertyShapes() {
        return this.propertyShapes;
    }

    public boolean deactivated() {
        return this.deactivated;
    }

    public boolean isNodeShape() {
        return false;
    }

    public boolean isPropertyShape() {
        return false;
    }

    public abstract String toString();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void print(OutputStream out, NodeFormatter nodeFmt) {
        if (!(out instanceof BufferedOutputStream)) {
            out = new BufferedOutputStream(out, 131072);
        }
        IndentedWriter w = new IndentedWriter(out);
        try {
            this.print(w, nodeFmt);
        }
        finally {
            w.flush();
        }
    }

    protected abstract void printHeader(IndentedWriter var1, NodeFormatter var2);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void print(IndentedWriter out, NodeFormatter nodeFmt) {
        this.printHeader(out, nodeFmt);
        boolean printNode = false;
        if (!this.shapeNode.isBlank()) {
            printNode = true;
        } else {
            long z = G.objectConnectiveness((Graph)this.shapeGraph, (Node)this.shapeNode);
            boolean isOneConnected = G.oneConnected((Graph)this.shapeGraph, (Node)this.shapeNode);
            if (!isOneConnected) {
                printNode = true;
            }
        }
        if (printNode) {
            out.print(" ");
            out.print("node=");
            nodeFmt.format((AWriter)out, this.shapeNode);
        }
        if (this.deactivated()) {
            out.print(" deactivated");
        }
        out.println();
        try {
            out.incIndent();
            this.targets.forEach(target -> out.println(TargetOps.strTarget(target, nodeFmt)));
            for (Constraint c : this.constraints) {
                c.print(out, nodeFmt);
                if (out.atLineStart()) continue;
                out.println();
            }
            for (PropertyShape ps : this.getPropertyShapes()) {
                ps.print(out, nodeFmt);
            }
        }
        finally {
            out.decIndent();
        }
        out.flush();
    }
}

