/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.dboe.base.block;

import org.apache.jena.dboe.base.block.Block;
import org.apache.jena.dboe.base.block.BlockException;
import org.apache.jena.dboe.base.block.BlockMgr;
import org.slf4j.Logger;

public abstract class BlockMgrBase
implements BlockMgr {
    protected final int blockSize;
    private String label;

    protected abstract Logger log();

    protected BlockMgrBase(String label, int blockSize) {
        this.label = label;
        this.blockSize = blockSize;
    }

    @Override
    public final Block allocate(int blkSize) {
        if (blkSize > 0 && blkSize != this.blockSize) {
            throw new BlockException("Fixed blocksize BlockMgr: request= " + blkSize + "  fixed size=" + this.blockSize);
        }
        return this.allocate();
    }

    protected abstract Block allocate();

    @Override
    public final String getLabel() {
        return this.label;
    }

    @Override
    public void endUpdate() {
    }

    @Override
    public void beginUpdate() {
    }

    @Override
    public void beginRead() {
    }

    @Override
    public void endRead() {
    }
}

