/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox;

import java.util.Objects;
import org.apache.james.mailbox.model.MailboxId;
import org.apache.james.mailbox.model.MessageId;
import org.apache.james.mailbox.model.MessageMetaData;

public class MetadataWithMailboxId {
    private final MessageId messageId;
    private final long size;
    private final MailboxId mailboxId;

    public static MetadataWithMailboxId from(MessageMetaData messageMetaData, MailboxId mailboxId) {
        return new MetadataWithMailboxId(messageMetaData.getMessageId(), messageMetaData.getSize(), mailboxId);
    }

    public MetadataWithMailboxId(MessageId messageId, long size, MailboxId mailboxId) {
        this.messageId = messageId;
        this.size = size;
        this.mailboxId = mailboxId;
    }

    public MessageId getMessageId() {
        return this.messageId;
    }

    public long getSize() {
        return this.size;
    }

    public MailboxId getMailboxId() {
        return this.mailboxId;
    }

    public final boolean equals(Object o) {
        if (o instanceof MetadataWithMailboxId) {
            MetadataWithMailboxId that = (MetadataWithMailboxId)o;
            return Objects.equals(this.messageId, that.messageId) && Objects.equals(this.size, that.size) && Objects.equals(this.mailboxId, that.mailboxId);
        }
        return false;
    }

    public final int hashCode() {
        return Objects.hash(this.messageId, this.size, this.mailboxId);
    }
}

