/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.vault.metadata;

import org.apache.james.backends.postgres.PostgresDataDefinition;
import org.apache.james.backends.postgres.PostgresIndex;
import org.apache.james.backends.postgres.PostgresTable;
import org.jooq.DataType;
import org.jooq.Field;
import org.jooq.JSONB;
import org.jooq.OrderField;
import org.jooq.Record;
import org.jooq.Table;
import org.jooq.impl.DSL;
import org.jooq.impl.SQLDataType;

public interface PostgresDeletedMessageMetadataDataDefinition {
    public static final PostgresDataDefinition MODULE = PostgresDataDefinition.builder().addTable(new PostgresTable[]{DeletedMessageMetadataTable.TABLE}).addIndex(new PostgresIndex[]{DeletedMessageMetadataTable.OWNER_MESSAGE_ID_INDEX}).build();

    public static interface DeletedMessageMetadataTable {
        public static final Table<Record> TABLE_NAME = DSL.table((String)"deleted_messages_metadata");
        public static final Field<String> BUCKET_NAME = DSL.field((String)"bucket_name", (DataType)SQLDataType.VARCHAR.notNull());
        public static final Field<String> OWNER = DSL.field((String)"owner", (DataType)SQLDataType.VARCHAR.notNull());
        public static final Field<String> MESSAGE_ID = DSL.field((String)"messageId", (DataType)SQLDataType.VARCHAR.notNull());
        public static final Field<String> BLOB_ID = DSL.field((String)"blob_id", (DataType)SQLDataType.VARCHAR.notNull());
        public static final Field<JSONB> METADATA = DSL.field((String)"metadata", (DataType)SQLDataType.JSONB.notNull());
        public static final PostgresTable TABLE = PostgresTable.name((String)TABLE_NAME.getName()).createTableStep((dsl, tableName) -> dsl.createTableIfNotExists(tableName).column(BUCKET_NAME).column(OWNER).column(MESSAGE_ID).column(BLOB_ID).column(METADATA).primaryKey(new Field[]{BUCKET_NAME, OWNER, MESSAGE_ID})).disableRowLevelSecurity().build();
        public static final PostgresIndex OWNER_MESSAGE_ID_INDEX = PostgresIndex.name((String)"owner_messageId_index").createIndexStep((dsl, indexName) -> dsl.createUniqueIndexIfNotExists(indexName).on(TABLE_NAME, new OrderField[]{OWNER, MESSAGE_ID}));
    }
}

