/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.jpa.quota;

import com.github.fge.lambdas.Throwing;
import com.github.fge.lambdas.functions.FunctionChainer;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Stream;
import javax.inject.Inject;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.james.backends.jpa.EntityManagerUtils;
import org.apache.james.core.Domain;
import org.apache.james.core.quota.QuotaCountLimit;
import org.apache.james.core.quota.QuotaSizeLimit;
import org.apache.james.mailbox.jpa.quota.JPAPerUserMaxQuotaDAO;
import org.apache.james.mailbox.model.Quota;
import org.apache.james.mailbox.model.QuotaRoot;
import org.apache.james.mailbox.quota.MaxQuotaManager;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Mono;
import reactor.core.scheduler.Schedulers;

public class JPAPerUserMaxQuotaManager
implements MaxQuotaManager {
    private final EntityManagerFactory entityManagerFactory;
    private final JPAPerUserMaxQuotaDAO dao;

    @Inject
    public JPAPerUserMaxQuotaManager(EntityManagerFactory entityManagerFactory, JPAPerUserMaxQuotaDAO dao) {
        this.entityManagerFactory = entityManagerFactory;
        this.dao = dao;
    }

    public void setMaxStorage(QuotaRoot quotaRoot, QuotaSizeLimit maxStorageQuota) {
        this.dao.setMaxStorage(quotaRoot, Optional.of(maxStorageQuota));
    }

    public Publisher<Void> setMaxStorageReactive(QuotaRoot quotaRoot, QuotaSizeLimit maxStorageQuota) {
        return Mono.fromRunnable(() -> this.setMaxStorage(quotaRoot, maxStorageQuota));
    }

    public void setMaxMessage(QuotaRoot quotaRoot, QuotaCountLimit maxMessageCount) {
        this.dao.setMaxMessage(quotaRoot, Optional.of(maxMessageCount));
    }

    public Publisher<Void> setMaxMessageReactive(QuotaRoot quotaRoot, QuotaCountLimit maxMessageCount) {
        return Mono.fromRunnable(() -> this.setMaxMessage(quotaRoot, maxMessageCount));
    }

    public void setDomainMaxMessage(Domain domain, QuotaCountLimit count) {
        this.dao.setDomainMaxMessage(domain, Optional.of(count));
    }

    public Publisher<Void> setDomainMaxMessageReactive(Domain domain, QuotaCountLimit count) {
        return Mono.fromRunnable(() -> this.setDomainMaxMessage(domain, count));
    }

    public void setDomainMaxStorage(Domain domain, QuotaSizeLimit size) {
        this.dao.setDomainMaxStorage(domain, Optional.of(size));
    }

    public Publisher<Void> setDomainMaxStorageReactive(Domain domain, QuotaSizeLimit size) {
        return Mono.fromRunnable(() -> this.setDomainMaxStorage(domain, size));
    }

    public void removeDomainMaxMessage(Domain domain) {
        this.dao.setDomainMaxMessage(domain, Optional.empty());
    }

    public Publisher<Void> removeDomainMaxMessageReactive(Domain domain) {
        return Mono.fromRunnable(() -> this.removeDomainMaxMessage(domain));
    }

    public void removeDomainMaxStorage(Domain domain) {
        this.dao.setDomainMaxStorage(domain, Optional.empty());
    }

    public Publisher<Void> removeDomainMaxStorageReactive(Domain domain) {
        return Mono.fromRunnable(() -> this.removeDomainMaxStorage(domain));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Optional<QuotaCountLimit> getDomainMaxMessage(Domain domain) {
        EntityManager entityManager = this.entityManagerFactory.createEntityManager();
        try {
            Optional<QuotaCountLimit> optional = this.dao.getDomainMaxMessage(entityManager, domain);
            return optional;
        }
        finally {
            EntityManagerUtils.safelyClose((EntityManager)entityManager);
        }
    }

    public Publisher<QuotaCountLimit> getDomainMaxMessageReactive(Domain domain) {
        return Mono.fromSupplier(() -> this.getDomainMaxMessage(domain)).flatMap(Mono::justOrEmpty);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Optional<QuotaSizeLimit> getDomainMaxStorage(Domain domain) {
        EntityManager entityManager = this.entityManagerFactory.createEntityManager();
        try {
            Optional<QuotaSizeLimit> optional = this.dao.getDomainMaxStorage(entityManager, domain);
            return optional;
        }
        finally {
            EntityManagerUtils.safelyClose((EntityManager)entityManager);
        }
    }

    public Publisher<QuotaSizeLimit> getDomainMaxStorageReactive(Domain domain) {
        return Mono.fromSupplier(() -> this.getDomainMaxStorage(domain)).flatMap(Mono::justOrEmpty);
    }

    public void removeMaxMessage(QuotaRoot quotaRoot) {
        this.dao.setMaxMessage(quotaRoot, Optional.empty());
    }

    public Publisher<Void> removeMaxMessageReactive(QuotaRoot quotaRoot) {
        return Mono.fromRunnable(() -> this.removeMaxMessage(quotaRoot));
    }

    public void setGlobalMaxStorage(QuotaSizeLimit globalMaxStorage) {
        this.dao.setGlobalMaxStorage(Optional.of(globalMaxStorage));
    }

    public Publisher<Void> setGlobalMaxStorageReactive(QuotaSizeLimit globalMaxStorage) {
        return Mono.fromRunnable(() -> this.setGlobalMaxStorage(globalMaxStorage));
    }

    public void removeGlobalMaxMessage() {
        this.dao.setGlobalMaxMessage(Optional.empty());
    }

    public Publisher<Void> removeGlobalMaxMessageReactive() {
        return Mono.fromRunnable(this::removeGlobalMaxMessage);
    }

    public void setGlobalMaxMessage(QuotaCountLimit globalMaxMessageCount) {
        this.dao.setGlobalMaxMessage(Optional.of(globalMaxMessageCount));
    }

    public Publisher<Void> setGlobalMaxMessageReactive(QuotaCountLimit globalMaxMessageCount) {
        return Mono.fromRunnable(() -> this.setGlobalMaxMessage(globalMaxMessageCount));
    }

    public Optional<QuotaSizeLimit> getGlobalMaxStorage() {
        EntityManager entityManager = this.entityManagerFactory.createEntityManager();
        try {
            Optional<QuotaSizeLimit> optional = this.dao.getGlobalMaxStorage(entityManager);
            return optional;
        }
        finally {
            EntityManagerUtils.safelyClose((EntityManager)entityManager);
        }
    }

    public Publisher<QuotaSizeLimit> getGlobalMaxStorageReactive() {
        return Mono.fromSupplier(this::getGlobalMaxStorage).flatMap(Mono::justOrEmpty);
    }

    public Optional<QuotaCountLimit> getGlobalMaxMessage() {
        EntityManager entityManager = this.entityManagerFactory.createEntityManager();
        try {
            Optional<QuotaCountLimit> optional = this.dao.getGlobalMaxMessage(entityManager);
            return optional;
        }
        finally {
            EntityManagerUtils.safelyClose((EntityManager)entityManager);
        }
    }

    public Publisher<QuotaCountLimit> getGlobalMaxMessageReactive() {
        return Mono.fromSupplier(this::getGlobalMaxMessage).flatMap(Mono::justOrEmpty);
    }

    public Publisher<MaxQuotaManager.QuotaDetails> quotaDetailsReactive(QuotaRoot quotaRoot) {
        EntityManager entityManager = this.entityManagerFactory.createEntityManager();
        return Mono.zip((Mono)Mono.fromCallable(() -> this.listMaxMessagesDetails(quotaRoot, entityManager)), (Mono)Mono.fromCallable(() -> this.listMaxStorageDetails(quotaRoot, entityManager))).map(tuple -> new MaxQuotaManager.QuotaDetails((Map)tuple.getT1(), (Map)tuple.getT2())).subscribeOn(Schedulers.boundedElastic()).doFinally(any -> EntityManagerUtils.safelyClose((EntityManager)entityManager));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<Quota.Scope, QuotaCountLimit> listMaxMessagesDetails(QuotaRoot quotaRoot) {
        EntityManager entityManager = this.entityManagerFactory.createEntityManager();
        try {
            ImmutableMap<Quota.Scope, QuotaCountLimit> immutableMap = this.listMaxMessagesDetails(quotaRoot, entityManager);
            return immutableMap;
        }
        finally {
            EntityManagerUtils.safelyClose((EntityManager)entityManager);
        }
    }

    private ImmutableMap<Quota.Scope, QuotaCountLimit> listMaxMessagesDetails(QuotaRoot quotaRoot, EntityManager entityManager) {
        FunctionChainer domainQuotaFunction = Throwing.function(domain -> this.dao.getDomainMaxMessage(entityManager, (Domain)domain));
        return (ImmutableMap)Stream.of(Pair.of((Object)Quota.Scope.User, this.dao.getMaxMessage(entityManager, quotaRoot)), Pair.of((Object)Quota.Scope.Domain, quotaRoot.getDomain().flatMap(domainQuotaFunction)), Pair.of((Object)Quota.Scope.Global, this.dao.getGlobalMaxMessage(entityManager))).filter(pair -> ((Optional)pair.getValue()).isPresent()).collect(ImmutableMap.toImmutableMap(Pair::getKey, value -> (QuotaCountLimit)((Optional)value.getValue()).get()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<Quota.Scope, QuotaSizeLimit> listMaxStorageDetails(QuotaRoot quotaRoot) {
        EntityManager entityManager = this.entityManagerFactory.createEntityManager();
        try {
            ImmutableMap<Quota.Scope, QuotaSizeLimit> immutableMap = this.listMaxStorageDetails(quotaRoot, entityManager);
            return immutableMap;
        }
        finally {
            EntityManagerUtils.safelyClose((EntityManager)entityManager);
        }
    }

    private ImmutableMap<Quota.Scope, QuotaSizeLimit> listMaxStorageDetails(QuotaRoot quotaRoot, EntityManager entityManager) {
        FunctionChainer domainQuotaFunction = Throwing.function(domain -> this.dao.getDomainMaxStorage(entityManager, (Domain)domain));
        return (ImmutableMap)Stream.of(Pair.of((Object)Quota.Scope.User, this.dao.getMaxStorage(entityManager, quotaRoot)), Pair.of((Object)Quota.Scope.Domain, quotaRoot.getDomain().flatMap(domainQuotaFunction)), Pair.of((Object)Quota.Scope.Global, this.dao.getGlobalMaxStorage(entityManager))).filter(pair -> ((Optional)pair.getValue()).isPresent()).collect(ImmutableMap.toImmutableMap(Pair::getKey, value -> (QuotaSizeLimit)((Optional)value.getValue()).get()));
    }

    public void removeMaxStorage(QuotaRoot quotaRoot) {
        this.dao.setMaxStorage(quotaRoot, Optional.empty());
    }

    public Publisher<Void> removeMaxStorageReactive(QuotaRoot quotaRoot) {
        return Mono.fromRunnable(() -> this.removeMaxStorage(quotaRoot));
    }

    public void removeGlobalMaxStorage() {
        this.dao.setGlobalMaxStorage(Optional.empty());
    }

    public Publisher<Void> removeGlobalMaxStorageReactive() {
        return Mono.fromRunnable(this::removeGlobalMaxStorage);
    }
}

