/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.store.mail;

import com.github.fge.lambdas.Throwing;
import com.google.common.collect.ImmutableList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import javax.mail.Flags;
import org.apache.james.mailbox.MessageManager;
import org.apache.james.mailbox.MessageUid;
import org.apache.james.mailbox.ModSeq;
import org.apache.james.mailbox.exception.MailboxException;
import org.apache.james.mailbox.model.ComposedMessageId;
import org.apache.james.mailbox.model.ComposedMessageIdWithMetaData;
import org.apache.james.mailbox.model.Mailbox;
import org.apache.james.mailbox.model.MailboxCounters;
import org.apache.james.mailbox.model.MessageMetaData;
import org.apache.james.mailbox.model.MessageRange;
import org.apache.james.mailbox.model.UpdatedFlags;
import org.apache.james.mailbox.store.FlagsUpdateCalculator;
import org.apache.james.mailbox.store.mail.model.MailboxMessage;
import org.apache.james.mailbox.store.transaction.Mapper;
import org.apache.james.util.ReactorUtils;
import org.apache.james.util.streams.Iterators;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.core.scheduler.Schedulers;

public interface MessageMapper
extends Mapper {
    public static final int UNLIMITED = -1;

    public Iterator<MailboxMessage> findInMailbox(Mailbox var1, MessageRange var2, FetchType var3, int var4) throws MailboxException;

    default public Flux<ComposedMessageIdWithMetaData> listMessagesMetadata(Mailbox mailbox, MessageRange set) {
        return this.findInMailboxReactive(mailbox, set, FetchType.METADATA, -1).map(message -> new ComposedMessageIdWithMetaData(new ComposedMessageId(message.getMailboxId(), message.getMessageId(), message.getUid()), message.createFlags(), message.getModSeq(), message.getThreadId()));
    }

    default public Flux<MailboxMessage> findInMailboxReactive(Mailbox mailbox, MessageRange set, FetchType type, int limit) {
        try {
            return Iterators.toFlux(this.findInMailbox(mailbox, set, type, limit));
        }
        catch (MailboxException e) {
            return Flux.error((Throwable)e);
        }
    }

    public List<MessageUid> retrieveMessagesMarkedForDeletion(Mailbox var1, MessageRange var2) throws MailboxException;

    default public Flux<MessageUid> retrieveMessagesMarkedForDeletionReactive(Mailbox mailbox, MessageRange messageRange) {
        return Flux.defer((Supplier)Throwing.supplier(() -> Flux.fromIterable(this.retrieveMessagesMarkedForDeletion(mailbox, messageRange))).sneakyThrow()).subscribeOn(Schedulers.boundedElastic());
    }

    public long countMessagesInMailbox(Mailbox var1) throws MailboxException;

    public MailboxCounters getMailboxCounters(Mailbox var1) throws MailboxException;

    default public Mono<MailboxCounters> getMailboxCountersReactive(Mailbox mailbox) {
        return Mono.fromCallable(() -> this.getMailboxCounters(mailbox)).subscribeOn(Schedulers.boundedElastic());
    }

    public void delete(Mailbox var1, MailboxMessage var2) throws MailboxException;

    public Map<MessageUid, MessageMetaData> deleteMessages(Mailbox var1, List<MessageUid> var2) throws MailboxException;

    default public Mono<Map<MessageUid, MessageMetaData>> deleteMessagesReactive(Mailbox mailbox, List<MessageUid> uids) {
        return Mono.fromCallable(() -> this.deleteMessages(mailbox, uids)).subscribeOn(Schedulers.boundedElastic());
    }

    public MessageUid findFirstUnseenMessageUid(Mailbox var1) throws MailboxException;

    default public Mono<Optional<MessageUid>> findFirstUnseenMessageUidReactive(Mailbox mailbox) {
        return Mono.fromCallable(() -> Optional.ofNullable(this.findFirstUnseenMessageUid(mailbox))).subscribeOn(Schedulers.boundedElastic());
    }

    public List<MessageUid> findRecentMessageUidsInMailbox(Mailbox var1) throws MailboxException;

    default public Mono<List<MessageUid>> findRecentMessageUidsInMailboxReactive(Mailbox mailbox) {
        return Mono.fromCallable(() -> this.findRecentMessageUidsInMailbox(mailbox)).subscribeOn(Schedulers.boundedElastic());
    }

    public MessageMetaData add(Mailbox var1, MailboxMessage var2) throws MailboxException;

    default public Publisher<MessageMetaData> addReactive(Mailbox mailbox, MailboxMessage message) {
        return Mono.fromCallable(() -> this.add(mailbox, message)).subscribeOn(ReactorUtils.BLOCKING_CALL_WRAPPER);
    }

    public Iterator<UpdatedFlags> updateFlags(Mailbox var1, FlagsUpdateCalculator var2, MessageRange var3) throws MailboxException;

    default public Mono<List<UpdatedFlags>> updateFlagsReactive(Mailbox mailbox, FlagsUpdateCalculator flagsUpdateCalculator, MessageRange set) {
        return Mono.fromCallable(() -> ImmutableList.copyOf(this.updateFlags(mailbox, flagsUpdateCalculator, set))).subscribeOn(Schedulers.boundedElastic());
    }

    default public Optional<UpdatedFlags> updateFlags(Mailbox mailbox, MessageUid uid, FlagsUpdateCalculator flagsUpdateCalculator) throws MailboxException {
        return Iterators.toStream(this.updateFlags(mailbox, flagsUpdateCalculator, MessageRange.one((MessageUid)uid))).findFirst();
    }

    default public List<UpdatedFlags> resetRecent(Mailbox mailbox) throws MailboxException {
        List<MessageUid> members = this.findRecentMessageUidsInMailbox(mailbox);
        ImmutableList.Builder result = ImmutableList.builder();
        FlagsUpdateCalculator calculator = new FlagsUpdateCalculator(new Flags(Flags.Flag.RECENT), MessageManager.FlagsUpdateMode.REMOVE);
        List ranges = MessageRange.toRanges(members);
        for (MessageRange range : ranges) {
            result.addAll(this.updateFlags(mailbox, calculator, range));
        }
        return result.build();
    }

    default public Mono<List<UpdatedFlags>> resetRecentReactive(Mailbox mailbox) {
        return Mono.fromCallable(() -> this.resetRecent(mailbox)).subscribeOn(Schedulers.boundedElastic());
    }

    public MessageMetaData copy(Mailbox var1, MailboxMessage var2) throws MailboxException;

    default public List<MessageMetaData> copy(Mailbox mailbox, List<MailboxMessage> original) throws MailboxException {
        return (List)original.stream().map(Throwing.function(message -> this.copy(mailbox, (MailboxMessage)message)).sneakyThrow()).collect(ImmutableList.toImmutableList());
    }

    default public Mono<MessageMetaData> copyReactive(Mailbox mailbox, MailboxMessage original) {
        return Mono.fromCallable(() -> this.copy(mailbox, original)).subscribeOn(Schedulers.boundedElastic());
    }

    default public Mono<List<MessageMetaData>> copyReactive(Mailbox mailbox, List<MailboxMessage> original) {
        return Mono.fromCallable(() -> this.copy(mailbox, original)).subscribeOn(Schedulers.boundedElastic());
    }

    public MessageMetaData move(Mailbox var1, MailboxMessage var2) throws MailboxException;

    default public List<MessageMetaData> move(Mailbox mailbox, List<MailboxMessage> original) throws MailboxException {
        return (List)original.stream().map(Throwing.function(message -> this.move(mailbox, (MailboxMessage)message)).sneakyThrow()).collect(ImmutableList.toImmutableList());
    }

    default public Mono<MessageMetaData> moveReactive(Mailbox mailbox, MailboxMessage original) {
        return Mono.fromCallable(() -> this.move(mailbox, original)).subscribeOn(Schedulers.boundedElastic());
    }

    default public Mono<List<MessageMetaData>> moveReactive(Mailbox mailbox, List<MailboxMessage> original) {
        return Flux.fromIterable(original).concatMap(message -> this.moveReactive(mailbox, (MailboxMessage)message), 16).collectList();
    }

    public Optional<MessageUid> getLastUid(Mailbox var1) throws MailboxException;

    default public Mono<Optional<MessageUid>> getLastUidReactive(Mailbox mailbox) {
        return Mono.fromCallable(() -> this.getLastUid(mailbox)).subscribeOn(Schedulers.boundedElastic());
    }

    public ModSeq getHighestModSeq(Mailbox var1) throws MailboxException;

    default public Mono<ModSeq> getHighestModSeqReactive(Mailbox mailbox) {
        return Mono.fromCallable(() -> this.getHighestModSeq(mailbox)).subscribeOn(Schedulers.boundedElastic());
    }

    public Flags getApplicableFlag(Mailbox var1) throws MailboxException;

    default public Mono<Flags> getApplicableFlagReactive(Mailbox mailbox) {
        return Mono.fromCallable(() -> this.getApplicableFlag(mailbox)).subscribeOn(Schedulers.boundedElastic());
    }

    public Flux<MessageUid> listAllMessageUids(Mailbox var1);

    public static enum FetchType {
        METADATA,
        HEADERS,
        ATTACHMENTS_METADATA,
        FULL;

    }
}

