/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.jmap.mail;

import eu.timepit.refined.api.RefType$;
import eu.timepit.refined.api.Refined;
import eu.timepit.refined.boolean;
import eu.timepit.refined.collection;
import java.io.InputStream;
import java.io.Serializable;
import org.apache.james.jmap.core.Id$;
import org.apache.james.jmap.core.Properties;
import org.apache.james.jmap.core.Properties$;
import org.apache.james.jmap.mail.EmailBodyPart$;
import org.apache.james.jmap.mail.EmailView;
import org.apache.james.jmap.mail.SpecificHeaderRequest$;
import org.apache.james.jmap.mail.UnparsedEmailId;
import org.apache.james.mailbox.model.MessageId;
import org.apache.james.mailbox.model.MessageResult;
import org.apache.james.mime4j.codec.DecodeMonitor;
import org.apache.james.mime4j.dom.Message;
import org.apache.james.mime4j.message.DefaultMessageBuilder;
import org.apache.james.mime4j.stream.MimeConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.collection.IterableOnceOps;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.collection.immutable.SetOps;
import scala.package$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;
import scala.util.Either;
import scala.util.Failure;
import scala.util.Left;
import scala.util.Right;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;

public final class Email$ {
    public static final Email$ MODULE$ = new Email$();
    private static final Logger logger = LoggerFactory.getLogger(EmailView.class);
    private static final Properties defaultProperties = Properties$.MODULE$.apply((Seq<Refined<String, boolean.Not<collection.Empty>>>)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Refined[]{new Refined((Object)((String)((Refined)RefType$.MODULE$.refinedRefType().unsafeWrap((Object)"id")).value())), new Refined((Object)((String)((Refined)RefType$.MODULE$.refinedRefType().unsafeWrap((Object)"blobId")).value())), new Refined((Object)((String)((Refined)RefType$.MODULE$.refinedRefType().unsafeWrap((Object)"threadId")).value())), new Refined((Object)((String)((Refined)RefType$.MODULE$.refinedRefType().unsafeWrap((Object)"mailboxIds")).value())), new Refined((Object)((String)((Refined)RefType$.MODULE$.refinedRefType().unsafeWrap((Object)"keywords")).value())), new Refined((Object)((String)((Refined)RefType$.MODULE$.refinedRefType().unsafeWrap((Object)"size")).value())), new Refined((Object)((String)((Refined)RefType$.MODULE$.refinedRefType().unsafeWrap((Object)"receivedAt")).value())), new Refined((Object)((String)((Refined)RefType$.MODULE$.refinedRefType().unsafeWrap((Object)"messageId")).value())), new Refined((Object)((String)((Refined)RefType$.MODULE$.refinedRefType().unsafeWrap((Object)"inReplyTo")).value())), new Refined((Object)((String)((Refined)RefType$.MODULE$.refinedRefType().unsafeWrap((Object)"references")).value())), new Refined((Object)((String)((Refined)RefType$.MODULE$.refinedRefType().unsafeWrap((Object)"sender")).value())), new Refined((Object)((String)((Refined)RefType$.MODULE$.refinedRefType().unsafeWrap((Object)"from")).value())), new Refined((Object)((String)((Refined)RefType$.MODULE$.refinedRefType().unsafeWrap((Object)"to")).value())), new Refined((Object)((String)((Refined)RefType$.MODULE$.refinedRefType().unsafeWrap((Object)"cc")).value())), new Refined((Object)((String)((Refined)RefType$.MODULE$.refinedRefType().unsafeWrap((Object)"bcc")).value())), new Refined((Object)((String)((Refined)RefType$.MODULE$.refinedRefType().unsafeWrap((Object)"replyTo")).value())), new Refined((Object)((String)((Refined)RefType$.MODULE$.refinedRefType().unsafeWrap((Object)"subject")).value())), new Refined((Object)((String)((Refined)RefType$.MODULE$.refinedRefType().unsafeWrap((Object)"sentAt")).value())), new Refined((Object)((String)((Refined)RefType$.MODULE$.refinedRefType().unsafeWrap((Object)"hasAttachment")).value())), new Refined((Object)((String)((Refined)RefType$.MODULE$.refinedRefType().unsafeWrap((Object)"preview")).value())), new Refined((Object)((String)((Refined)RefType$.MODULE$.refinedRefType().unsafeWrap((Object)"bodyValues")).value())), new Refined((Object)((String)((Refined)RefType$.MODULE$.refinedRefType().unsafeWrap((Object)"textBody")).value())), new Refined((Object)((String)((Refined)RefType$.MODULE$.refinedRefType().unsafeWrap((Object)"htmlBody")).value())), new Refined((Object)((String)((Refined)RefType$.MODULE$.refinedRefType().unsafeWrap((Object)"attachments")).value()))}));
    private static final Properties allowedProperties = Properties$.MODULE$.apply((Seq<Refined<String, boolean.Not<collection.Empty>>>)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Refined[]{new Refined((Object)((String)((Refined)RefType$.MODULE$.refinedRefType().unsafeWrap((Object)"id")).value())), new Refined((Object)((String)((Refined)RefType$.MODULE$.refinedRefType().unsafeWrap((Object)"size")).value())), new Refined((Object)((String)((Refined)RefType$.MODULE$.refinedRefType().unsafeWrap((Object)"bodyStructure")).value())), new Refined((Object)((String)((Refined)RefType$.MODULE$.refinedRefType().unsafeWrap((Object)"textBody")).value())), new Refined((Object)((String)((Refined)RefType$.MODULE$.refinedRefType().unsafeWrap((Object)"htmlBody")).value())), new Refined((Object)((String)((Refined)RefType$.MODULE$.refinedRefType().unsafeWrap((Object)"attachments")).value())), new Refined((Object)((String)((Refined)RefType$.MODULE$.refinedRefType().unsafeWrap((Object)"headers")).value())), new Refined((Object)((String)((Refined)RefType$.MODULE$.refinedRefType().unsafeWrap((Object)"bodyValues")).value())), new Refined((Object)((String)((Refined)RefType$.MODULE$.refinedRefType().unsafeWrap((Object)"messageId")).value())), new Refined((Object)((String)((Refined)RefType$.MODULE$.refinedRefType().unsafeWrap((Object)"inReplyTo")).value())), new Refined((Object)((String)((Refined)RefType$.MODULE$.refinedRefType().unsafeWrap((Object)"references")).value())), new Refined((Object)((String)((Refined)RefType$.MODULE$.refinedRefType().unsafeWrap((Object)"to")).value())), new Refined((Object)((String)((Refined)RefType$.MODULE$.refinedRefType().unsafeWrap((Object)"cc")).value())), new Refined((Object)((String)((Refined)RefType$.MODULE$.refinedRefType().unsafeWrap((Object)"bcc")).value())), new Refined((Object)((String)((Refined)RefType$.MODULE$.refinedRefType().unsafeWrap((Object)"from")).value())), new Refined((Object)((String)((Refined)RefType$.MODULE$.refinedRefType().unsafeWrap((Object)"sender")).value())), new Refined((Object)((String)((Refined)RefType$.MODULE$.refinedRefType().unsafeWrap((Object)"replyTo")).value())), new Refined((Object)((String)((Refined)RefType$.MODULE$.refinedRefType().unsafeWrap((Object)"subject")).value())), new Refined((Object)((String)((Refined)RefType$.MODULE$.refinedRefType().unsafeWrap((Object)"sentAt")).value())), new Refined((Object)((String)((Refined)RefType$.MODULE$.refinedRefType().unsafeWrap((Object)"mailboxIds")).value())), new Refined((Object)((String)((Refined)RefType$.MODULE$.refinedRefType().unsafeWrap((Object)"blobId")).value())), new Refined((Object)((String)((Refined)RefType$.MODULE$.refinedRefType().unsafeWrap((Object)"threadId")).value())), new Refined((Object)((String)((Refined)RefType$.MODULE$.refinedRefType().unsafeWrap((Object)"receivedAt")).value())), new Refined((Object)((String)((Refined)RefType$.MODULE$.refinedRefType().unsafeWrap((Object)"preview")).value())), new Refined((Object)((String)((Refined)RefType$.MODULE$.refinedRefType().unsafeWrap((Object)"hasAttachment")).value())), new Refined((Object)((String)((Refined)RefType$.MODULE$.refinedRefType().unsafeWrap((Object)"keywords")).value()))}));
    private static final Properties idProperty = Properties$.MODULE$.apply((Seq<Refined<String, boolean.Not<collection.Empty>>>)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Refined[]{new Refined((Object)((String)((Refined)RefType$.MODULE$.refinedRefType().unsafeWrap((Object)"id")).value()))}));

    private Logger logger() {
        return logger;
    }

    public Properties defaultProperties() {
        return defaultProperties;
    }

    public Properties allowedProperties() {
        return allowedProperties;
    }

    public Properties idProperty() {
        return idProperty;
    }

    public Either<IllegalArgumentException, Properties> validateProperties(Option<Properties> properties) {
        Option<Properties> option = properties;
        if (None$.MODULE$.equals(option)) {
            return package$.MODULE$.Right().apply((Object)this.defaultProperties());
        }
        if (option instanceof Some) {
            Some some = (Some)option;
            Properties properties2 = (Properties)some.value();
            Set invalidProperties = (Set)((SetOps)properties2.value().flatMap((Function1 & Serializable)property -> Email$.$anonfun$validateProperties$1((String)((Refined)property).value()))).$minus$minus(this.allowedProperties().value());
            if (invalidProperties.nonEmpty()) {
                return package$.MODULE$.Left().apply((Object)new IllegalArgumentException(new StringBuilder(41).append("The following properties [").append(((IterableOnceOps)invalidProperties.map((Function1 & Serializable)p -> (String)((Refined)p).value())).mkString(", ")).append("] do not exist.").toString()));
            }
            return package$.MODULE$.Right().apply((Object)properties2.$plus$plus(this.idProperty()));
        }
        throw new MatchError(option);
    }

    public Either<IllegalArgumentException, Properties> validateBodyProperties(Option<Properties> bodyProperties) {
        Option<Properties> option = bodyProperties;
        if (None$.MODULE$.equals(option)) {
            return package$.MODULE$.Right().apply((Object)EmailBodyPart$.MODULE$.defaultProperties());
        }
        if (option instanceof Some) {
            Some some = (Some)option;
            Properties properties = (Properties)some.value();
            Set invalidProperties = (Set)((SetOps)properties.value().flatMap((Function1 & Serializable)property -> Email$.$anonfun$validateBodyProperties$1((String)((Refined)property).value()))).$minus$minus(EmailBodyPart$.MODULE$.allowedProperties().value());
            if (invalidProperties.nonEmpty()) {
                return package$.MODULE$.Left().apply((Object)new IllegalArgumentException(new StringBuilder(45).append("The following bodyProperties [").append(((IterableOnceOps)invalidProperties.map((Function1 & Serializable)p -> (String)((Refined)p).value())).mkString(", ")).append("] do not exist.").toString()));
            }
            return package$.MODULE$.Right().apply((Object)properties);
        }
        throw new MatchError(option);
    }

    public Try<UnparsedEmailId> asUnparsed(MessageId messageId) {
        Either either = eu.timepit.refined.package$.MODULE$.refineV().apply((Object)messageId.serialize(), Id$.MODULE$.validateId());
        if (either instanceof Left) {
            Left left = (Left)either;
            String e = (String)left.value();
            return new Failure((Throwable)new IllegalArgumentException(e));
        }
        if (either instanceof Right) {
            Right right = (Right)either;
            String value = (String)((Refined)right.value()).value();
            return new Success((Object)new UnparsedEmailId(value));
        }
        throw new MatchError((Object)either);
    }

    public Try<Message> parseAsMime4JMessage(MessageResult messageResult) {
        return this.parseStreamAsMime4JMessage((Function0<InputStream>)(Function0 & Serializable)() -> messageResult.getFullContent().getInputStream());
    }

    public Try<Message> parseStreamAsMime4JMessage(Function0<InputStream> inputStream) {
        DefaultMessageBuilder defaultMessageBuilder = new DefaultMessageBuilder();
        defaultMessageBuilder.setMimeEntityConfig(MimeConfig.PERMISSIVE);
        defaultMessageBuilder.setDecodeMonitor(DecodeMonitor.SILENT);
        Try resultMessage = Try$.MODULE$.apply((Function0 & Serializable)() -> defaultMessageBuilder.parseMessage((InputStream)inputStream.apply()));
        return (Try)resultMessage.fold((Function1 & Serializable)e -> Try$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable)() -> ((InputStream)inputStream.apply()).close()).flatMap((Function1 & Serializable)closeFailure -> {
            MODULE$.logger().error(new StringBuilder(16).append("Could not close ").append(inputStream.apply()).toString(), closeFailure);
            return new Failure(e);
        }), (Function1 & Serializable)msg -> (Success)Try$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable)() -> ((InputStream)inputStream.apply()).close()).fold((Function1 & Serializable)closeFailure -> {
            MODULE$.logger().error(new StringBuilder(16).append("Could not close ").append(inputStream.apply()).toString(), closeFailure);
            return new Success(msg);
        }, (Function1 & Serializable)x$3 -> new Success(msg)));
    }

    public static final /* synthetic */ Some $anonfun$validateProperties$2(String invalidProperty) {
        return new Some((Object)new Refined((Object)invalidProperty));
    }

    public static final /* synthetic */ Option $anonfun$validateProperties$1(String property) {
        return (Option)SpecificHeaderRequest$.MODULE$.from(property).fold((Function1 & Serializable)invalidProperty -> Email$.$anonfun$validateProperties$2((String)((Refined)invalidProperty).value()), (Function1 & Serializable)x$1 -> None$.MODULE$);
    }

    public static final /* synthetic */ Some $anonfun$validateBodyProperties$2(String invalidProperty) {
        return new Some((Object)new Refined((Object)invalidProperty));
    }

    public static final /* synthetic */ Option $anonfun$validateBodyProperties$1(String property) {
        return (Option)SpecificHeaderRequest$.MODULE$.from(property).fold((Function1 & Serializable)invalidProperty -> Email$.$anonfun$validateBodyProperties$2((String)((Refined)invalidProperty).value()), (Function1 & Serializable)x$2 -> None$.MODULE$);
    }

    private Email$() {
    }
}

