/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailrepository.cassandra;

import com.datastax.oss.driver.api.core.CqlSession;
import com.datastax.oss.driver.api.core.cql.PreparedStatement;
import com.datastax.oss.driver.api.core.cql.Row;
import com.datastax.oss.driver.api.core.cql.Statement;
import com.datastax.oss.driver.api.querybuilder.QueryBuilder;
import com.datastax.oss.driver.api.querybuilder.relation.Relation;
import com.datastax.oss.driver.api.querybuilder.select.Select;
import com.datastax.oss.driver.api.querybuilder.term.Term;
import java.util.Optional;
import javax.inject.Inject;
import org.apache.james.backends.cassandra.utils.CassandraAsyncExecutor;
import org.apache.james.mailrepository.api.MailRepositoryUrl;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class UrlsDao {
    private final CassandraAsyncExecutor executor;
    private final PreparedStatement insert;
    private final PreparedStatement selectAll;
    private final PreparedStatement select;

    @Inject
    public UrlsDao(CqlSession session) {
        this.executor = new CassandraAsyncExecutor(session);
        this.insert = this.prepareInsert(session);
        this.selectAll = this.prepareSelectAll(session);
        this.select = this.prepareSelect(session);
    }

    private PreparedStatement prepareSelect(CqlSession session) {
        return session.prepare(((Select)QueryBuilder.selectFrom((String)"mailRepositoryUrls").column("url").where((Relation)Relation.column((String)"url").isEqualTo((Term)QueryBuilder.bindMarker((String)"url")))).build());
    }

    private PreparedStatement prepareSelectAll(CqlSession session) {
        return session.prepare(QueryBuilder.selectFrom((String)"mailRepositoryUrls").column("url").build());
    }

    private PreparedStatement prepareInsert(CqlSession session) {
        return session.prepare(QueryBuilder.insertInto((String)"mailRepositoryUrls").value("url", (Term)QueryBuilder.bindMarker((String)"url")).build());
    }

    public Mono<Void> addUrl(MailRepositoryUrl url) {
        return this.executor.executeVoid((Statement)this.insert.bind(new Object[0]).setString("url", url.asString()));
    }

    public Mono<Optional<MailRepositoryUrl>> retrieve(MailRepositoryUrl url) {
        return this.executor.executeSingleRowOptional((Statement)this.select.bind(new Object[0]).setString("url", url.asString())).map(optional -> optional.map(this::toUrl));
    }

    public Flux<MailRepositoryUrl> retrieveUsedUrls() {
        return this.executor.executeRows((Statement)this.selectAll.bind(new Object[0])).map(this::toUrl);
    }

    private MailRepositoryUrl toUrl(Row row) {
        return MailRepositoryUrl.from((String)row.getString("url"));
    }
}

