/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.tika;

import io.netty.buffer.Unpooled;
import io.netty.handler.codec.http.HttpHeaderNames;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.Charset;
import java.time.Duration;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.entity.ContentType;
import org.apache.james.mailbox.tika.TikaConfiguration;
import org.apache.james.mailbox.tika.TikaHttpClient;
import org.apache.james.util.ReactorUtils;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Mono;
import reactor.core.scheduler.Schedulers;
import reactor.netty.http.client.HttpClient;

public class TikaHttpClientImpl
implements TikaHttpClient {
    private static final Logger LOGGER = LoggerFactory.getLogger(TikaHttpClientImpl.class);
    private static final String RECURSIVE_METADATA_AS_TEXT_ENDPOINT = "/rmeta/text";
    private final TikaConfiguration tikaConfiguration;
    private final URI recursiveMetaData;
    private final HttpClient httpClient;

    public TikaHttpClientImpl(TikaConfiguration tikaConfiguration) throws URISyntaxException {
        this.tikaConfiguration = tikaConfiguration;
        this.recursiveMetaData = this.buildURI(tikaConfiguration).resolve(RECURSIVE_METADATA_AS_TEXT_ENDPOINT);
        this.httpClient = HttpClient.create().responseTimeout(Duration.ofMillis(tikaConfiguration.getTimeoutInMillis()));
    }

    private URI buildURI(TikaConfiguration tikaConfiguration) throws URISyntaxException {
        return new URIBuilder().setHost(tikaConfiguration.getHost()).setPort(tikaConfiguration.getPort()).setScheme("http").build();
    }

    @Override
    public Mono<InputStream> recursiveMetaDataAsJson(InputStream inputStream, org.apache.james.mailbox.model.ContentType contentType) {
        ContentType httpContentType = ContentType.create((String)contentType.mimeType().asString(), (String)contentType.charset().map(Charset::name).orElse(null));
        return ((HttpClient.RequestSender)this.httpClient.headers(headers -> headers.set((CharSequence)HttpHeaderNames.CONTENT_TYPE, (Object)httpContentType.toString())).put().uri(this.recursiveMetaData)).send((Publisher)ReactorUtils.toChunks((InputStream)inputStream, (int)16384).map(Unpooled::wrappedBuffer).subscribeOn(Schedulers.boundedElastic())).responseSingle((resp, content) -> {
            if (resp.status().code() == 200) {
                return content.asInputStream();
            }
            LOGGER.warn("Failing to call Tika for content type {} status {}", (Object)contentType, (Object)resp.status().code());
            return Mono.empty();
        }).onErrorResume(e -> {
            LOGGER.warn("Failing to call Tika for content type {}", (Object)contentType, e);
            return Mono.empty();
        });
    }
}

