/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.jspf.tester;

import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import org.apache.james.jspf.tester.ResponseGenerator;
import org.apache.james.jspf.tester.TCPListener;
import org.apache.james.jspf.tester.UDPListener;
import org.xbill.DNS.AAAARecord;
import org.xbill.DNS.ARecord;
import org.xbill.DNS.Address;
import org.xbill.DNS.CNAMERecord;
import org.xbill.DNS.DNAMERecord;
import org.xbill.DNS.Header;
import org.xbill.DNS.MXRecord;
import org.xbill.DNS.Message;
import org.xbill.DNS.NSRecord;
import org.xbill.DNS.Name;
import org.xbill.DNS.NameTooLongException;
import org.xbill.DNS.OPTRecord;
import org.xbill.DNS.PTRRecord;
import org.xbill.DNS.RRset;
import org.xbill.DNS.Record;
import org.xbill.DNS.SOARecord;
import org.xbill.DNS.SPFRecord;
import org.xbill.DNS.SetResponse;
import org.xbill.DNS.TXTRecord;
import org.xbill.DNS.TextParseException;
import org.xbill.DNS.Type;
import org.xbill.DNS.Zone;

public class DNSTestingServer
implements ResponseGenerator {
    static final int FLAG_DNSSECOK = 1;
    static final int FLAG_SIGONLY = 2;
    protected Zone zone;
    private Set<Name> timeoutServers;
    Random random = new Random();

    public DNSTestingServer(String address, String porta) throws TextParseException, IOException {
        Integer port = new Integer(porta != null ? porta : "53");
        InetAddress addr = Address.getByAddress((String)(address != null ? address : "0.0.0.0"));
        Thread t = new Thread(new TCPListener(addr, port, this));
        t.setDaemon(true);
        t.start();
        t = new Thread(new UDPListener(addr, port, this));
        t.setDaemon(true);
        t.start();
        this.zone = null;
    }

    public synchronized void setData(Map<String, List<?>> map) {
        try {
            this.timeoutServers = new HashSet<Name>();
            LinkedList<Object> records = new LinkedList<Object>();
            records.add(new SOARecord(Name.root, 1, 3600L, Name.root, Name.root, 857623948L, 0L, 0L, 0L, 0L));
            records.add(new NSRecord(Name.root, 1, 3600L, Name.root));
            for (String host : map.keySet()) {
                Name hostname = !host.endsWith(".") ? Name.fromString((String)(host + ".")) : Name.fromString((String)host);
                List<?> l = map.get(host);
                if (l == null) continue;
                for (Object o : l) {
                    if (o instanceof Map) {
                        Map hm = (Map)o;
                        for (String type : hm.keySet()) {
                            if ("MX".equals(type)) {
                                List mxList = (List)hm.get(type);
                                Iterator mxs = mxList.iterator();
                                while (mxs.hasNext()) {
                                    Long prio = (Long)mxs.next();
                                    String cname = (String)mxs.next();
                                    if (cname == null) continue;
                                    if (cname.length() > 0 && !cname.endsWith(".")) {
                                        cname = cname + ".";
                                    }
                                    records.add(new MXRecord(hostname, 1, 3600L, prio.intValue(), Name.fromString((String)cname)));
                                }
                                continue;
                            }
                            Object value = hm.get(type);
                            if ("A".equals(type)) {
                                records.add(new ARecord(hostname, 1, 3600L, Address.getByAddress((String)((String)value))));
                                continue;
                            }
                            if ("AAAA".equals(type)) {
                                records.add(new AAAARecord(hostname, 1, 3600L, Address.getByAddress((String)((String)value))));
                                continue;
                            }
                            if ("SPF".equals(type)) {
                                if (value instanceof List) {
                                    records.add(new SPFRecord(hostname, 1, 3600L, (List)value));
                                    continue;
                                }
                                records.add(new SPFRecord(hostname, 1, 3600L, (String)value));
                                continue;
                            }
                            if ("TXT".equals(type)) {
                                if (value instanceof List) {
                                    records.add(new TXTRecord(hostname, 1, 3600L, (List)value));
                                    continue;
                                }
                                records.add(new TXTRecord(hostname, 1, 3600L, (String)value));
                                continue;
                            }
                            if (!((String)value).endsWith(".")) {
                                value = (String)value + ".";
                            }
                            if ("PTR".equals(type)) {
                                records.add(new PTRRecord(hostname, 1, 3600L, Name.fromString((String)((String)value))));
                                continue;
                            }
                            if ("CNAME".equals(type)) {
                                records.add(new CNAMERecord(hostname, 1, 3600L, Name.fromString((String)((String)value))));
                                continue;
                            }
                            throw new IllegalStateException("Unsupported type: " + type);
                        }
                        continue;
                    }
                    if ("TIMEOUT".equals(o)) {
                        this.timeoutServers.add(hostname);
                        continue;
                    }
                    throw new IllegalStateException("getRecord found an unexpected data");
                }
            }
            this.zone = new Zone(Name.root, records.toArray(new Record[0]));
        }
        catch (TextParseException e) {
            e.printStackTrace();
        }
        catch (UnknownHostException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private SOARecord findSOARecord() {
        return this.zone.getSOA();
    }

    private RRset findNSRecords() {
        return this.zone.getNS();
    }

    private RRset findARecord(Name name) {
        return null;
    }

    private SetResponse findRecords(Name name, int type) {
        boolean timeout;
        SetResponse sr = this.zone.findRecords(name, type);
        if ((sr == null || sr.answers() == null || sr.answers().size() == 0) && (timeout = this.timeoutServers.contains(name))) {
            try {
                Thread.sleep(2100L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            return null;
        }
        try {
            Thread.sleep(this.random.nextInt(500));
        }
        catch (Exception exception) {
            // empty catch block
        }
        return sr;
    }

    void addRRset(Name name, Message response, RRset rrset, int section, int flags) {
        for (int s = 1; s <= section; ++s) {
            if (!response.findRRset(name, rrset.getType(), s)) continue;
            return;
        }
        if ((flags & 2) == 0) {
            for (Record r : rrset.rrs()) {
                if (r.getName().isWild() && !name.isWild()) {
                    r = r.withName(name);
                }
                response.addRecord(r, section);
            }
        }
        if ((flags & 3) != 0) {
            for (Record r : rrset.sigs()) {
                if (r.getName().isWild() && !name.isWild()) {
                    r = r.withName(name);
                }
                response.addRecord(r, section);
            }
        }
    }

    private void addGlue(Message response, Name name, int flags) {
        RRset a = this.findARecord(name);
        if (a == null) {
            return;
        }
        this.addRRset(name, response, a, 3, flags);
    }

    private void addAdditional2(Message response, int section, int flags) {
        Record[] records = response.getSectionArray(section);
        for (int i = 0; i < records.length; ++i) {
            Record r = records[i];
            Name glueName = r.getAdditionalName();
            if (glueName == null) continue;
            this.addGlue(response, glueName, flags);
        }
    }

    private final void addAdditional(Message response, int flags) {
        this.addAdditional2(response, 1, flags);
        this.addAdditional2(response, 2, flags);
    }

    byte addAnswer(Message response, Name name, int type, int dclass, int iterations, int flags) {
        SetResponse sr;
        byte rcode = 0;
        if (iterations > 6) {
            return 0;
        }
        if (type == 24 || type == 46) {
            type = 255;
            flags |= 2;
        }
        if ((sr = this.findRecords(name, type)) == null) {
            return -1;
        }
        if (sr.isNXDOMAIN() || sr.isNXRRSET()) {
            if (sr.isNXDOMAIN()) {
                response.getHeader().setRcode(3);
            }
            response.addRecord((Record)this.findSOARecord(), 2);
            if (iterations == 0) {
                response.getHeader().setFlag(5);
            }
            rcode = 3;
        } else if (sr.isDelegation()) {
            RRset nsRecords = sr.getNS();
            this.addRRset(nsRecords.getName(), response, nsRecords, 2, flags);
        } else if (sr.isCNAME()) {
            CNAMERecord cname = sr.getCNAME();
            RRset rrset = new RRset((Record)cname);
            this.addRRset(name, response, rrset, 1, flags);
            if (iterations == 0) {
                response.getHeader().setFlag(5);
            }
            rcode = this.addAnswer(response, cname.getTarget(), type, dclass, iterations + 1, flags);
        } else if (sr.isDNAME()) {
            Name newname;
            DNAMERecord dname = sr.getDNAME();
            RRset rrset = new RRset((Record)dname);
            this.addRRset(name, response, rrset, 1, flags);
            try {
                newname = name.fromDNAME(dname);
            }
            catch (NameTooLongException e) {
                return 6;
            }
            rrset = new RRset((Record)new CNAMERecord(name, dclass, 0L, newname));
            this.addRRset(name, response, rrset, 1, flags);
            if (iterations == 0) {
                response.getHeader().setFlag(5);
            }
            rcode = this.addAnswer(response, newname, type, dclass, iterations + 1, flags);
        } else if (sr.isSuccessful()) {
            List rrsets = sr.answers();
            for (int i = 0; i < rrsets.size(); ++i) {
                this.addRRset(name, response, (RRset)rrsets.get(i), 1, flags);
            }
            RRset findNSRecords = this.findNSRecords();
            this.addRRset(findNSRecords.getName(), response, findNSRecords, 2, flags);
            if (iterations == 0) {
                response.getHeader().setFlag(5);
            }
        }
        return rcode;
    }

    public byte[] generateReply(Message query, int length, Socket s) throws IOException {
        int flags = 0;
        Header header = query.getHeader();
        if (header.getFlag(0)) {
            return null;
        }
        if (header.getRcode() != 0) {
            return this.errorMessage(query, 1);
        }
        if (header.getOpcode() != 0) {
            return this.errorMessage(query, 4);
        }
        Record queryRecord = query.getQuestion();
        OPTRecord queryOPT = query.getOPT();
        if (queryOPT == null || queryOPT.getVersion() > 0) {
            // empty if block
        }
        int maxLength = s != null ? 65535 : (queryOPT != null ? Math.max(queryOPT.getPayloadSize(), 512) : 512);
        if (queryOPT != null && (queryOPT.getFlags() & 0x8000) != 0) {
            flags = 1;
        }
        Message response = new Message(query.getHeader().getID());
        response.getHeader().setFlag(0);
        if (query.getHeader().getFlag(7)) {
            response.getHeader().setFlag(7);
        }
        response.addRecord(queryRecord, 0);
        Name name = queryRecord.getName();
        int type = queryRecord.getType();
        int dclass = queryRecord.getDClass();
        if (!Type.isRR((int)type) && type != 255) {
            return this.errorMessage(query, 4);
        }
        byte rcode = this.addAnswer(response, name, type, dclass, 0, flags);
        if (rcode == -1) {
            return null;
        }
        if (rcode != 0 && rcode != 3) {
            return this.errorMessage(query, rcode);
        }
        this.addAdditional(response, flags);
        if (queryOPT != null) {
            int optflags = flags == 1 ? 32768 : 0;
            OPTRecord opt = new OPTRecord(4096, (int)rcode, 0, optflags);
            response.addRecord((Record)opt, 3);
        }
        return response.toWire(maxLength);
    }

    byte[] buildErrorMessage(Header header, int rcode, Record question) {
        Message response = new Message();
        response.setHeader(header);
        for (int i = 0; i < 4; ++i) {
            response.removeAllRecords(i);
        }
        if (rcode == 2) {
            response.addRecord(question, 0);
        }
        header.setRcode(rcode);
        return response.toWire();
    }

    public byte[] formerrMessage(byte[] in) {
        Header header;
        try {
            header = new Header(in);
        }
        catch (IOException e) {
            return null;
        }
        return this.buildErrorMessage(header, 1, null);
    }

    public byte[] errorMessage(Message query, int rcode) {
        return this.buildErrorMessage(query.getHeader(), rcode, query.getQuestion());
    }

    @Override
    public byte[] generateReply(byte[] in, int length) {
        byte[] response = null;
        try {
            Message query = new Message(in);
            response = this.generateReply(query, length, null);
        }
        catch (IOException e) {
            response = this.formerrMessage(in);
        }
        return response;
    }
}

