/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.jspf.executor;

import java.util.ArrayList;
import java.util.List;
import org.apache.james.jspf.core.DNSLookupContinuation;
import org.apache.james.jspf.core.DNSResponse;
import org.apache.james.jspf.core.DNSService;
import org.apache.james.jspf.core.SPFChecker;
import org.apache.james.jspf.core.SPFCheckerExceptionCatcher;
import org.apache.james.jspf.core.SPFSession;
import org.apache.james.jspf.core.exceptions.NeutralException;
import org.apache.james.jspf.core.exceptions.NoneException;
import org.apache.james.jspf.core.exceptions.PermErrorException;
import org.apache.james.jspf.core.exceptions.SPFResultException;
import org.apache.james.jspf.core.exceptions.TempErrorException;
import org.apache.james.jspf.core.exceptions.TimeoutException;
import org.apache.james.jspf.executor.FutureSPFResult;
import org.apache.james.jspf.executor.SPFExecutor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xbill.DNS.lookup.NoSuchRRSetException;

public class AsynchronousSPFExecutor
implements SPFExecutor {
    private static final Logger LOGGER = LoggerFactory.getLogger(AsynchronousSPFExecutor.class);
    private DNSService dnsProbe;

    public AsynchronousSPFExecutor(DNSService service) {
        this.dnsProbe = service;
    }

    @Override
    public void execute(SPFSession session, FutureSPFResult result) {
        SPFChecker checker = session.popChecker();
        if (checker == null) {
            result.setSPFResult(session);
            return;
        }
        LOGGER.debug("Executing checker: {}", (Object)checker);
        try {
            DNSLookupContinuation cont = checker.checkSPF(session);
            this.handleCont(session, result, cont, checker);
        }
        catch (Exception e) {
            this.handleError(session, e);
            result.setSPFResult(session);
        }
    }

    private void handleCont(SPFSession session, FutureSPFResult result, DNSLookupContinuation cont, SPFChecker checker) {
        if (cont != null) {
            this.dnsProbe.getRecordsAsync(cont.getRequest()).thenAccept(results -> {
                try {
                    DNSLookupContinuation dnsLookupContinuation = cont.getListener().onDNSResponse(new DNSResponse((List<String>)results), session);
                    this.handleCont(session, result, dnsLookupContinuation, checker);
                }
                catch (NeutralException | NoneException | PermErrorException | TempErrorException e) {
                    this.handleError(session, e);
                }
            }).exceptionally(e -> {
                if (e instanceof NoSuchRRSetException || e.getCause() instanceof NoSuchRRSetException) {
                    try {
                        DNSLookupContinuation dnsLookupContinuation = cont.getListener().onDNSResponse(new DNSResponse(new ArrayList<String>()), session);
                        this.handleCont(session, result, dnsLookupContinuation, checker);
                    }
                    catch (NeutralException | NoneException | PermErrorException | TempErrorException ex2) {
                        this.handleError(session, ex2);
                    }
                }
                if (e instanceof TimeoutException) {
                    this.handleTimeout(cont, new DNSResponse((TimeoutException)e), session, result, checker);
                }
                if (e.getCause() instanceof TimeoutException) {
                    this.handleTimeout(cont, new DNSResponse((TimeoutException)e.getCause()), session, result, checker);
                }
                result.setSPFResult(session);
                return null;
            });
        } else {
            this.execute(session, result);
        }
    }

    private void handleTimeout(DNSLookupContinuation cont, DNSResponse e, SPFSession session, FutureSPFResult result, SPFChecker checker) {
        try {
            DNSLookupContinuation dnsLookupContinuation = cont.getListener().onDNSResponse(e, session);
            this.handleCont(session, result, dnsLookupContinuation, checker);
        }
        catch (NeutralException | NoneException | PermErrorException | TempErrorException ex2) {
            this.handleError(session, ex2);
        }
    }

    private void handleError(SPFSession session, Exception e) {
        while (e != null) {
            SPFChecker checker = session.popChecker(c -> c instanceof SPFCheckerExceptionCatcher);
            if (checker == null) {
                throw new RuntimeException("SPFCheckerExceptionCatcher implementation not found, session: " + session, e);
            }
            try {
                ((SPFCheckerExceptionCatcher)((Object)checker)).onException(e, session);
                e = null;
            }
            catch (SPFResultException ex) {
                e = ex;
            }
        }
    }
}

