/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.consensus.pipe.metric;

import org.apache.iotdb.commons.service.metric.enums.Metric;
import org.apache.iotdb.commons.service.metric.enums.Tag;
import org.apache.iotdb.consensus.pipe.PipeConsensusServerImpl;
import org.apache.iotdb.consensus.pipe.metric.PipeConsensusSyncLagManager;
import org.apache.iotdb.metrics.AbstractMetricService;
import org.apache.iotdb.metrics.impl.DoNothingMetricManager;
import org.apache.iotdb.metrics.metricsets.IMetricSet;
import org.apache.iotdb.metrics.type.Timer;
import org.apache.iotdb.metrics.utils.MetricLevel;
import org.apache.iotdb.metrics.utils.MetricType;

public class PipeConsensusServerMetrics
implements IMetricSet {
    private final PipeConsensusServerImpl impl;
    private final PipeConsensusSyncLagManager syncLagManager;
    private Timer getStateMachineLockTimer = DoNothingMetricManager.DO_NOTHING_TIMER;
    private Timer userWriteStateMachineTimer = DoNothingMetricManager.DO_NOTHING_TIMER;
    private Timer replicaWriteStateMachineTimer = DoNothingMetricManager.DO_NOTHING_TIMER;
    private static final String IMPL = "PipeConsensusServerImpl";

    public PipeConsensusServerMetrics(PipeConsensusServerImpl impl) {
        this.impl = impl;
        this.syncLagManager = PipeConsensusSyncLagManager.getInstance(impl.getConsensusGroupId());
    }

    public void recordGetStateMachineLockTime(long costTimeInNanos) {
        this.getStateMachineLockTimer.updateNanos(costTimeInNanos);
    }

    public void recordUserWriteStateMachineTime(long costTimeInNanos) {
        this.userWriteStateMachineTimer.updateNanos(costTimeInNanos);
    }

    public void recordReplicaWriteStateMachineTime(long costTimeInNanos) {
        this.replicaWriteStateMachineTimer.updateNanos(costTimeInNanos);
    }

    public void bindTo(AbstractMetricService metricService) {
        this.bindAutoGauge(metricService);
        this.bindGauge(metricService);
        this.bindStageTimer(metricService);
    }

    public void unbindFrom(AbstractMetricService metricService) {
        this.unbindAutoGauge(metricService);
        this.unbindGauge(metricService);
        this.unbindStageTimer(metricService);
        PipeConsensusSyncLagManager.release(this.impl.getConsensusGroupId());
    }

    public void bindGauge(AbstractMetricService metricService) {
        metricService.getOrCreateGauge(Metric.PIPE_CONSENSUS_MODE.toString(), MetricLevel.IMPORTANT, new String[]{Tag.NAME.toString(), IMPL, Tag.TYPE.toString(), "replicateMode"}).set(this.impl.getReplicateMode());
    }

    public void unbindGauge(AbstractMetricService metricService) {
        metricService.remove(MetricType.GAUGE, Metric.PIPE_CONSENSUS_MODE.toString(), new String[]{Tag.NAME.toString(), IMPL, Tag.TYPE.toString(), "replicateMode"});
    }

    public void bindAutoGauge(AbstractMetricService metricService) {
        metricService.createAutoGauge(Metric.PIPE_CONSENSUS.toString(), MetricLevel.IMPORTANT, (Object)this.syncLagManager, PipeConsensusSyncLagManager::calculateSyncLag, new String[]{Tag.NAME.toString(), IMPL, Tag.REGION.toString(), this.impl.getConsensusGroupId(), Tag.TYPE.toString(), "syncLag"});
    }

    public void unbindAutoGauge(AbstractMetricService metricService) {
        metricService.remove(MetricType.AUTO_GAUGE, Metric.PIPE_CONSENSUS.toString(), new String[]{Tag.NAME.toString(), IMPL, Tag.REGION.toString(), this.impl.getConsensusGroupId(), Tag.TYPE.toString(), "syncLag"});
    }

    public void bindStageTimer(AbstractMetricService metricService) {
        this.getStateMachineLockTimer = metricService.getOrCreateTimer(Metric.STAGE.toString(), MetricLevel.IMPORTANT, new String[]{Tag.NAME.toString(), Metric.PIPE_CONSENSUS.toString(), Tag.TYPE.toString(), "getStateMachineLock", Tag.REGION.toString(), this.impl.getConsensusGroupId()});
        this.userWriteStateMachineTimer = metricService.getOrCreateTimer(Metric.STAGE.toString(), MetricLevel.IMPORTANT, new String[]{Tag.NAME.toString(), Metric.PIPE_CONSENSUS.toString(), Tag.TYPE.toString(), "userWriteStateMachine", Tag.REGION.toString(), this.impl.getConsensusGroupId()});
        this.replicaWriteStateMachineTimer = metricService.getOrCreateTimer(Metric.PIPE_RECEIVE_EVENT.toString(), MetricLevel.IMPORTANT, new String[]{Tag.NAME.toString(), Metric.PIPE_CONSENSUS.toString(), Tag.TYPE.toString(), "replicaWriteStateMachine", Tag.REGION.toString(), this.impl.getConsensusGroupId()});
    }

    public void unbindStageTimer(AbstractMetricService metricService) {
        this.getStateMachineLockTimer = DoNothingMetricManager.DO_NOTHING_TIMER;
        this.userWriteStateMachineTimer = DoNothingMetricManager.DO_NOTHING_TIMER;
        this.replicaWriteStateMachineTimer = DoNothingMetricManager.DO_NOTHING_TIMER;
        metricService.remove(MetricType.TIMER, Metric.STAGE.toString(), new String[]{Tag.NAME.toString(), Metric.PIPE_CONSENSUS.toString(), Tag.TYPE.toString(), "getStateMachineLock", Tag.REGION.toString(), this.impl.getConsensusGroupId()});
        metricService.remove(MetricType.TIMER, Metric.STAGE.toString(), new String[]{Tag.NAME.toString(), Metric.PIPE_CONSENSUS.toString(), Tag.TYPE.toString(), "writeStateMachine", Tag.REGION.toString(), this.impl.getConsensusGroupId()});
        metricService.remove(MetricType.TIMER, Metric.PIPE_RECEIVE_EVENT.toString(), new String[]{Tag.NAME.toString(), Metric.PIPE_CONSENSUS.toString(), Tag.TYPE.toString(), "replicaWriteStateMachine", Tag.REGION.toString(), this.impl.getConsensusGroupId()});
    }
}

