/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.transformation.dag.column.unary.scalar;

import java.util.Arrays;
import org.apache.iotdb.db.queryengine.transformation.dag.column.ColumnTransformer;
import org.apache.iotdb.db.queryengine.transformation.dag.column.unary.UnaryColumnTransformer;
import org.apache.tsfile.block.column.Column;
import org.apache.tsfile.block.column.ColumnBuilder;
import org.apache.tsfile.read.common.type.Type;

public class DiffFunctionColumnTransformer
extends UnaryColumnTransformer {
    private final boolean ignoreNull;
    private double lastValue;
    private boolean lastValueIsNull = true;

    public DiffFunctionColumnTransformer(Type returnType, ColumnTransformer childColumnTransformer, boolean ignoreNull) {
        super(returnType, childColumnTransformer);
        this.ignoreNull = ignoreNull;
    }

    @Override
    public void evaluateWithSelection(boolean[] selection) {
        boolean[] selectionCopy = new boolean[selection.length];
        Arrays.fill(selectionCopy, true);
        this.childColumnTransformer.evaluateWithSelection(selectionCopy);
        Column column = this.childColumnTransformer.getColumn();
        ColumnBuilder columnBuilder = this.returnType.createColumnBuilder(column.getPositionCount());
        this.doTransform(column, columnBuilder, selection);
        this.initializeColumnCache(columnBuilder.build());
        this.childColumnTransformer.clearCache();
    }

    @Override
    protected void doTransform(Column column, ColumnBuilder columnBuilder) {
        int n = column.getPositionCount();
        for (int i = 0; i < n; ++i) {
            if (column.isNull(i)) {
                columnBuilder.appendNull();
                this.lastValueIsNull |= !this.ignoreNull;
                continue;
            }
            double currValue = this.childColumnTransformer.getType().getDouble(column, i);
            if (this.lastValueIsNull) {
                columnBuilder.appendNull();
            } else {
                this.returnType.writeDouble(columnBuilder, currValue - this.lastValue);
            }
            this.lastValue = currValue;
            this.lastValueIsNull = false;
        }
    }

    @Override
    protected void doTransform(Column column, ColumnBuilder columnBuilder, boolean[] selection) {
        this.doTransform(column, columnBuilder);
    }
}

