/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.transformation.dag.column.binary;

import org.apache.iotdb.commons.exception.IoTDBRuntimeException;
import org.apache.iotdb.db.queryengine.transformation.dag.column.ColumnTransformer;
import org.apache.iotdb.db.queryengine.transformation.dag.column.binary.BinaryColumnTransformer;
import org.apache.iotdb.rpc.TSStatusCode;
import org.apache.tsfile.block.column.Column;
import org.apache.tsfile.block.column.ColumnBuilder;
import org.apache.tsfile.read.common.type.Type;

public class IntAdditionIntColumnTransformer
extends BinaryColumnTransformer {
    public IntAdditionIntColumnTransformer(Type returnType, ColumnTransformer leftTransformer, ColumnTransformer rightTransformer) {
        super(returnType, leftTransformer, rightTransformer);
    }

    @Override
    protected void doTransform(Column leftColumn, Column rightColumn, ColumnBuilder builder, int positionCount) {
        for (int i = 0; i < positionCount; ++i) {
            if (!leftColumn.isNull(i) && !rightColumn.isNull(i)) {
                this.returnType.writeInt(builder, IntAdditionIntColumnTransformer.transform(this.leftTransformer.getType().getInt(leftColumn, i), this.rightTransformer.getType().getInt(rightColumn, i)));
                continue;
            }
            builder.appendNull();
        }
    }

    @Override
    protected void doTransform(Column leftColumn, Column rightColumn, ColumnBuilder builder, int positionCount, boolean[] selection) {
        for (int i = 0; i < positionCount; ++i) {
            if (!leftColumn.isNull(i) && !rightColumn.isNull(i) && selection[i]) {
                this.returnType.writeInt(builder, IntAdditionIntColumnTransformer.transform(this.leftTransformer.getType().getInt(leftColumn, i), this.rightTransformer.getType().getInt(rightColumn, i)));
                continue;
            }
            builder.appendNull();
        }
    }

    @Override
    protected void checkType() {
    }

    public static int transform(int left, int right) {
        try {
            return Math.addExact(left, right);
        }
        catch (ArithmeticException e) {
            throw new IoTDBRuntimeException(String.format("int Addition overflow: %s + %s", left, right), TSStatusCode.NUMERIC_VALUE_OUT_OF_RANGE.getStatusCode(), false);
        }
    }
}

