/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.relational.sql.ast;

import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.AstVisitor;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.Expression;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.Node;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.NodeLocation;

public class CurrentTime
extends Expression {
    private final Function function;
    @Nullable
    private final Integer precision;

    public CurrentTime(NodeLocation location, Function function) {
        super(Objects.requireNonNull(location, "location is null"));
        this.function = Objects.requireNonNull(function, "function is null");
        this.precision = null;
    }

    public CurrentTime(NodeLocation location, Function function, Integer precision) {
        super(Objects.requireNonNull(location, "location is null"));
        this.function = Objects.requireNonNull(function, "function is null");
        this.precision = Objects.requireNonNull(precision, "precision is null");
    }

    public Function getFunction() {
        return this.function;
    }

    public Optional<Integer> getPrecision() {
        return Optional.ofNullable(this.precision);
    }

    @Override
    public <R, C> R accept(AstVisitor<R, C> visitor, C context) {
        return visitor.visitCurrentTime(this, context);
    }

    public List<Node> getChildren() {
        return ImmutableList.of();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CurrentTime that = (CurrentTime)o;
        return this.function == that.function && Objects.equals(this.precision, that.precision);
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{this.function, this.precision});
    }

    @Override
    public boolean shallowEquals(Node other) {
        if (!CurrentTime.sameClass(this, other)) {
            return false;
        }
        CurrentTime otherNode = (CurrentTime)other;
        return this.function == otherNode.function && Objects.equals(this.precision, otherNode.precision);
    }

    public static enum Function {
        TIME("current_time"),
        DATE("current_date"),
        TIMESTAMP("current_timestamp"),
        LOCALTIME("localtime"),
        LOCALTIMESTAMP("localtimestamp");

        private final String name;

        private Function(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }
    }
}

