/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.pipe.source.dataregion.historical;

import java.io.IOException;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Queue;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.iotdb.commons.consensus.DataRegionId;
import org.apache.iotdb.commons.consensus.index.ProgressIndex;
import org.apache.iotdb.commons.consensus.index.ProgressIndexType;
import org.apache.iotdb.commons.consensus.index.impl.HybridProgressIndex;
import org.apache.iotdb.commons.consensus.index.impl.RecoverProgressIndex;
import org.apache.iotdb.commons.consensus.index.impl.StateProgressIndex;
import org.apache.iotdb.commons.consensus.index.impl.TimeWindowStateProgressIndex;
import org.apache.iotdb.commons.exception.IllegalPathException;
import org.apache.iotdb.commons.pipe.agent.task.meta.PipeTaskMeta;
import org.apache.iotdb.commons.pipe.config.plugin.env.PipeTaskExtractorRuntimeEnvironment;
import org.apache.iotdb.commons.pipe.datastructure.pattern.TablePattern;
import org.apache.iotdb.commons.pipe.datastructure.pattern.TreePattern;
import org.apache.iotdb.commons.pipe.datastructure.resource.PersistentResource;
import org.apache.iotdb.commons.pipe.event.ProgressReportEvent;
import org.apache.iotdb.commons.pipe.source.IoTDBSource;
import org.apache.iotdb.commons.utils.PathUtils;
import org.apache.iotdb.consensus.pipe.PipeConsensus;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.consensus.DataRegionConsensusImpl;
import org.apache.iotdb.db.pipe.consensus.ReplicateProgressDataNodeManager;
import org.apache.iotdb.db.pipe.consensus.deletion.DeletionResource;
import org.apache.iotdb.db.pipe.consensus.deletion.DeletionResourceManager;
import org.apache.iotdb.db.pipe.event.common.deletion.PipeDeleteDataNodeEvent;
import org.apache.iotdb.db.pipe.event.common.terminate.PipeTerminateEvent;
import org.apache.iotdb.db.pipe.event.common.tsfile.PipeTsFileInsertionEvent;
import org.apache.iotdb.db.pipe.processor.pipeconsensus.PipeConsensusProcessor;
import org.apache.iotdb.db.pipe.resource.PipeDataNodeResourceManager;
import org.apache.iotdb.db.pipe.source.dataregion.DataRegionListeningFilter;
import org.apache.iotdb.db.pipe.source.dataregion.historical.PipeHistoricalDataRegionSource;
import org.apache.iotdb.db.storageengine.StorageEngine;
import org.apache.iotdb.db.storageengine.dataregion.DataRegion;
import org.apache.iotdb.db.storageengine.dataregion.memtable.TsFileProcessor;
import org.apache.iotdb.db.storageengine.dataregion.tsfile.TsFileManager;
import org.apache.iotdb.db.storageengine.dataregion.tsfile.TsFileResource;
import org.apache.iotdb.db.utils.DateTimeUtils;
import org.apache.iotdb.pipe.api.customizer.configuration.PipeExtractorRuntimeConfiguration;
import org.apache.iotdb.pipe.api.customizer.parameter.PipeParameterValidator;
import org.apache.iotdb.pipe.api.customizer.parameter.PipeParameters;
import org.apache.iotdb.pipe.api.event.Event;
import org.apache.iotdb.pipe.api.exception.PipeParameterNotValidException;
import org.apache.tsfile.file.metadata.IDeviceID;
import org.apache.tsfile.file.metadata.PlainDeviceID;
import org.apache.tsfile.utils.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PipeHistoricalDataRegionTsFileAndDeletionSource
implements PipeHistoricalDataRegionSource {
    private static final Logger LOGGER = LoggerFactory.getLogger(PipeHistoricalDataRegionTsFileAndDeletionSource.class);
    private static final Map<Integer, Long> DATA_REGION_ID_TO_PIPE_FLUSHED_TIME_MAP = new HashMap<Integer, Long>();
    private static final String TREE_MODEL_EVENT_TABLE_NAME_PREFIX = "root.";
    private String pipeName;
    private long creationTime;
    private PipeTaskMeta pipeTaskMeta;
    private ProgressIndex startIndex;
    private int dataRegionId;
    private TreePattern treePattern;
    private TablePattern tablePattern;
    private boolean isModelDetected = false;
    private boolean isTableModel;
    private boolean isDbNameCoveredByPattern = false;
    private boolean isHistoricalExtractorEnabled = false;
    private long historicalDataExtractionStartTime = Long.MIN_VALUE;
    private long historicalDataExtractionEndTime = Long.MAX_VALUE;
    private boolean sloppyTimeRange;
    private boolean sloppyPattern;
    private Pair<Boolean, Boolean> listeningOptionPair;
    private boolean shouldExtractInsertion;
    private boolean shouldExtractDeletion;
    private boolean shouldTransferModFile;
    protected String userName;
    protected boolean skipIfNoPrivileges = true;
    private boolean shouldTerminatePipeOnAllHistoricalEventsConsumed;
    private boolean isTerminateSignalSent = false;
    private boolean isForwardingPipeRequests;
    private volatile boolean hasBeenStarted = false;
    private Queue<PersistentResource> pendingQueue;
    private final Set<TsFileResource> filteredTsFileResources = new HashSet<TsFileResource>();

    public void validate(PipeParameterValidator validator) {
        PipeParameters parameters = validator.getParameters();
        try {
            this.listeningOptionPair = DataRegionListeningFilter.parseInsertionDeletionListeningOptionPair(parameters);
        }
        catch (Exception e) {
            throw new PipeParameterNotValidException(e.getMessage());
        }
        if (parameters.hasAnyAttributes(new String[]{"extractor.mode.strict", "source.mode.strict"})) {
            boolean isStrictMode = parameters.getBooleanOrDefault(Arrays.asList("extractor.mode.strict", "source.mode.strict"), true);
            this.sloppyTimeRange = !isStrictMode;
            this.sloppyPattern = !isStrictMode;
        } else {
            String extractorHistoryLooseRangeValue = parameters.getStringOrDefault(Arrays.asList("extractor.history.loose-range", "source.history.loose-range"), "").trim();
            if ("all".equalsIgnoreCase(extractorHistoryLooseRangeValue)) {
                this.sloppyTimeRange = true;
                this.sloppyPattern = true;
            } else {
                Set sloppyOptionSet = Arrays.stream(extractorHistoryLooseRangeValue.split(",")).map(String::trim).filter(s -> !s.isEmpty()).map(String::toLowerCase).collect(Collectors.toSet());
                this.sloppyTimeRange = sloppyOptionSet.remove("time");
                this.sloppyPattern = sloppyOptionSet.remove("path");
                if (!sloppyOptionSet.isEmpty()) {
                    throw new PipeParameterNotValidException(String.format("Parameters in set %s are not allowed in 'history.loose-range'", sloppyOptionSet));
                }
            }
        }
        if (parameters.hasAnyAttributes(new String[]{"source.start-time", "extractor.start-time", "source.end-time", "extractor.end-time"})) {
            this.isHistoricalExtractorEnabled = true;
            try {
                this.historicalDataExtractionStartTime = parameters.hasAnyAttributes(new String[]{"source.start-time", "extractor.start-time"}) ? DateTimeUtils.convertTimestampOrDatetimeStrToLongWithDefaultZone(parameters.getStringByKeys(new String[]{"source.start-time", "extractor.start-time"})) : Long.MIN_VALUE;
                long l = this.historicalDataExtractionEndTime = parameters.hasAnyAttributes(new String[]{"source.end-time", "extractor.end-time"}) ? DateTimeUtils.convertTimestampOrDatetimeStrToLongWithDefaultZone(parameters.getStringByKeys(new String[]{"source.end-time", "extractor.end-time"})) : Long.MAX_VALUE;
                if (this.historicalDataExtractionStartTime > this.historicalDataExtractionEndTime) {
                    throw new PipeParameterNotValidException(String.format("%s (%s) [%s] should be less than or equal to %s (%s) [%s].", "source.start-time", "extractor.start-time", this.historicalDataExtractionStartTime, "source.end-time", "extractor.end-time", this.historicalDataExtractionEndTime));
                }
            }
            catch (PipeParameterNotValidException e) {
                throw e;
            }
            catch (Exception e) {
                throw new PipeParameterNotValidException(e.getMessage());
            }
            return;
        }
        this.isHistoricalExtractorEnabled = parameters.getBooleanOrDefault("__system.restart", false) || parameters.getBooleanOrDefault(Arrays.asList("extractor.history.enable", "source.history.enable"), true);
        try {
            this.historicalDataExtractionStartTime = parameters.hasAnyAttributes(new String[]{"extractor.history.start-time", "source.history.start-time"}) ? DateTimeUtils.convertTimestampOrDatetimeStrToLongWithDefaultZone(parameters.getStringByKeys(new String[]{"extractor.history.start-time", "source.history.start-time"})) : Long.MIN_VALUE;
            long l = this.historicalDataExtractionEndTime = parameters.hasAnyAttributes(new String[]{"extractor.history.end-time", "source.history.end-time"}) ? DateTimeUtils.convertTimestampOrDatetimeStrToLongWithDefaultZone(parameters.getStringByKeys(new String[]{"extractor.history.end-time", "source.history.end-time"})) : Long.MAX_VALUE;
            if (this.historicalDataExtractionStartTime > this.historicalDataExtractionEndTime) {
                throw new PipeParameterNotValidException(String.format("%s (%s) [%s] should be less than or equal to %s (%s) [%s].", "extractor.history.start-time", "source.history.start-time", this.historicalDataExtractionStartTime, "extractor.history.end-time", "source.history.end-time", this.historicalDataExtractionEndTime));
            }
        }
        catch (Exception e) {
            throw new PipeParameterNotValidException(e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void customize(PipeParameters parameters, PipeExtractorRuntimeConfiguration configuration) throws IllegalPathException {
        String extractorModeValue;
        String databaseName;
        this.shouldExtractInsertion = (Boolean)this.listeningOptionPair.getLeft();
        this.shouldExtractDeletion = (Boolean)this.listeningOptionPair.getRight();
        if (!this.shouldExtractInsertion) {
            return;
        }
        PipeTaskExtractorRuntimeEnvironment environment = (PipeTaskExtractorRuntimeEnvironment)configuration.getRuntimeEnvironment();
        this.pipeName = environment.getPipeName();
        this.creationTime = environment.getCreationTime();
        this.pipeTaskMeta = environment.getPipeTaskMeta();
        this.startIndex = this.pipeName.startsWith("__consensus.") ? this.tryToExtractLocalProgressIndexForIoTV2(environment.getPipeTaskMeta().getProgressIndex()) : environment.getPipeTaskMeta().getProgressIndex();
        this.dataRegionId = environment.getRegionId();
        Map<Integer, Long> map = DATA_REGION_ID_TO_PIPE_FLUSHED_TIME_MAP;
        synchronized (map) {
            DATA_REGION_ID_TO_PIPE_FLUSHED_TIME_MAP.putIfAbsent(this.dataRegionId, 0L);
        }
        this.treePattern = TreePattern.parsePipePatternFromSourceParameters((PipeParameters)parameters);
        this.tablePattern = TablePattern.parsePipePatternFromSourceParameters((PipeParameters)parameters);
        DataRegion dataRegion = StorageEngine.getInstance().getDataRegion(new DataRegionId(environment.getRegionId()));
        if (Objects.nonNull(dataRegion) && Objects.nonNull(databaseName = dataRegion.getDatabaseName())) {
            this.isTableModel = PathUtils.isTableModelDatabase((String)databaseName);
            this.isModelDetected = true;
            this.isDbNameCoveredByPattern = this.isTableModel ? this.tablePattern.coversDb(databaseName) : this.treePattern.coversDb(databaseName);
        }
        this.shouldTransferModFile = parameters.hasAnyAttributes(new String[]{"extractor.mods", "source.mods"}) ? parameters.getBooleanOrDefault(Arrays.asList("extractor.mods", "source.mods"), ((Boolean)this.listeningOptionPair.getRight()).booleanValue()) : parameters.getBooleanOrDefault(Arrays.asList("source.mods.enable", "extractor.mods.enable"), ((Boolean)this.listeningOptionPair.getRight()).booleanValue());
        this.shouldTerminatePipeOnAllHistoricalEventsConsumed = parameters.hasAnyAttributes(new String[]{"extractor.mode.snapshot", "source.mode.snapshot"}) ? parameters.getBooleanOrDefault(Arrays.asList("extractor.mode.snapshot", "source.mode.snapshot"), false) : (extractorModeValue = parameters.getStringOrDefault(Arrays.asList("extractor.mode", "source.mode"), "live")).equalsIgnoreCase("snapshot") || extractorModeValue.equalsIgnoreCase("query");
        this.userName = parameters.getStringByKeys(new String[]{"extractor.user", "source.user", "extractor.username", "source.username"});
        this.skipIfNoPrivileges = IoTDBSource.getSkipIfNoPrivileges((PipeParameters)parameters);
        this.isForwardingPipeRequests = parameters.getBooleanOrDefault(Arrays.asList("extractor.forwarding-pipe-requests", "source.forwarding-pipe-requests"), true);
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("Pipe {}@{}: historical data extraction time range, start time {}({}), end time {}({}), sloppy pattern {}, sloppy time range {}, should transfer mod file {}, username: {}, skip if no privileges: {}, is forwarding pipe requests: {}", new Object[]{this.pipeName, this.dataRegionId, DateTimeUtils.convertLongToDate(this.historicalDataExtractionStartTime), this.historicalDataExtractionStartTime, DateTimeUtils.convertLongToDate(this.historicalDataExtractionEndTime), this.historicalDataExtractionEndTime, this.sloppyPattern, this.sloppyTimeRange, this.shouldTransferModFile, this.userName, this.skipIfNoPrivileges, this.isForwardingPipeRequests});
        }
    }

    private ProgressIndex tryToExtractLocalProgressIndexForIoTV2(ProgressIndex origin) {
        if (origin instanceof RecoverProgressIndex) {
            RecoverProgressIndex toBeTransformed = (RecoverProgressIndex)origin;
            return this.extractRecoverProgressIndex(toBeTransformed);
        }
        if (origin instanceof HybridProgressIndex) {
            HybridProgressIndex toBeTransformed = (HybridProgressIndex)origin;
            if (toBeTransformed.getType2Index().containsKey(ProgressIndexType.RECOVER_PROGRESS_INDEX.getType())) {
                RecoverProgressIndex specificToBeTransformed = (RecoverProgressIndex)toBeTransformed.getType2Index().get(ProgressIndexType.RECOVER_PROGRESS_INDEX.getType());
                return this.extractRecoverProgressIndex(specificToBeTransformed);
            }
            return origin;
        }
        LOGGER.warn("Pipe {}@{}: unexpected ProgressIndex type {}, fallback to origin {}.", new Object[]{this.pipeName, this.dataRegionId, origin.getType(), origin});
        return origin;
    }

    private ProgressIndex extractRecoverProgressIndex(RecoverProgressIndex toBeTransformed) {
        return new RecoverProgressIndex(toBeTransformed.getDataNodeId2LocalIndex().entrySet().stream().filter(entry -> ((Integer)entry.getKey()).equals(IoTDBDescriptor.getInstance().getConfig().getDataNodeId())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void start() {
        if (!this.shouldExtractInsertion) {
            this.hasBeenStarted = true;
            return;
        }
        if (!StorageEngine.getInstance().isReadyForNonReadWriteFunctions()) {
            LOGGER.info("Pipe {}@{}: failed to start to extract historical TsFile, storage engine is not ready. Will retry later.", (Object)this.pipeName, (Object)this.dataRegionId);
            return;
        }
        this.hasBeenStarted = true;
        DataRegion dataRegion = StorageEngine.getInstance().getDataRegion(new DataRegionId(this.dataRegionId));
        if (Objects.isNull(dataRegion)) {
            this.pendingQueue = new ArrayDeque<PersistentResource>();
            return;
        }
        long startHistoricalExtractionTime = System.currentTimeMillis();
        dataRegion.writeLock("Pipe: start to extract historical TsFile and Deletion(if uses pipeConsensus)");
        try {
            ArrayList<PersistentResource> originalResourceList = new ArrayList<PersistentResource>();
            if (this.shouldExtractInsertion) {
                this.flushTsFilesForExtraction(dataRegion);
                this.extractTsFiles(dataRegion, startHistoricalExtractionTime, originalResourceList);
            }
            if (this.shouldExtractDeletion) {
                Optional.ofNullable(DeletionResourceManager.getInstance(String.valueOf(this.dataRegionId))).ifPresent(manager -> this.extractDeletions((DeletionResourceManager)manager, (List<PersistentResource>)originalResourceList));
            }
            long startTime = System.currentTimeMillis();
            LOGGER.info("Pipe {}@{}: start to sort all extracted resources", (Object)this.pipeName, (Object)this.dataRegionId);
            originalResourceList.sort((o1, o2) -> this.startIndex instanceof TimeWindowStateProgressIndex ? Long.compare(o1.getFileStartTime(), o2.getFileStartTime()) : o1.getProgressIndex().topologicalCompareTo(o2.getProgressIndex()));
            this.pendingQueue = new ArrayDeque<PersistentResource>(originalResourceList);
            LOGGER.info("Pipe {}@{}: finish to sort all extracted resources, took {} ms", new Object[]{this.pipeName, this.dataRegionId, System.currentTimeMillis() - startTime});
        }
        finally {
            dataRegion.writeUnlock();
        }
    }

    private void flushTsFilesForExtraction(DataRegion dataRegion) {
        LOGGER.info("Pipe {}@{}: start to flush data region", (Object)this.pipeName, (Object)this.dataRegionId);
        if (this.pipeName.startsWith("__consensus.")) {
            dataRegion.syncCloseAllWorkingTsFileProcessors();
        } else {
            dataRegion.asyncCloseAllWorkingTsFileProcessors();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void extractTsFiles(DataRegion dataRegion, long startHistoricalExtractionTime, List<PersistentResource> originalResourceList) {
        TsFileManager tsFileManager = dataRegion.getTsFileManager();
        tsFileManager.readLock();
        try {
            int originalSequenceTsFileCount = tsFileManager.size(true);
            int originalUnsequenceTsFileCount = tsFileManager.size(false);
            LOGGER.info("Pipe {}@{}: start to extract historical TsFile, original sequence file count {}, original unsequence file count {}, start progress index {}", new Object[]{this.pipeName, this.dataRegionId, originalSequenceTsFileCount, originalUnsequenceTsFileCount, this.startIndex});
            Collection sequenceTsFileResources = tsFileManager.getTsFileList(true).stream().peek(originalResourceList::add).filter(resource -> this.isHistoricalExtractorEnabled && !resource.isDeleted() && (!resource.isGeneratedByPipe() || this.isForwardingPipeRequests) && (!resource.isClosed() && Optional.ofNullable(resource.getProcessor()).map(TsFileProcessor::alreadyMarkedClosing).orElse(true) != false || this.mayTsFileContainUnprocessedData((TsFileResource)resource) && this.isTsFileResourceOverlappedWithTimeRange((TsFileResource)resource) && this.mayTsFileResourceOverlappedWithPattern((TsFileResource)resource))).collect(Collectors.toList());
            this.filteredTsFileResources.addAll(sequenceTsFileResources);
            Collection unsequenceTsFileResources = tsFileManager.getTsFileList(false).stream().peek(originalResourceList::add).filter(resource -> this.isHistoricalExtractorEnabled && !resource.isDeleted() && (!resource.isGeneratedByPipe() || this.isForwardingPipeRequests) && (!resource.isClosed() && Optional.ofNullable(resource.getProcessor()).map(TsFileProcessor::alreadyMarkedClosing).orElse(true) != false || this.mayTsFileContainUnprocessedData((TsFileResource)resource) && this.isTsFileResourceOverlappedWithTimeRange((TsFileResource)resource) && this.mayTsFileResourceOverlappedWithPattern((TsFileResource)resource))).collect(Collectors.toList());
            this.filteredTsFileResources.addAll(unsequenceTsFileResources);
            this.filteredTsFileResources.removeIf(resource -> {
                try {
                    PipeDataNodeResourceManager.tsfile().pinTsFileResource((TsFileResource)resource, this.shouldTransferModFile, this.pipeName);
                    return false;
                }
                catch (IOException e) {
                    LOGGER.warn("Pipe: failed to pin TsFileResource {}", (Object)resource.getTsFilePath(), (Object)e);
                    return true;
                }
            });
            LOGGER.info("Pipe {}@{}: finish to extract historical TsFile, extracted sequence file count {}/{}, extracted unsequence file count {}/{}, extracted file count {}/{}, took {} ms", new Object[]{this.pipeName, this.dataRegionId, sequenceTsFileResources.size(), originalSequenceTsFileCount, unsequenceTsFileResources.size(), originalUnsequenceTsFileCount, this.filteredTsFileResources.size(), originalSequenceTsFileCount + originalUnsequenceTsFileCount, System.currentTimeMillis() - startHistoricalExtractionTime});
        }
        finally {
            tsFileManager.readUnlock();
        }
    }

    private boolean mayTsFileContainUnprocessedData(TsFileResource resource) {
        if (this.startIndex instanceof TimeWindowStateProgressIndex) {
            return ((TimeWindowStateProgressIndex)this.startIndex).getMinTime() <= resource.getFileEndTime();
        }
        if (this.startIndex instanceof StateProgressIndex) {
            this.startIndex = ((StateProgressIndex)this.startIndex).getInnerProgressIndex();
        }
        if (this.pipeName.startsWith("__consensus.")) {
            ProgressIndex dedicatedProgressIndex = this.tryToExtractLocalProgressIndexForIoTV2(resource.getMaxProgressIndexAfterClose());
            return this.greaterThanStartIndex(resource, dedicatedProgressIndex);
        }
        return this.greaterThanStartIndex(resource, resource.getMaxProgressIndexAfterClose());
    }

    private boolean greaterThanStartIndex(PersistentResource resource, ProgressIndex progressIndex) {
        if (!this.startIndex.isAfter(progressIndex) && !this.startIndex.equals(progressIndex)) {
            LOGGER.info("Pipe {}@{}: resource {} meets mayTsFileContainUnprocessedData condition, extractor progressIndex: {}, resource ProgressIndex: {}", new Object[]{this.pipeName, this.dataRegionId, resource, this.startIndex, progressIndex});
            return true;
        }
        return false;
    }

    private boolean mayTsFileResourceOverlappedWithPattern(TsFileResource resource) {
        Set<IDeviceID> deviceSet;
        try {
            Map<IDeviceID, Boolean> deviceIsAlignedMap = PipeDataNodeResourceManager.tsfile().getDeviceIsAlignedMapFromCache(resource.getTsFile(), false);
            deviceSet = Objects.nonNull(deviceIsAlignedMap) ? deviceIsAlignedMap.keySet() : resource.getDevices();
        }
        catch (IOException e) {
            LOGGER.warn("Pipe {}@{}: failed to get devices from TsFile {}, extract it anyway", new Object[]{this.pipeName, this.dataRegionId, resource.getTsFilePath(), e});
            return true;
        }
        return deviceSet.stream().anyMatch(deviceID -> {
            if (!this.isModelDetected) {
                this.detectModel(resource, (IDeviceID)deviceID);
                this.isModelDetected = true;
            }
            return this.isTableModel ? this.tablePattern.isTableModelDataAllowedToBeCaptured() && this.tablePattern.matchesDatabase(resource.getDatabaseName()) && this.tablePattern.matchesTable(deviceID.getTableName()) : this.treePattern.isTreeModelDataAllowedToBeCaptured() && this.treePattern.mayOverlapWithDevice(deviceID);
        });
    }

    private void detectModel(TsFileResource resource, IDeviceID deviceID) {
        this.isTableModel = !(deviceID instanceof PlainDeviceID) && !deviceID.getTableName().startsWith(TREE_MODEL_EVENT_TABLE_NAME_PREFIX) && !deviceID.getTableName().equals("root");
        String databaseName = resource.getDatabaseName();
        this.isDbNameCoveredByPattern = this.isTableModel ? this.tablePattern.isTableModelDataAllowedToBeCaptured() && this.tablePattern.coversDb(databaseName) : this.treePattern.isTreeModelDataAllowedToBeCaptured() && this.treePattern.coversDb(databaseName);
    }

    private boolean isTsFileResourceOverlappedWithTimeRange(TsFileResource resource) {
        return resource.getFileEndTime() >= this.historicalDataExtractionStartTime && this.historicalDataExtractionEndTime >= resource.getFileStartTime();
    }

    private boolean isTsFileResourceCoveredByTimeRange(TsFileResource resource) {
        return this.historicalDataExtractionStartTime <= resource.getFileStartTime() && this.historicalDataExtractionEndTime >= resource.getFileEndTime();
    }

    private void extractDeletions(DeletionResourceManager deletionResourceManager, List<PersistentResource> resourceList) {
        LOGGER.info("Pipe {}@{}: start to extract deletions", (Object)this.pipeName, (Object)this.dataRegionId);
        long startTime = System.currentTimeMillis();
        List<DeletionResource> allDeletionResources = deletionResourceManager.getAllDeletionResources();
        int originalDeletionCount = allDeletionResources.size();
        allDeletionResources.stream().filter(resource -> {
            ProgressIndex toBeCompared = resource.getProgressIndex();
            if (this.pipeName.startsWith("__consensus.")) {
                toBeCompared = this.tryToExtractLocalProgressIndexForIoTV2(toBeCompared);
            }
            return !this.greaterThanStartIndex((PersistentResource)resource, toBeCompared);
        }).forEach(DeletionResource::decreaseReference);
        allDeletionResources = allDeletionResources.stream().filter(resource -> {
            ProgressIndex toBeCompared = resource.getProgressIndex();
            if (this.pipeName.startsWith("__consensus.")) {
                toBeCompared = this.tryToExtractLocalProgressIndexForIoTV2(toBeCompared);
            }
            return this.greaterThanStartIndex((PersistentResource)resource, toBeCompared);
        }).collect(Collectors.toList());
        resourceList.addAll(allDeletionResources);
        LOGGER.info("Pipe {}@{}: finish to extract deletions, extract deletions count {}/{}, took {} ms", new Object[]{this.pipeName, this.dataRegionId, allDeletionResources.size(), originalDeletionCount, System.currentTimeMillis() - startTime});
    }

    public synchronized Event supply() {
        if (!this.hasBeenStarted && StorageEngine.getInstance().isReadyForNonReadWriteFunctions()) {
            this.start();
        }
        if (Objects.isNull(this.pendingQueue)) {
            return null;
        }
        PersistentResource resource = this.pendingQueue.poll();
        if (resource == null) {
            return this.supplyTerminateEvent();
        }
        if (resource instanceof TsFileResource) {
            return this.supplyTsFileEvent((TsFileResource)resource);
        }
        return this.supplyDeletionEvent((DeletionResource)resource);
    }

    private Event supplyTerminateEvent() {
        PipeTerminateEvent terminateEvent = new PipeTerminateEvent(this.pipeName, this.creationTime, this.pipeTaskMeta, this.dataRegionId, this.shouldTerminatePipeOnAllHistoricalEventsConsumed);
        if (!terminateEvent.increaseReferenceCount(PipeHistoricalDataRegionTsFileAndDeletionSource.class.getName())) {
            LOGGER.warn("Pipe {}@{}: failed to increase reference count for terminate event, will resend it", (Object)this.pipeName, (Object)this.dataRegionId);
            return null;
        }
        this.isTerminateSignalSent = true;
        return terminateEvent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Event supplyTsFileEvent(TsFileResource resource) {
        PipeTsFileInsertionEvent pipeTsFileInsertionEvent;
        if (!this.filteredTsFileResources.contains(resource)) {
            ProgressReportEvent progressReportEvent = new ProgressReportEvent(this.pipeName, this.creationTime, this.pipeTaskMeta, this.treePattern, this.tablePattern, this.userName, this.skipIfNoPrivileges, this.historicalDataExtractionStartTime, this.historicalDataExtractionEndTime);
            progressReportEvent.bindProgressIndex(resource.getMaxProgressIndex());
            boolean isReferenceCountIncreased = progressReportEvent.increaseReferenceCount(PipeHistoricalDataRegionTsFileAndDeletionSource.class.getName());
            if (!isReferenceCountIncreased) {
                LOGGER.warn("The reference count of the event {} cannot be increased, skipping it.", (Object)progressReportEvent);
            }
            return isReferenceCountIncreased ? progressReportEvent : null;
        }
        this.filteredTsFileResources.remove(resource);
        PipeTsFileInsertionEvent event = new PipeTsFileInsertionEvent(this.isModelDetected ? Boolean.valueOf(this.isTableModel) : null, resource.getDatabaseName(), resource, null, this.shouldTransferModFile, false, true, this.pipeName, this.creationTime, this.pipeTaskMeta, this.treePattern, this.tablePattern, this.userName, this.skipIfNoPrivileges, this.historicalDataExtractionStartTime, this.historicalDataExtractionEndTime);
        if (DataRegionConsensusImpl.getInstance() instanceof PipeConsensus && PipeConsensusProcessor.isShouldReplicate(event)) {
            event.setReplicateIndexForIoTV2(ReplicateProgressDataNodeManager.assignReplicateIndexForIoTV2(this.pipeName));
            LOGGER.info("[{}]Set {} for historical event {}", new Object[]{this.pipeName, event.getReplicateIndexForIoTV2(), event});
        }
        if (this.sloppyPattern || this.isDbNameCoveredByPattern) {
            event.skipParsingPattern();
        }
        if (this.sloppyTimeRange || this.isTsFileResourceCoveredByTimeRange(resource)) {
            event.skipParsingTime();
        }
        try {
            boolean isReferenceCountIncreased = event.increaseReferenceCount(PipeHistoricalDataRegionTsFileAndDeletionSource.class.getName());
            if (!isReferenceCountIncreased) {
                LOGGER.warn("Pipe {}@{}: failed to increase reference count for historical tsfile event {}, will discard it", new Object[]{this.pipeName, this.dataRegionId, event});
            }
            pipeTsFileInsertionEvent = isReferenceCountIncreased ? event : null;
        }
        catch (Throwable throwable) {
            try {
                PipeDataNodeResourceManager.tsfile().unpinTsFileResource(resource, this.pipeName);
            }
            catch (IOException e) {
                LOGGER.warn("Pipe {}@{}: failed to unpin TsFileResource after creating event, original path: {}", new Object[]{this.pipeName, this.dataRegionId, resource.getTsFilePath()});
            }
            throw throwable;
        }
        try {
            PipeDataNodeResourceManager.tsfile().unpinTsFileResource(resource, this.pipeName);
        }
        catch (IOException e) {
            LOGGER.warn("Pipe {}@{}: failed to unpin TsFileResource after creating event, original path: {}", new Object[]{this.pipeName, this.dataRegionId, resource.getTsFilePath()});
        }
        return pipeTsFileInsertionEvent;
    }

    private Event supplyDeletionEvent(DeletionResource deletionResource) {
        boolean isReferenceCountIncreased;
        PipeDeleteDataNodeEvent event = new PipeDeleteDataNodeEvent(deletionResource.getDeleteDataNode(), this.pipeName, this.creationTime, this.pipeTaskMeta, this.treePattern, this.tablePattern, this.userName, this.skipIfNoPrivileges, false);
        if (this.sloppyPattern || this.isDbNameCoveredByPattern) {
            event.skipParsingPattern();
        }
        if (this.sloppyTimeRange) {
            event.skipParsingTime();
        }
        if (!(isReferenceCountIncreased = event.increaseReferenceCount(PipeHistoricalDataRegionTsFileAndDeletionSource.class.getName()))) {
            LOGGER.warn("Pipe {}@{}: failed to increase reference count for historical deletion event {}, will discard it", new Object[]{this.pipeName, this.dataRegionId, event});
        } else {
            Optional.ofNullable(DeletionResourceManager.getInstance(String.valueOf(this.dataRegionId))).ifPresent(manager -> event.setDeletionResource(manager.getDeletionResource(event.getDeleteDataNode())));
        }
        return isReferenceCountIncreased ? event : null;
    }

    @Override
    public synchronized boolean hasConsumedAll() {
        return this.hasBeenStarted && (Objects.isNull(this.pendingQueue) || this.pendingQueue.isEmpty() && this.isTerminateSignalSent);
    }

    @Override
    public int getPendingQueueSize() {
        return Objects.nonNull(this.pendingQueue) ? this.pendingQueue.size() : 0;
    }

    public synchronized void close() {
        if (Objects.nonNull(this.pendingQueue)) {
            this.pendingQueue.forEach(resource -> {
                if (resource instanceof TsFileResource) {
                    try {
                        PipeDataNodeResourceManager.tsfile().unpinTsFileResource((TsFileResource)resource, this.pipeName);
                    }
                    catch (IOException e) {
                        LOGGER.warn("Pipe {}@{}: failed to unpin TsFileResource after dropping pipe, original path: {}", new Object[]{this.pipeName, this.dataRegionId, ((TsFileResource)resource).getTsFilePath()});
                    }
                }
            });
            this.pendingQueue.clear();
            this.pendingQueue = null;
        }
    }
}

