/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tsfile.write.record.datapoint;

import org.apache.tsfile.enums.TSDataType;
import org.apache.tsfile.write.chunk.ChunkWriterImpl;
import org.apache.tsfile.write.record.datapoint.DataPoint;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FloatDataPoint
extends DataPoint {
    private static final Logger LOG = LoggerFactory.getLogger(FloatDataPoint.class);
    private float value;

    public FloatDataPoint(String measurementId, float v) {
        super(TSDataType.FLOAT, measurementId);
        this.value = v;
    }

    @Override
    public void writeTo(long time, ChunkWriterImpl writer) {
        if (writer == null) {
            LOG.warn("given IChunkWriter is null, do nothing and return");
            return;
        }
        writer.write(time, this.value);
    }

    @Override
    public Object getValue() {
        return Float.valueOf(this.value);
    }

    @Override
    public void setFloat(float value) {
        this.value = value;
    }
}

