/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.pipe.source.dataregion.realtime.matcher;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.iotdb.commons.pipe.config.PipeConfig;
import org.apache.iotdb.commons.pipe.datastructure.pattern.PipePattern;
import org.apache.iotdb.db.pipe.event.common.heartbeat.PipeHeartbeatEvent;
import org.apache.iotdb.db.pipe.event.common.schema.PipeSchemaRegionWritePlanEvent;
import org.apache.iotdb.db.pipe.event.realtime.PipeRealtimeEvent;
import org.apache.iotdb.db.pipe.source.dataregion.realtime.PipeRealtimeDataRegionSource;
import org.apache.iotdb.db.pipe.source.dataregion.realtime.matcher.PipeDataRegionMatcher;
import org.apache.tsfile.utils.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CachedSchemaPatternMatcher
implements PipeDataRegionMatcher {
    protected static final Logger LOGGER = LoggerFactory.getLogger(CachedSchemaPatternMatcher.class);
    protected final ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
    protected final Set<PipeRealtimeDataRegionSource> sources = new CopyOnWriteArraySet<PipeRealtimeDataRegionSource>();
    protected final Cache<String, Set<PipeRealtimeDataRegionSource>> deviceToSourcesCache = Caffeine.newBuilder().maximumSize(PipeConfig.getInstance().getPipeSourceMatcherCacheSize()).build();

    @Override
    public void register(PipeRealtimeDataRegionSource source) {
        this.lock.writeLock().lock();
        try {
            this.sources.add(source);
            this.deviceToSourcesCache.invalidateAll();
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    @Override
    public void deregister(PipeRealtimeDataRegionSource source) {
        this.lock.writeLock().lock();
        try {
            this.sources.remove(source);
            this.deviceToSourcesCache.invalidateAll();
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    @Override
    public int getRegisterCount() {
        this.lock.readLock().lock();
        try {
            int n = this.sources.size();
            return n;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Pair<Set<PipeRealtimeDataRegionSource>, Set<PipeRealtimeDataRegionSource>> match(PipeRealtimeEvent event) {
        HashSet<PipeRealtimeDataRegionSource> matchedSources = new HashSet<PipeRealtimeDataRegionSource>();
        this.lock.readLock().lock();
        try {
            if (this.sources.isEmpty()) {
                Pair pair = new Pair(matchedSources, this.sources);
                return pair;
            }
            if (event.getEvent() instanceof PipeHeartbeatEvent) {
                Pair pair = new Pair(this.sources, (Object)Collections.EMPTY_SET);
                return pair;
            }
            if (event.getEvent() instanceof PipeSchemaRegionWritePlanEvent) {
                this.sources.stream().filter(PipeRealtimeDataRegionSource::shouldExtractDeletion).forEach(matchedSources::add);
                Pair pair = new Pair(matchedSources, this.findUnmatchedSources(matchedSources));
                return pair;
            }
            for (Map.Entry<String, String[]> entry : event.getSchemaInfo().entrySet()) {
                String device = entry.getKey();
                String[] measurements = entry.getValue();
                Set sourcesFilteredByDevice = (Set)this.deviceToSourcesCache.get((Object)device, this::filterSourcesByDevice);
                if (sourcesFilteredByDevice == null) {
                    LOGGER.warn("Match result NPE when handle device {}", (Object)device);
                    continue;
                }
                if (measurements.length == 0) {
                    matchedSources.addAll(sourcesFilteredByDevice);
                } else {
                    sourcesFilteredByDevice.forEach(source -> {
                        PipePattern pattern = source.getPipePattern();
                        if (Objects.isNull(pattern) || pattern.isRoot() || pattern.coversDevice(device)) {
                            matchedSources.add((PipeRealtimeDataRegionSource)source);
                        } else {
                            for (String measurement : measurements) {
                                if (measurement == null || !pattern.matchesMeasurement(device, measurement)) continue;
                                matchedSources.add((PipeRealtimeDataRegionSource)source);
                                break;
                            }
                        }
                    });
                }
                if (matchedSources.size() != this.sources.size()) continue;
                break;
            }
            Pair pair = new Pair(matchedSources, this.findUnmatchedSources(matchedSources));
            return pair;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    private Set<PipeRealtimeDataRegionSource> findUnmatchedSources(Set<PipeRealtimeDataRegionSource> matchedSources) {
        HashSet<PipeRealtimeDataRegionSource> unmatchedSources = new HashSet<PipeRealtimeDataRegionSource>();
        for (PipeRealtimeDataRegionSource source : this.sources) {
            if (matchedSources.contains(source)) continue;
            unmatchedSources.add(source);
        }
        return unmatchedSources;
    }

    protected Set<PipeRealtimeDataRegionSource> filterSourcesByDevice(String device) {
        HashSet<PipeRealtimeDataRegionSource> filteredSources = new HashSet<PipeRealtimeDataRegionSource>();
        for (PipeRealtimeDataRegionSource source : this.sources) {
            PipePattern pipePattern;
            if (!source.shouldExtractInsertion() || !Objects.isNull(pipePattern = source.getPipePattern()) && !pipePattern.mayOverlapWithDevice(device)) continue;
            filteredSources.add(source);
        }
        return filteredSources;
    }

    @Override
    public void clear() {
        this.lock.writeLock().lock();
        try {
            this.sources.clear();
            this.deviceToSourcesCache.invalidateAll();
            this.deviceToSourcesCache.cleanUp();
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }
}

