/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.stack.core.types.structured;

import java.util.Arrays;
import org.eclipse.milo.opcua.stack.core.serialization.SerializationContext;
import org.eclipse.milo.opcua.stack.core.serialization.UaDecoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaEncoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaStructure;
import org.eclipse.milo.opcua.stack.core.serialization.codecs.GenericDataTypeCodec;
import org.eclipse.milo.opcua.stack.core.types.builtin.ExpandedNodeId;
import org.eclipse.milo.opcua.stack.core.types.structured.ContentFilterElement;
import org.eclipse.milo.opcua.stack.core.types.structured.Structure;

public class ContentFilter
extends Structure
implements UaStructure {
    public static final ExpandedNodeId TYPE_ID = ExpandedNodeId.parse("nsu=http://opcfoundation.org/UA/;i=586");
    public static final ExpandedNodeId XML_ENCODING_ID = ExpandedNodeId.parse("nsu=http://opcfoundation.org/UA/;i=587");
    public static final ExpandedNodeId BINARY_ENCODING_ID = ExpandedNodeId.parse("nsu=http://opcfoundation.org/UA/;i=588");
    public static final ExpandedNodeId JSON_ENCODING_ID = ExpandedNodeId.parse("nsu=http://opcfoundation.org/UA/;i=15205");
    private final ContentFilterElement[] elements;

    public ContentFilter(ContentFilterElement[] elements) {
        this.elements = elements;
    }

    @Override
    public ExpandedNodeId getTypeId() {
        return TYPE_ID;
    }

    @Override
    public ExpandedNodeId getXmlEncodingId() {
        return XML_ENCODING_ID;
    }

    @Override
    public ExpandedNodeId getBinaryEncodingId() {
        return BINARY_ENCODING_ID;
    }

    public ContentFilterElement[] getElements() {
        return this.elements;
    }

    protected ContentFilter(ContentFilterBuilder<?, ?> b) {
        super(b);
        this.elements = ((ContentFilterBuilder)b).elements;
    }

    public static ContentFilterBuilder<?, ?> builder() {
        return new ContentFilterBuilderImpl();
    }

    public ContentFilterBuilder<?, ?> toBuilder() {
        return new ContentFilterBuilderImpl().$fillValuesFrom(this);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ContentFilter)) {
            return false;
        }
        ContentFilter other = (ContentFilter)o;
        if (!other.canEqual(this)) {
            return false;
        }
        return Arrays.deepEquals(this.getElements(), other.getElements());
    }

    protected boolean canEqual(Object other) {
        return other instanceof ContentFilter;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + Arrays.deepHashCode(this.getElements());
        return result;
    }

    @Override
    public String toString() {
        return "ContentFilter(elements=" + Arrays.deepToString(this.getElements()) + ")";
    }

    private static final class ContentFilterBuilderImpl
    extends ContentFilterBuilder<ContentFilter, ContentFilterBuilderImpl> {
        private ContentFilterBuilderImpl() {
        }

        @Override
        protected ContentFilterBuilderImpl self() {
            return this;
        }

        @Override
        public ContentFilter build() {
            return new ContentFilter(this);
        }
    }

    public static abstract class ContentFilterBuilder<C extends ContentFilter, B extends ContentFilterBuilder<C, B>>
    extends Structure.StructureBuilder<C, B> {
        private ContentFilterElement[] elements;

        @Override
        protected B $fillValuesFrom(C instance) {
            super.$fillValuesFrom(instance);
            ContentFilterBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return (B)this.self();
        }

        private static void $fillValuesFromInstanceIntoBuilder(ContentFilter instance, ContentFilterBuilder<?, ?> b) {
            b.elements(instance.elements);
        }

        @Override
        protected abstract B self();

        @Override
        public abstract C build();

        public B elements(ContentFilterElement[] elements) {
            this.elements = elements;
            return (B)this.self();
        }

        @Override
        public String toString() {
            return "ContentFilter.ContentFilterBuilder(super=" + super.toString() + ", elements=" + Arrays.deepToString(this.elements) + ")";
        }
    }

    public static final class Codec
    extends GenericDataTypeCodec<ContentFilter> {
        @Override
        public Class<ContentFilter> getType() {
            return ContentFilter.class;
        }

        @Override
        public ContentFilter decode(SerializationContext context, UaDecoder decoder) {
            ContentFilterElement[] elements = (ContentFilterElement[])decoder.readStructArray("Elements", ContentFilterElement.TYPE_ID);
            return new ContentFilter(elements);
        }

        @Override
        public void encode(SerializationContext context, UaEncoder encoder, ContentFilter value) {
            encoder.writeStructArray("Elements", (Object[])value.getElements(), ContentFilterElement.TYPE_ID);
        }
    }
}

