/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.rpc;

import java.io.IOException;
import java.util.Map;
import org.apache.iotdb.service.rpc.thrift.EndPoint;

public class RedirectException
extends IOException {
    private final EndPoint endPoint;
    private final Map<String, EndPoint> deviceEndPointMap;

    public RedirectException(EndPoint endpoint) {
        super("later request in same group will be redirected to " + endpoint.toString());
        this.endPoint = endpoint;
        this.deviceEndPointMap = null;
    }

    public RedirectException(Map<String, EndPoint> deviceEndPointMap) {
        super("later request in same group will be redirected to " + deviceEndPointMap);
        this.endPoint = null;
        this.deviceEndPointMap = deviceEndPointMap;
    }

    public EndPoint getEndPoint() {
        return this.endPoint;
    }

    public Map<String, EndPoint> getDeviceEndPointMap() {
        return this.deviceEndPointMap;
    }
}

