/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.cluster.server.handlers.caller;

import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.iotdb.cluster.config.ClusterDescriptor;
import org.apache.iotdb.cluster.log.Log;
import org.apache.iotdb.cluster.rpc.thrift.Node;
import org.apache.iotdb.cluster.server.member.RaftMember;
import org.apache.thrift.async.AsyncMethodCallback;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AppendGroupEntryHandler
implements AsyncMethodCallback<Long> {
    private static final Logger logger = LoggerFactory.getLogger(AppendGroupEntryHandler.class);
    private RaftMember member;
    private Log log;
    private int[] groupReceivedCounter;
    private int receiverNodeIndex;
    private Node receiverNode;
    private AtomicBoolean leaderShipStale;
    private AtomicLong newLeaderTerm;
    private int replicationNum = ClusterDescriptor.getInstance().getConfig().getReplicationNum();
    private AtomicInteger erroredNodeNum = new AtomicInteger(0);

    public AppendGroupEntryHandler(int[] groupReceivedCounter, int receiverNodeIndex, Node receiverNode, AtomicBoolean leaderShipStale, Log log, AtomicLong newLeaderTerm, RaftMember member) {
        this.groupReceivedCounter = groupReceivedCounter;
        this.receiverNodeIndex = receiverNodeIndex;
        this.receiverNode = receiverNode;
        this.leaderShipStale = leaderShipStale;
        this.log = log;
        this.newLeaderTerm = newLeaderTerm;
        this.member = member;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void onComplete(Long response) {
        if (this.leaderShipStale.get()) {
            return;
        }
        long resp = response;
        if (resp == -1L) {
            this.processAgreement();
            return;
        }
        if (resp <= 0L) return;
        int[] nArray = this.groupReceivedCounter;
        synchronized (this.groupReceivedCounter) {
            long previousNewTerm = this.newLeaderTerm.get();
            if (previousNewTerm < resp) {
                this.newLeaderTerm.set(resp);
            }
            this.leaderShipStale.set(true);
            this.groupReceivedCounter.notifyAll();
            // ** MonitorExit[var4_3] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processAgreement() {
        int[] nArray = this.groupReceivedCounter;
        synchronized (this.groupReceivedCounter) {
            logger.debug("{}: Node {} has accepted log {}", new Object[]{this.member.getName(), this.receiverNode, this.log});
            for (int i = 0; i < this.replicationNum; ++i) {
                int nodeIndex = this.receiverNodeIndex - i;
                if (nodeIndex < 0) {
                    nodeIndex += this.groupReceivedCounter.length;
                }
                int n = nodeIndex;
                this.groupReceivedCounter[n] = this.groupReceivedCounter[n] - 1;
            }
            boolean allAgreed = true;
            for (int remaining : this.groupReceivedCounter) {
                if (remaining <= 0) continue;
                allAgreed = false;
                break;
            }
            if (allAgreed) {
                this.groupReceivedCounter.notifyAll();
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void onError(Exception exception) {
        logger.error("{}: Cannot send the add node request to node {}", new Object[]{this.member.getName(), this.receiverNode, exception});
        if (this.erroredNodeNum.incrementAndGet() < this.replicationNum / 2) return;
        int[] nArray = this.groupReceivedCounter;
        synchronized (this.groupReceivedCounter) {
            logger.error("{}: Over half of the nodes failed, the request is rejected", (Object)this.member.getName());
            this.groupReceivedCounter.notifyAll();
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }
}

