/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seata.server.storage.redis.session;

import java.util.Collection;
import java.util.List;
import org.apache.seata.common.exception.StoreException;
import org.apache.seata.common.executor.Initialize;
import org.apache.seata.common.loader.LoadLevel;
import org.apache.seata.common.loader.Scope;
import org.apache.seata.core.exception.TransactionException;
import org.apache.seata.core.model.BranchStatus;
import org.apache.seata.core.model.GlobalStatus;
import org.apache.seata.server.session.AbstractSessionManager;
import org.apache.seata.server.session.BranchSession;
import org.apache.seata.server.session.GlobalSession;
import org.apache.seata.server.session.SessionCondition;
import org.apache.seata.server.storage.redis.store.RedisTransactionStoreManagerFactory;
import org.apache.seata.server.store.SessionStorable;
import org.apache.seata.server.store.TransactionStoreManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@LoadLevel(name="redis", scope=Scope.PROTOTYPE)
public class RedisSessionManager
extends AbstractSessionManager
implements Initialize {
    protected static final Logger LOGGER = LoggerFactory.getLogger(RedisSessionManager.class);

    public void init() {
        this.transactionStoreManager = RedisTransactionStoreManagerFactory.getInstance();
    }

    public void addGlobalSession(GlobalSession session) throws TransactionException {
        boolean ret = this.transactionStoreManager.writeSession(TransactionStoreManager.LogOperation.GLOBAL_ADD, (SessionStorable)session);
        if (!ret) {
            throw new StoreException("addGlobalSession failed.");
        }
    }

    public void updateGlobalSessionStatus(GlobalSession session, GlobalStatus status) throws TransactionException {
        session.setStatus(status);
        boolean ret = this.transactionStoreManager.writeSession(TransactionStoreManager.LogOperation.GLOBAL_UPDATE, (SessionStorable)session);
        if (!ret) {
            throw new StoreException("updateGlobalSessionStatus failed.");
        }
    }

    public void removeGlobalSession(GlobalSession session) throws TransactionException {
        boolean ret = this.transactionStoreManager.writeSession(TransactionStoreManager.LogOperation.GLOBAL_REMOVE, (SessionStorable)session);
        if (!ret) {
            throw new StoreException("removeGlobalSession failed.");
        }
    }

    public void addBranchSession(GlobalSession globalSession, BranchSession session) throws TransactionException {
        boolean ret = this.transactionStoreManager.writeSession(TransactionStoreManager.LogOperation.BRANCH_ADD, (SessionStorable)session);
        if (!ret) {
            throw new StoreException("addBranchSession failed.");
        }
    }

    public void updateBranchSessionStatus(BranchSession session, BranchStatus status) throws TransactionException {
        boolean ret = this.transactionStoreManager.writeSession(TransactionStoreManager.LogOperation.BRANCH_UPDATE, (SessionStorable)session);
        if (!ret) {
            throw new StoreException("updateBranchSessionStatus failed.");
        }
    }

    public void removeBranchSession(GlobalSession globalSession, BranchSession session) throws TransactionException {
        boolean ret = this.transactionStoreManager.writeSession(TransactionStoreManager.LogOperation.BRANCH_REMOVE, (SessionStorable)session);
        if (!ret) {
            throw new StoreException("removeBranchSession failed.");
        }
    }

    public GlobalSession findGlobalSession(String xid) {
        return this.findGlobalSession(xid, true);
    }

    public GlobalSession findGlobalSession(String xid, boolean withBranchSessions) {
        return this.transactionStoreManager.readSession(xid, withBranchSessions);
    }

    public Collection<GlobalSession> allSessions() {
        return this.findGlobalSessions(new SessionCondition(new GlobalStatus[]{GlobalStatus.UnKnown, GlobalStatus.Begin, GlobalStatus.Committing, GlobalStatus.CommitRetrying, GlobalStatus.Rollbacking, GlobalStatus.RollbackRetrying, GlobalStatus.TimeoutRollbacking, GlobalStatus.TimeoutRollbackRetrying, GlobalStatus.AsyncCommitting, GlobalStatus.StopRollbackOrRollbackRetry, GlobalStatus.StopCommitOrCommitRetry, GlobalStatus.Deleting}));
    }

    public List<GlobalSession> findGlobalSessions(SessionCondition condition) {
        return this.transactionStoreManager.readSession(condition);
    }

    public <T> T lockAndExecute(GlobalSession globalSession, GlobalSession.LockCallable<T> lockCallable) throws TransactionException {
        return (T)lockCallable.call();
    }
}

