/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seata.server.controller;

import org.apache.seata.common.metadata.Instance;
import org.apache.seata.common.result.Result;
import org.apache.seata.config.Configuration;
import org.apache.seata.config.ConfigurationFactory;
import org.apache.seata.core.store.MappingDO;
import org.apache.seata.server.session.SessionHolder;
import org.apache.seata.server.store.VGroupMappingStoreManager;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/vgroup/v1"})
public class VGroupMappingController {
    private VGroupMappingStoreManager vGroupMappingStoreManager;
    protected static final Configuration CONFIG = ConfigurationFactory.getInstance();

    @GetMapping(value={"/addVGroup"})
    public Result<?> addVGroup(@RequestParam String vGroup, @RequestParam String unit) {
        Result result = new Result();
        MappingDO mappingDO = new MappingDO();
        mappingDO.setNamespace(Instance.getInstance().getNamespace());
        mappingDO.setCluster(Instance.getInstance().getClusterName());
        mappingDO.setUnit(unit);
        mappingDO.setVGroup(vGroup);
        boolean rst = SessionHolder.getRootVGroupMappingManager().addVGroup(mappingDO);
        Instance.getInstance().setTerm(System.currentTimeMillis());
        if (!rst) {
            result.setCode("500");
            result.setMessage("add vGroup failed!");
        }
        return result;
    }

    @GetMapping(value={"/removeVGroup"})
    public Result<?> removeVGroup(@RequestParam String vGroup) {
        Result result = new Result();
        boolean rst = SessionHolder.getRootVGroupMappingManager().removeVGroup(vGroup);
        Instance.getInstance().setTerm(System.currentTimeMillis());
        if (!rst) {
            result.setCode("500");
            result.setMessage("remove vGroup failed!");
        }
        return result;
    }
}

