/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudwatchlogs.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.cloudwatchlogs.CloudWatchLogsAsyncClient;
import software.amazon.awssdk.services.cloudwatchlogs.internal.UserAgentUtils;
import software.amazon.awssdk.services.cloudwatchlogs.model.GetScheduledQueryHistoryRequest;
import software.amazon.awssdk.services.cloudwatchlogs.model.GetScheduledQueryHistoryResponse;
import software.amazon.awssdk.services.cloudwatchlogs.model.TriggerHistoryRecord;

public class GetScheduledQueryHistoryPublisher
implements SdkPublisher<GetScheduledQueryHistoryResponse> {
    private final CloudWatchLogsAsyncClient client;
    private final GetScheduledQueryHistoryRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public GetScheduledQueryHistoryPublisher(CloudWatchLogsAsyncClient client, GetScheduledQueryHistoryRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private GetScheduledQueryHistoryPublisher(CloudWatchLogsAsyncClient client, GetScheduledQueryHistoryRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new GetScheduledQueryHistoryResponseFetcher();
    }

    public void subscribe(Subscriber<? super GetScheduledQueryHistoryResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<TriggerHistoryRecord> triggerHistory() {
        Function<GetScheduledQueryHistoryResponse, Iterator> getIterator = response -> {
            if (response != null && response.triggerHistory() != null) {
                return response.triggerHistory().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new GetScheduledQueryHistoryResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class GetScheduledQueryHistoryResponseFetcher
    implements AsyncPageFetcher<GetScheduledQueryHistoryResponse> {
        private GetScheduledQueryHistoryResponseFetcher() {
        }

        public boolean hasNextPage(GetScheduledQueryHistoryResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<GetScheduledQueryHistoryResponse> nextPage(GetScheduledQueryHistoryResponse previousPage) {
            if (previousPage == null) {
                return GetScheduledQueryHistoryPublisher.this.client.getScheduledQueryHistory(GetScheduledQueryHistoryPublisher.this.firstRequest);
            }
            return GetScheduledQueryHistoryPublisher.this.client.getScheduledQueryHistory((GetScheduledQueryHistoryRequest)((Object)GetScheduledQueryHistoryPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

