/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.metrics;

import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.apache.iceberg.metrics.TimerResult;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="TimerResult", generator="Immutables")
@Immutable
public final class ImmutableTimerResult
implements TimerResult {
    private final TimeUnit timeUnit;
    private final Duration totalDuration;
    private final long count;

    private ImmutableTimerResult(TimeUnit timeUnit, Duration totalDuration, long count) {
        this.timeUnit = timeUnit;
        this.totalDuration = totalDuration;
        this.count = count;
    }

    @Override
    public TimeUnit timeUnit() {
        return this.timeUnit;
    }

    @Override
    public Duration totalDuration() {
        return this.totalDuration;
    }

    @Override
    public long count() {
        return this.count;
    }

    public final ImmutableTimerResult withTimeUnit(TimeUnit value) {
        TimeUnit newValue = Objects.requireNonNull(value, "timeUnit");
        if (this.timeUnit == newValue) {
            return this;
        }
        return new ImmutableTimerResult(newValue, this.totalDuration, this.count);
    }

    public final ImmutableTimerResult withTotalDuration(Duration value) {
        if (this.totalDuration == value) {
            return this;
        }
        Duration newValue = Objects.requireNonNull(value, "totalDuration");
        return new ImmutableTimerResult(this.timeUnit, newValue, this.count);
    }

    public final ImmutableTimerResult withCount(long value) {
        if (this.count == value) {
            return this;
        }
        return new ImmutableTimerResult(this.timeUnit, this.totalDuration, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableTimerResult && this.equalTo(0, (ImmutableTimerResult)another);
    }

    private boolean equalTo(int synthetic, ImmutableTimerResult another) {
        return this.timeUnit.equals((Object)another.timeUnit) && this.totalDuration.equals(another.totalDuration) && this.count == another.count;
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.timeUnit.hashCode();
        h += (h << 5) + this.totalDuration.hashCode();
        h += (h << 5) + Long.hashCode(this.count);
        return h;
    }

    public String toString() {
        return "TimerResult{timeUnit=" + this.timeUnit + ", totalDuration=" + this.totalDuration + ", count=" + this.count + "}";
    }

    public static ImmutableTimerResult copyOf(TimerResult instance) {
        if (instance instanceof ImmutableTimerResult) {
            return (ImmutableTimerResult)instance;
        }
        return ImmutableTimerResult.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="TimerResult", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_TIME_UNIT = 1L;
        private static final long INIT_BIT_TOTAL_DURATION = 2L;
        private static final long INIT_BIT_COUNT = 4L;
        private long initBits = 7L;
        @Nullable
        private TimeUnit timeUnit;
        @Nullable
        private Duration totalDuration;
        private long count;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(TimerResult instance) {
            Objects.requireNonNull(instance, "instance");
            this.timeUnit(instance.timeUnit());
            this.totalDuration(instance.totalDuration());
            this.count(instance.count());
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder timeUnit(TimeUnit timeUnit) {
            this.timeUnit = Objects.requireNonNull(timeUnit, "timeUnit");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder totalDuration(Duration totalDuration) {
            this.totalDuration = Objects.requireNonNull(totalDuration, "totalDuration");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder count(long count) {
            this.count = count;
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public ImmutableTimerResult build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableTimerResult(this.timeUnit, this.totalDuration, this.count);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("timeUnit");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("totalDuration");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("count");
            }
            return "Cannot build TimerResult, some of required attributes are not set " + attributes;
        }
    }
}

