/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.vertx.http.runtime;

import io.quarkus.tls.CertificateUpdatedEvent;
import io.vertx.core.http.HttpServer;
import jakarta.enterprise.event.Observes;
import jakarta.inject.Singleton;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CountDownLatch;
import java.util.function.BiConsumer;
import org.jboss.logging.Logger;

@Singleton
public class HttpCertificateUpdateEventListener {
    private static final Logger LOG = Logger.getLogger(HttpCertificateUpdateEventListener.class);
    private final List<ServerRegistration> servers = new CopyOnWriteArrayList<ServerRegistration>();

    public void register(HttpServer server, String tlsConfigurationName, String id) {
        this.servers.add(new ServerRegistration(server, tlsConfigurationName, id));
    }

    public void onCertificateUpdate(final @Observes CertificateUpdatedEvent event) throws InterruptedException {
        ArrayList<ServerRegistration> registrations = new ArrayList<ServerRegistration>();
        for (ServerRegistration server : this.servers) {
            if (!server.tlsConfigurationName.equalsIgnoreCase(event.name())) continue;
            registrations.add(server);
        }
        final CountDownLatch latch = new CountDownLatch(registrations.size());
        for (final ServerRegistration server : registrations) {
            server.server.updateSSLOptions(event.tlsConfiguration().getSSLOptions()).toCompletionStage().whenComplete(new BiConsumer<Boolean, Throwable>(){

                @Override
                public void accept(Boolean v, Throwable t) {
                    if (t == null) {
                        LOG.infof("The TLS configuration `%s` used by the HTTP server `%s` has been updated", (Object)event.name(), (Object)server.id);
                    } else {
                        LOG.warnf(t, "Failed to update TLS configuration `%s` for the HTTP server `%s`", (Object)event.name(), (Object)server.id);
                    }
                    latch.countDown();
                }
            });
        }
        latch.await();
    }

    record ServerRegistration(HttpServer server, String tlsConfigurationName, String id) {
    }
}

