/*
 * Decompiled with CFR 0.152.
 */
package org.apache.livy.client.common;

import java.util.List;
import java.util.Map;
import org.apache.livy.JobHandle;
import org.apache.livy.annotations.Private;

@Private
public class HttpMessages {

    public static class JobStatus
    implements ClientMessage {
        public final long id;
        public final JobHandle.State state;
        public final byte[] result;
        public final String error;

        public JobStatus(long id, JobHandle.State state, byte[] result, String error) {
            this.id = id;
            this.state = state;
            this.error = error;
            byte[] byArray = this.result = result != null && result.length > 0 ? result : null;
            if (this.result != null && state != JobHandle.State.SUCCEEDED) {
                throw new IllegalArgumentException("Result cannot be set unless job succeeded.");
            }
            if (this.result == null && error != null && state != JobHandle.State.FAILED) {
                throw new IllegalArgumentException("Error cannot be set unless job failed.");
            }
        }

        private JobStatus() {
            this(-1L, null, null, null);
        }
    }

    public static class AddResource
    implements ClientMessage {
        public final String uri;

        public AddResource(String uri) {
            this.uri = uri;
        }

        private AddResource() {
            this(null);
        }
    }

    public static class SerializedJob
    implements ClientMessage {
        public final byte[] job;
        public final String jobType;

        public SerializedJob(byte[] job, String jobType) {
            this.job = job;
            this.jobType = jobType;
        }

        private SerializedJob() {
            this(null, null);
        }
    }

    public static class SessionInfo
    implements ClientMessage {
        public final int id;
        public final String appId;
        public final String owner;
        public final String proxyUser;
        public final String state;
        public final String kind;
        public final Map<String, String> appInfo;
        public final List<String> log;

        public SessionInfo(int id, String appId, String owner, String proxyUser, String state, String kind, Map<String, String> appInfo, List<String> log) {
            this.id = id;
            this.appId = appId;
            this.owner = owner;
            this.proxyUser = proxyUser;
            this.state = state;
            this.kind = kind;
            this.appInfo = appInfo;
            this.log = log;
        }

        private SessionInfo() {
            this(-1, null, null, null, null, null, null, null);
        }
    }

    public static class CreateClientRequest
    implements ClientMessage {
        public final Map<String, String> conf;

        public CreateClientRequest(Map<String, String> conf) {
            this.conf = conf;
        }

        private CreateClientRequest() {
            this(null);
        }
    }

    public static interface ClientMessage {
    }
}

