/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.serializer.direct.util;

import org.apache.hugegraph.util.E;

public interface Id
extends Comparable<Id> {
    public static final int UUID_LENGTH = 16;

    public Object asObject();

    public String asString();

    public long asLong();

    public byte[] asBytes();

    public int length();

    public IdType type();

    default public boolean number() {
        return this.type() == IdType.LONG;
    }

    default public boolean uuid() {
        return this.type() == IdType.UUID;
    }

    default public boolean string() {
        return this.type() == IdType.STRING;
    }

    default public boolean edge() {
        return this.type() == IdType.EDGE;
    }

    public static enum IdType {
        UNKNOWN,
        LONG,
        UUID,
        STRING,
        EDGE;


        public char prefix() {
            if (this == UNKNOWN) {
                return 'N';
            }
            return this.name().charAt(0);
        }

        public static IdType valueOfPrefix(String id) {
            E.checkArgument(id != null && id.length() > 0, "Invalid id '%s'", id);
            switch (id.charAt(0)) {
                case 'L': {
                    return LONG;
                }
                case 'U': {
                    return UUID;
                }
                case 'S': {
                    return STRING;
                }
                case 'E': {
                    return EDGE;
                }
            }
            return UNKNOWN;
        }
    }
}

