/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.computer.k8s.crd.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.HashMap;
import java.util.Map;

public enum JobComponentState {
    PENDING("Pending"),
    RUNNING("Running"),
    SUCCEEDED("Succeeded"),
    FAILED("Failed"),
    CANCELLED("Cancelled"),
    UNKNOWN("Unknown");

    private final String value;
    private static final Map<String, JobComponentState> CONSTANTS;

    private JobComponentState(String value) {
        this.value = value;
    }

    public String toString() {
        return this.value;
    }

    @JsonValue
    public String value() {
        return this.value;
    }

    @JsonCreator
    public static JobComponentState fromValue(String value) {
        JobComponentState constant = CONSTANTS.get(value);
        if (constant == null) {
            throw new IllegalArgumentException(value);
        }
        return constant;
    }

    static {
        CONSTANTS = new HashMap<String, JobComponentState>();
        for (JobComponentState c : JobComponentState.values()) {
            CONSTANTS.put(c.value, c);
        }
    }
}

